/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuDb_Au;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.3.1", indexColumns={"RbSlotNumber"})
public class RbSwAuConfigEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = 2558435826781674909L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbSlotNumber;
    private Integer rbAuUnitControl;
    private String rbAuUpgradeSwFileName;
    private Integer rbAuAirInterfaceType;
    private String rbAuSuUpgradeSwFileName;
    private Integer rbAuSuUpgradeSwAction;
    public static final int RbAuUnitControlNone = 1;
    public static final int RbAuUnitControlReset = 2;
    public static final int RbAuUnitControlPutToShadow = 3;
    public static final int RbAuUnitControlResetAndRunFromShadow = 4;
    public static final int RbAuUnitControlMakeRunningVersionOperational = 5;
    public static final int RbAuAirInterfaceTypeUnknown = 0;
    public static final int RbAuAirInterfaceTypeA = 1;
    public static final int RbAuAirInterfaceTypeSI = 2;
    public static final int RbAuSuUpgradeSwActionNone = 1;
    public static final int RbAuSuUpgradeSwActionPutToShadow = 3;
    public static final int RbAuSuUpgradeSwActionRunFromShadow = 4;
    public static final int RbAuSuUpgradeSwActionMakeShadowOperational = 5;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.11", type=2)
    @ConfigAttribute
    public Integer getRbAuUnitControl() {
        return this.rbAuUnitControl;
    }

    public void setRbAuUnitControl(Integer rbAuUnitControl) {
        this.rbAuUnitControl = rbAuUnitControl;
    }

    public static String toStringRbAuUnitControl(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "reset(2)";
                break;
            }
            case 3: {
                result = "putToShadow(3)";
                break;
            }
            case 4: {
                result = "resetAndRunFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeRunningVersionOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.17", type=-128)
    @ConfigAttribute
    public String getRbAuUpgradeSwFileName() {
        return this.rbAuUpgradeSwFileName;
    }

    public void setRbAuUpgradeSwFileName(String rbAuUpgradeSwFileName) {
        this.rbAuUpgradeSwFileName = rbAuUpgradeSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.21", type=2)
    @InventoryAttribute
    public Integer getRbAuAirInterfaceType() {
        return this.rbAuAirInterfaceType;
    }

    public void setRbAuAirInterfaceType(Integer rbAuAirInterfaceType) {
        this.rbAuAirInterfaceType = rbAuAirInterfaceType;
    }

    public static String toStringRbAuAirInterfaceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "type-a(1)";
                break;
            }
            case 2: {
                result = "type-si(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.28", type=-128)
    @ConfigAttribute
    public String getRbAuSuUpgradeSwFileName() {
        return this.rbAuSuUpgradeSwFileName;
    }

    public void setRbAuSuUpgradeSwFileName(String rbAuSuUpgradeSwFileName) {
        this.rbAuSuUpgradeSwFileName = rbAuSuUpgradeSwFileName;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.29", type=2)
    @ConfigAttribute
    public Integer getRbAuSuUpgradeSwAction() {
        return this.rbAuSuUpgradeSwAction;
    }

    public void setRbAuSuUpgradeSwAction(Integer rbAuSuUpgradeSwAction) {
        this.rbAuSuUpgradeSwAction = rbAuSuUpgradeSwAction;
    }

    public static String toStringRbAuSuUpgradeSwAction(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 3: {
                result = "putToShadow(3)";
                break;
            }
            case 4: {
                result = "runFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeShadowOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbAuUnitControl=").append(RbSwAuConfigEntry.toStringRbAuUnitControl(this.rbAuUnitControl)).append(", ");
        result.append("rbAuUpgradeSwFileName=").append(this.rbAuUpgradeSwFileName).append(", ");
        result.append("rbAuAirInterfaceType=").append(RbSwAuConfigEntry.toStringRbAuAirInterfaceType(this.rbAuAirInterfaceType)).append(", ");
        result.append("rbAuSuUpgradeSwFileName=").append(this.rbAuSuUpgradeSwFileName).append(", ");
        result.append("rbAuSuUpgradeSwAction=").append(RbSwAuConfigEntry.toStringRbAuSuUpgradeSwAction(this.rbAuSuUpgradeSwAction)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.rbSlotNumber.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSwAuConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSwAuConfigEntry>(){

            public ManagedObjectAccessHandler<RbSwAuConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSwAuConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSwAuConfigEntry>(){

            public ManagedObjectAccessHandler<RbSwAuConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSwAuConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbSwAuConfigEntry, AuDb_Au> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbSwAuConfigEntry createEntry() {
            return new RbSwAuConfigEntry();
        }

        @Override
        protected Class<AuDb_Au> getDataObjectClass() {
            return AuDb_Au.class;
        }

        @Override
        protected void populateEntry(RbSwAuConfigEntry entry, AuDb_Au dataObject) {
            entry.setRbSlotNumber(ConfigFileUtil.configFileAUIDToRbSlotNumber(dataObject.getAUID()));
            entry.setRbAuUpgradeSwFileName(dataObject.getSWFileName());
        }
    }
}

