/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.mo.RbSUTableRowMOAccessHandler;
import com.bwanms.rb.model.RbSU;
import com.bwanms.validation.WeakNotNull;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@AlwaysValidate
@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.1.1", indexColumns={"RbSuMacAddr"})
public class RbSuSystemEntry
extends ScalarMO {
    private static final long serialVersionUID = 5502200266719809710L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private String rbSuOrganizationName;
    private String rbSuAddress;
    private String rbSuCountry;
    private String rbSuMacAddr;
    private String rbSuSysName;
    private String rbSuOperSwVersion;
    private String rbSuShadowSwVersion;
    private Integer rbSuRunningSoftware;
    private String rbSuInstallerPassword;
    public static final int RbSuRunningSoftwareOperational = 1;
    public static final int RbSuRunningSoftwareShadow = 2;
    public static final int RbSuRunningSoftwareUnknown = 3;

    @Transient
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112, readOnly=true)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @WeakNotNull
    @Length(min=1, max=32)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.7", type=-128)
    @ConfigAttribute
    public String getRbSuSysName() {
        return this.rbSuSysName;
    }

    public void setRbSuSysName(String rbSuSysName) {
        this.rbSuSysName = rbSuSysName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.11", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbSuOperSwVersion() {
        return this.rbSuOperSwVersion;
    }

    public void setRbSuOperSwVersion(String rbSuOperSwVersion) {
        this.rbSuOperSwVersion = rbSuOperSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.13", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbSuShadowSwVersion() {
        return this.rbSuShadowSwVersion;
    }

    public void setRbSuShadowSwVersion(String rbSuShadowSwVersion) {
        this.rbSuShadowSwVersion = rbSuShadowSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.14", type=2, readOnly=true)
    @InventoryAttribute
    public Integer getRbSuRunningSoftware() {
        return this.rbSuRunningSoftware;
    }

    public void setRbSuRunningSoftware(Integer rbSuRunningSoftware) {
        this.rbSuRunningSoftware = rbSuRunningSoftware;
    }

    public String toStringRbSuRunningSoftware(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "operational(1)";
                break;
            }
            case 2: {
                result = "shadow(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.31", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbSuOrganizationName() {
        return this.rbSuOrganizationName;
    }

    public void setRbSuOrganizationName(String rbSuOrganizationName) {
        this.rbSuOrganizationName = rbSuOrganizationName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.32", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbSuAddress() {
        return this.rbSuAddress;
    }

    public void setRbSuAddress(String rbSuAddress) {
        this.rbSuAddress = rbSuAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.33", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbSuCountry() {
        return this.rbSuCountry;
    }

    public void setRbSuCountry(String rbSuCountry) {
        this.rbSuCountry = rbSuCountry;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.23", type=-128)
    @ConfigAttribute
    @Length(min=1, max=20)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getRbSuInstallerPassword() {
        return this.rbSuInstallerPassword;
    }

    public void setRbSuInstallerPassword(String rbSuInstallerPassword) {
        this.rbSuInstallerPassword = rbSuInstallerPassword;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuSystemEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuSystemEntry>(){

            public ManagedObjectAccessHandler<RbSuSystemEntry> createHandler() {
                return new RbSUTableRowMOAccessHandler<RbSuSystemEntry>(RbSuSystemEntry.class){

                    @Override
                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbSuSystemEntry managedObject) throws MediationException {
                        if (((RbSU)eq).getOperationMode().equals(2)) {
                            managedObject.setRbSuSysName(null);
                        }
                        super.update(eq, access, networkResource, managedObject);
                    }
                };
            }
        });
    }
}

