/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.2.1", indexColumns={"RbSubDeviceIpAddress"})
public class RbSuSubDevicesEntry
extends StaticTableRowMO {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbSubDeviceIpAddress;
    private String rbSuMacAddress;
    private Integer rbSubDeviceType;
    public static final int RbSubDeviceTypeVgDataVoice = 4;
    public static final int RbSubDeviceTypeVgData1Voice1 = 5;
    public static final int RbSubDeviceTypeVgData4Voice2 = 6;
    public static final int RbSubDeviceTypeVgDataVoice2 = 7;
    public static final int RbSubDeviceTypeNgData4Wireless = 11;
    public static final int RbSubDeviceTypeWiNetworksMSG = 23;
    public static final int RbSubDeviceTypeVgIDUDataVoice1 = 12;
    public static final int RbSubDeviceTypeVgIDUDataVoice2 = 13;
    public static final int RbSubDeviceTypeVgSRU24NData1Voice1 = 14;
    public static final int RbSubDeviceTypeVgSRU24NData1Voice2 = 15;
    public static final int RbSubDeviceTypeVgIDU24N2Data1Voice1 = 16;
    public static final int RbSubDeviceTypeVgIDU24NData1Voice2 = 17;
    public static final int RbSubDeviceTypeVgSRUTecom = 18;
    private Integer rbSubDeviceVlanID;
    private Integer rbSubDeviceProtocol;
    public static final int RbSubDeviceProtocolUnknown = 0;
    public static final int RbSubDeviceProtocolDrap = 1;
    public static final int RbSubDeviceProtocolDynamic = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.2.1.1", type=64)
    @IdentifierAttribute
    public String getRbSubDeviceIpAddress() {
        return this.rbSubDeviceIpAddress;
    }

    public void setRbSubDeviceIpAddress(String rbSubDeviceIpAddress) {
        this.rbSubDeviceIpAddress = rbSubDeviceIpAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.2.1.2", type=112)
    @InventoryAttribute
    public String getRbSuMacAddress() {
        return this.rbSuMacAddress;
    }

    public void setRbSuMacAddress(String rbSuMacAddress) {
        this.rbSuMacAddress = rbSuMacAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.2.1.3", type=2)
    @InventoryAttribute
    public Integer getRbSubDeviceType() {
        return this.rbSubDeviceType;
    }

    public void setRbSubDeviceType(Integer rbSubDeviceType) {
        this.rbSubDeviceType = rbSubDeviceType;
    }

    public static String toStringRbSubDeviceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 4: {
                result = "vgDataVoice(4)";
                break;
            }
            case 5: {
                result = "vgData1Voice1(5)";
                break;
            }
            case 6: {
                result = "vgData4Voice2(6)";
                break;
            }
            case 7: {
                result = "vgDataVoice2(7)";
                break;
            }
            case 11: {
                result = "ngData4Wireless(11)";
                break;
            }
            case 12: {
                result = "vgIduDv1(12)";
                break;
            }
            case 13: {
                result = "vgIduDv2(13)";
                break;
            }
            case 14: {
                result = "vgSruFt1d1v(14)";
                break;
            }
            case 15: {
                result = "vgSruFt1d2v(15)";
                break;
            }
            case 16: {
                result = "vgIduDvFt1d1v(16)";
                break;
            }
            case 17: {
                result = "vgIduDvFt1d2v(17)";
                break;
            }
            case 18: {
                result = "vgSru(18)";
                break;
            }
            case 23: {
                result = "winetworksMSG(23)";
                break;
            }
            default: {
                result = "undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.2.1.4", type=2)
    @InventoryAttribute
    public Integer getRbSubDeviceVlanID() {
        return this.rbSubDeviceVlanID;
    }

    public void setRbSubDeviceVlanID(Integer rbSubDeviceVlanID) {
        this.rbSubDeviceVlanID = rbSubDeviceVlanID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.2.1.5", type=2)
    @Filter(filterClass=VersionFilter.class, values={"managerBSSoftwareVersion", ">=4.2"})
    @InventoryAttribute
    public Integer getRbSubDeviceProtocol() {
        return this.rbSubDeviceProtocol;
    }

    public void setRbSubDeviceProtocol(Integer rbSubDeviceProtocol) {
        this.rbSubDeviceProtocol = rbSubDeviceProtocol;
    }

    public static String toStringRbSubDeviceProtocol(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "drap(1)";
                break;
            }
            case 2: {
                result = "dynamic(2)";
                break;
            }
            default: {
                result = "undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSubDeviceIpAddress=").append(this.rbSubDeviceIpAddress).append(", ");
        result.append("rbSuMacAddress=").append(this.rbSuMacAddress).append(", ");
        result.append("rbSubDeviceType=").append(RbSuSubDevicesEntry.toStringRbSubDeviceType(this.rbSubDeviceType)).append(", ");
        result.append("rbSubDeviceVlanID=").append(this.rbSubDeviceVlanID).append(", ");
        result.append("rbSubDeviceProtocol=").append(this.rbSubDeviceProtocol);
        result.append("]");
        return result.toString();
    }

    @Transient
    public boolean isVgPresent() {
        return Integer.valueOf(4).equals(this.rbSubDeviceType) || Integer.valueOf(5).equals(this.rbSubDeviceType) || Integer.valueOf(6).equals(this.rbSubDeviceType) || Integer.valueOf(7).equals(this.rbSubDeviceType) || Integer.valueOf(12).equals(this.rbSubDeviceType) || Integer.valueOf(13).equals(this.rbSubDeviceType) || Integer.valueOf(14).equals(this.rbSubDeviceType) || Integer.valueOf(15).equals(this.rbSubDeviceType) || Integer.valueOf(16).equals(this.rbSubDeviceType) || Integer.valueOf(17).equals(this.rbSubDeviceType) || Integer.valueOf(18).equals(this.rbSubDeviceType) || Integer.valueOf(11).equals(this.rbSubDeviceType) || Integer.valueOf(23).equals(this.rbSubDeviceType);
    }

    @Transient
    public boolean isNgPresent() {
        return Integer.valueOf(11).equals(this.rbSubDeviceType) || Integer.valueOf(23).equals(this.rbSubDeviceType);
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuSubDevicesEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuSubDevicesEntry>(){

            public ManagedObjectAccessHandler<RbSuSubDevicesEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSuSubDevicesEntry.class);
            }
        });
    }
}

