/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.validation.Values;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbSuPhyParametersGroup
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer suPhyCurrentBandwidth;
    private String suPhyCurrentTxFrequencyChannel;
    private Integer suPhyConfiguredBandwidth;
    private String suPhyConfiguredTxFrequencyChannel;
    public static final int SuPhyCurrentBandwidthB175 = 1;
    public static final int SuPhyCurrentBandwidthB35 = 2;
    public static final int SuPhyCurrentBandwidthB50 = 3;
    public static final int SuPhyCurrentBandwidthB70 = 4;
    public static final int SuPhyCurrentBandwidthB100 = 5;
    public static final int SuPhyConfiguredBandwidthB175 = 1;
    public static final int SuPhyConfiguredBandwidthB35 = 2;
    public static final int SuPhyConfiguredBandwidthB50 = 3;
    public static final int SuPhyConfiguredBandwidthB70 = 4;
    public static final int SuPhyConfiguredBandwidthB100 = 5;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.9.1", type=2)
    @StateAttribute
    @Values(values={1, 2, 3, 4, 5}, toStringConvertorMethodName="toStringSuPhyCurrentBandwidth")
    public Integer getSuPhyCurrentBandwidth() {
        return this.suPhyCurrentBandwidth;
    }

    public void setSuPhyCurrentBandwidth(Integer suPhyCurrentBandwidth) {
        this.suPhyCurrentBandwidth = suPhyCurrentBandwidth;
    }

    public static String toStringSuPhyCurrentBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "NA(0)";
                break;
            }
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.9.2", type=-128)
    @Column(name="suPhyCurrentTxFreqChannel")
    @StateAttribute
    public String getSuPhyCurrentTxFrequencyChannel() {
        return this.suPhyCurrentTxFrequencyChannel;
    }

    public void setSuPhyCurrentTxFrequencyChannel(String suPhyCurrentTxFrequencyChannel) {
        this.suPhyCurrentTxFrequencyChannel = suPhyCurrentTxFrequencyChannel;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.9.3", type=2)
    @ConfigAttribute
    @Values(values={1, 2, 3, 4, 5}, toStringConvertorMethodName="toStringSuPhyConfiguredBandwidth")
    public Integer getSuPhyConfiguredBandwidth() {
        return this.suPhyConfiguredBandwidth;
    }

    public void setSuPhyConfiguredBandwidth(Integer suPhyConfiguredBandwidth) {
        this.suPhyConfiguredBandwidth = suPhyConfiguredBandwidth;
    }

    public static String toStringSuPhyConfiguredBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "N/A(0)";
                break;
            }
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.9.4", type=-128)
    @Column(name="suPhyConfiguredTxFreqChannel")
    @ConfigAttribute
    public String getSuPhyConfiguredTxFrequencyChannel() {
        return this.suPhyConfiguredTxFrequencyChannel;
    }

    public void setSuPhyConfiguredTxFrequencyChannel(String suPhyConfiguredTxFrequencyChannel) {
        this.suPhyConfiguredTxFrequencyChannel = suPhyConfiguredTxFrequencyChannel;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("suPhyCurrentBandwidth=").append(RbSuPhyParametersGroup.toStringSuPhyCurrentBandwidth(this.suPhyCurrentBandwidth)).append(", ");
        result.append("suPhyCurrentTxFrequencyChannel=").append(this.suPhyCurrentTxFrequencyChannel).append(", ");
        result.append("suPhyConfiguredBandwidth=").append(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(this.suPhyConfiguredBandwidth)).append(", ");
        result.append("suPhyConfiguredTxFrequencyChannel=").append(this.suPhyConfiguredTxFrequencyChannel).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuPhyParametersGroup.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuPhyParametersGroup>(){

            public ManagedObjectAccessHandler<RbSuPhyParametersGroup> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSuPhyParametersGroup.class);
            }
        });
    }
}

