/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.FiltersOn;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbSuMultirateParametersGroup
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String rbSuTxPower;
    private String rbSuUlSNR;
    private String rbSuUlRSSI;
    private Integer rbSuUlCurrentRate;
    private String rbSuDlSNR;
    private String rbSuDlRSSI;
    private Integer rbSuDlCurrentRate;
    private Integer rbSuMultirateSupport;
    private Long rbSuEstDistance;
    private Integer rbSuUlMinDataRate;
    private Integer rbSuDlMinDataRate;
    private Integer rbSuUlRateBelowMinimum;
    private Integer rbSuDlRateBelowMinimum;
    private Integer rbSuUlCh1RSSIValue;
    private Integer rbSuUlCh2RSSIValue;
    private Integer rbSuUlCh3RSSIValue;
    private Integer rbSuUlCh4RSSIValue;
    public static final int RbSuUlCurrentRateNotDefined = 0;
    public static final int RbSuUlCurrentRateRBpsk12 = 1;
    public static final int RbSuUlCurrentRateRBpsk34 = 2;
    public static final int RbSuUlCurrentRateRQpsk12 = 3;
    public static final int RbSuUlCurrentRateRQpsk34 = 4;
    public static final int RbSuUlCurrentRateR16Qam12 = 5;
    public static final int RbSuUlCurrentRateR16Qam34 = 6;
    public static final int RbSuUlCurrentRateR64Qam23 = 7;
    public static final int RbSuUlCurrentRateR64Qam34 = 8;
    public static final int RbSuDlCurrentRateNotDefined = 0;
    public static final int RbSuDlCurrentRateRBpsk12 = 1;
    public static final int RbSuDlCurrentRateRBpsk34 = 2;
    public static final int RbSuDlCurrentRateRQpsk12 = 3;
    public static final int RbSuDlCurrentRateRQpsk34 = 4;
    public static final int RbSuDlCurrentRateR16Qam12 = 5;
    public static final int RbSuDlCurrentRateR16Qam34 = 6;
    public static final int RbSuDlCurrentRateR64Qam23 = 7;
    public static final int RbSuDlCurrentRateR64Qam34 = 8;
    public static final int RbSuMultirateSupportEnabled = 1;
    public static final int RbSuMultirateSupportDisabled = 2;
    public static final int RbSuMultirateSupportNotDefined = 3;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.1", type=-128)
    @StateAttribute
    public String getRbSuTxPower() {
        return this.rbSuTxPower;
    }

    public void setRbSuTxPower(String rbSuTxPower) {
        this.rbSuTxPower = rbSuTxPower;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.3", type=-128)
    @StateAttribute
    public String getRbSuUlSNR() {
        return this.rbSuUlSNR;
    }

    public void setRbSuUlSNR(String rbSuUlSNR) {
        this.rbSuUlSNR = rbSuUlSNR;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.4", type=-128)
    @StateAttribute
    public String getRbSuUlRSSI() {
        return this.rbSuUlRSSI;
    }

    public void setRbSuUlRSSI(String rbSuUlRSSI) {
        this.rbSuUlRSSI = rbSuUlRSSI;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.5", type=2)
    @ConfigAttribute
    public Integer getRbSuUlCurrentRate() {
        return this.rbSuUlCurrentRate;
    }

    public void setRbSuUlCurrentRate(Integer rbSuUlCurrentRate) {
        this.rbSuUlCurrentRate = rbSuUlCurrentRate;
    }

    public static String toStringRbSuUlCurrentRate(Integer value) {
        return RbSuMultirateParametersGroup.toStringRbSuRate(value);
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.6", type=-128)
    @StateAttribute
    public String getRbSuDlSNR() {
        return this.rbSuDlSNR;
    }

    public void setRbSuDlSNR(String rbSuDlSNR) {
        this.rbSuDlSNR = rbSuDlSNR;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.7", type=-128)
    @StateAttribute
    public String getRbSuDlRSSI() {
        return this.rbSuDlRSSI;
    }

    public void setRbSuDlRSSI(String rbSuDlRSSI) {
        this.rbSuDlRSSI = rbSuDlRSSI;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.8", type=2)
    @ConfigAttribute
    public Integer getRbSuDlCurrentRate() {
        return this.rbSuDlCurrentRate;
    }

    public void setRbSuDlCurrentRate(Integer rbSuDlCurrentRate) {
        this.rbSuDlCurrentRate = rbSuDlCurrentRate;
    }

    public static String toStringRbSuDlCurrentRate(Integer value) {
        return RbSuMultirateParametersGroup.toStringRbSuRate(value);
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.9", type=2)
    @StateAttribute
    public Integer getRbSuMultirateSupport() {
        return this.rbSuMultirateSupport;
    }

    public void setRbSuMultirateSupport(Integer rbSuMultirateSupport) {
        this.rbSuMultirateSupport = rbSuMultirateSupport;
    }

    public static String toStringRbSuMultirateSupport(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enabled(1)";
                break;
            }
            case 2: {
                result = "disabled(2)";
                break;
            }
            case 3: {
                result = "notDefined(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.10", type=66)
    @StateAttribute
    public Long getRbSuEstDistance() {
        return this.rbSuEstDistance;
    }

    public void setRbSuEstDistance(Long rbSuEstDistance) {
        this.rbSuEstDistance = rbSuEstDistance;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.15", type=2)
    @ConfigAttribute
    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"}), @Filter(filterClass=VersionFilter.class, values={"managerBS.softwareVersion", ">=3.0"})})
    public Integer getRbSuUlMinDataRate() {
        return this.rbSuUlMinDataRate;
    }

    public void setRbSuUlMinDataRate(Integer rbSuUlBasicRate) {
        this.rbSuUlMinDataRate = rbSuUlBasicRate;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.16", type=2)
    @ConfigAttribute
    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"}), @Filter(filterClass=VersionFilter.class, values={"managerBS.softwareVersion", ">=3.0"})})
    public Integer getRbSuDlMinDataRate() {
        return this.rbSuDlMinDataRate;
    }

    public void setRbSuDlMinDataRate(Integer rbSuDlBasicRate) {
        this.rbSuDlMinDataRate = rbSuDlBasicRate;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.17", type=2)
    @StateAttribute
    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"}), @Filter(filterClass=VersionFilter.class, values={"managerBS.softwareVersion", ">=3.0"})})
    public Integer getRbSuUlRateBelowMinimum() {
        return this.rbSuUlRateBelowMinimum;
    }

    public void setRbSuUlRateBelowMinimum(Integer rbSuUlRateBelowMinimum) {
        this.rbSuUlRateBelowMinimum = rbSuUlRateBelowMinimum;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.18", type=2)
    @StateAttribute
    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"}), @Filter(filterClass=VersionFilter.class, values={"managerBS.softwareVersion", ">=3.0"})})
    public Integer getRbSuDlRateBelowMinimum() {
        return this.rbSuDlRateBelowMinimum;
    }

    public void setRbSuDlRateBelowMinimum(Integer rbSuDlRateBelowMinimum) {
        this.rbSuDlRateBelowMinimum = rbSuDlRateBelowMinimum;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.19", type=2)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    public Integer getRbSuUlCh1RSSIValue() {
        return this.rbSuUlCh1RSSIValue;
    }

    public void setRbSuUlCh1RSSIValue(Integer rbSuUlCh1RSSIValue) {
        this.rbSuUlCh1RSSIValue = rbSuUlCh1RSSIValue;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.20", type=2)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    public Integer getRbSuUlCh2RSSIValue() {
        return this.rbSuUlCh2RSSIValue;
    }

    public void setRbSuUlCh2RSSIValue(Integer rbSuUlCh2RSSIValue) {
        this.rbSuUlCh2RSSIValue = rbSuUlCh2RSSIValue;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.21", type=2)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    public Integer getRbSuUlCh3RSSIValue() {
        return this.rbSuUlCh3RSSIValue;
    }

    public void setRbSuUlCh3RSSIValue(Integer rbSuUlCh3RSSIValue) {
        this.rbSuUlCh3RSSIValue = rbSuUlCh3RSSIValue;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.22", type=2)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    public Integer getRbSuUlCh4RSSIValue() {
        return this.rbSuUlCh4RSSIValue;
    }

    public void setRbSuUlCh4RSSIValue(Integer rbSuUlCh4RSSIValue) {
        this.rbSuUlCh4RSSIValue = rbSuUlCh4RSSIValue;
    }

    public static String toStringRbSuRateBelowMinimum(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "yes(1)";
                break;
            }
            case 2: {
                result = "no(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbSuRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined(0)";
                break;
            }
            case 1: {
                result = "rBpsk12(1)";
                break;
            }
            case 2: {
                result = "rBpsk34(2)";
                break;
            }
            case 3: {
                result = "rQpsk12(3)";
                break;
            }
            case 4: {
                result = "rQpsk34(4)";
                break;
            }
            case 5: {
                result = "r16Qam12(5)";
                break;
            }
            case 6: {
                result = "r16Qam34(6)";
                break;
            }
            case 7: {
                result = "r64Qam23(7)";
                break;
            }
            case 8: {
                result = "r64Qam34(8)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuTxPower=").append(this.rbSuTxPower).append(", ");
        result.append("rbSuUlSNR=").append(this.rbSuUlSNR).append(", ");
        result.append("rbSuUlRSSI=").append(this.rbSuUlRSSI).append(", ");
        result.append("rbSuUlCurrentRate=").append(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(this.rbSuUlCurrentRate)).append(", ");
        result.append("rbSuDlSNR=").append(this.rbSuDlSNR).append(", ");
        result.append("rbSuDlRSSI=").append(this.rbSuDlRSSI).append(", ");
        result.append("rbSuDlCurrentRate=").append(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(this.rbSuDlCurrentRate)).append(", ");
        result.append("rbSuMultirateSupport=").append(RbSuMultirateParametersGroup.toStringRbSuMultirateSupport(this.rbSuMultirateSupport)).append(", ");
        result.append("rbSuEstDistance=").append(this.rbSuEstDistance).append(", ");
        result.append("rbSuUlRateBelowMinimum=").append(RbSuMultirateParametersGroup.toStringRbSuRateBelowMinimum(this.rbSuUlRateBelowMinimum)).append(", ");
        result.append("rbSuDlRateBelowMinimum=").append(RbSuMultirateParametersGroup.toStringRbSuRateBelowMinimum(this.rbSuDlRateBelowMinimum)).append(", ");
        result.append("rbSuDlMinDataRate=").append(RbSuMultirateParametersGroup.toStringRbSuRate(this.rbSuDlMinDataRate)).append(", ");
        result.append("rbSuUlMinDataRate=").append(RbSuMultirateParametersGroup.toStringRbSuRate(this.rbSuUlMinDataRate)).append(", ");
        result.append("rbSuUlCh1RSSIValue=").append(this.rbSuUlCh1RSSIValue).append(", ");
        result.append("rbSuUlCh2RSSIValue=").append(this.rbSuUlCh2RSSIValue).append(", ");
        result.append("rbSuUlCh3RSSIValue=").append(this.rbSuUlCh3RSSIValue).append(", ");
        result.append("rbSuUlCh4RSSIValue=").append(this.rbSuUlCh4RSSIValue);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuMultirateParametersGroup.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuMultirateParametersGroup>(){

            public ManagedObjectAccessHandler<RbSuMultirateParametersGroup> createHandler() {
                return new DefaultManagedObjectAccessHandler<RbSuMultirateParametersGroup>(RbSuMultirateParametersGroup.class){

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbSuMultirateParametersGroup managedObject) throws MediationException {
                        boolean readOnlyCrtRates = new Integer(1).equals(managedObject.getRbSuMultirateSupport());
                        if (readOnlyCrtRates) {
                            managedObject.setRbSuUlCurrentRate(null);
                            managedObject.setRbSuDlCurrentRate(null);
                        }
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }
}

