/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import com.bwanms.validation.Values;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.7.1.1", indexColumns={"RbSuMacAddr", "RbSuLicenseIdx"})
public class RbSuLicensesEntry
extends DynamicTableRowMO {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbSuMacAddr;
    private Integer rbSuLicenseIdx;
    private Integer rbSuLicenseId;
    private Long rbSuLicenseValue;
    public static final int RbSuLicenseIdBandwidth = 1;
    public static final long RbSuLicenseValueUnlimited = 0L;
    public static final long RbSuLicenseValueLimited = 1L;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.7.1.1.1", type=2)
    public Integer getRbSuLicenseIdx() {
        return this.rbSuLicenseIdx;
    }

    public void setRbSuLicenseIdx(Integer rbSuLicenseIdx) {
        this.rbSuLicenseIdx = rbSuLicenseIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.7.1.1.2", type=2)
    public Integer getRbSuLicenseId() {
        return this.rbSuLicenseId;
    }

    public void setRbSuLicenseId(Integer rbSuLicenseId) {
        this.rbSuLicenseId = rbSuLicenseId;
    }

    public static String toStringRbSuLicenseId(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "bandwidth(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @ConfigAttribute
    @Values(values={0, 1}, toStringConvertorMethodName="toStringRbSuLicenseValue")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.7.1.1.3", type=66)
    public Long getRbSuLicenseValue() {
        return this.rbSuLicenseValue;
    }

    public static String toStringRbSuLicenseValue(Long value) {
        String ret = null;
        if (value == null) {
            throw new IllegalArgumentException("The license value can't be null");
        }
        switch (value.intValue()) {
            case 0: {
                ret = "Unlimited(0)";
                break;
            }
            case 1: {
                ret = "Limited(1)";
                break;
            }
            default: {
                ret = "!!undefined(" + value + ")";
            }
        }
        return ret;
    }

    public void setRbSuLicenseValue(Long rbSuLicenseValue) {
        this.rbSuLicenseValue = rbSuLicenseValue;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuLicenseIdx=").append(this.rbSuLicenseIdx).append(", ");
        result.append("rbSuLicenseId=").append(RbSuLicensesEntry.toStringRbSuLicenseId(this.rbSuLicenseId)).append(", ");
        result.append("rbSuLicenseValue=").append(this.rbSuLicenseValue).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.rbSuMacAddr + "." + this.rbSuLicenseIdx;
    }

    public Integer getRowStatus() {
        return null;
    }

    public void setRowStatus(Integer rowStatus) {
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuLicensesEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuLicensesEntry>(){

            public ManagedObjectAccessHandler<RbSuLicensesEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbSuLicensesEntry>(RbSuLicensesEntry.class){

                    public List<RbSuLicensesEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
                        RbSU su = (RbSU)eq;
                        String instance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
                        return super.fetch(eq, access, networkResource, instance + "*");
                    }
                };
            }
        });
    }
}

