/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.mo.RbSUTableRowMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="RbSuHwCompInfoEntry")
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.3.1", indexColumns={"RbSuMacAddr"})
public class RbSuHwComponentsInfoSummaryEntry
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String rbSuMacAddr;
    private String rbSuRfCardRevision;
    private String rbSuRfCardConfiguration;
    private String rbSuBootVersion;
    private Integer rbSuType;
    public static final int RbSuTypeUnknown = 0;
    public static final int RbSuTypeCpe = 1;
    public static final int RbSuTypeCpe_pro = 2;
    public static final int RbSuTypeCpe_si = 3;
    public static final int RbSuTypeCpe_pro_L = 4;
    public static final int RbSuTypeCpe_si_L = 5;
    public static final int RbSuTypeCpe2_pro = 6;
    public static final int RbSuTypeCpe2_si = 7;
    public static final int RbSuTypeCpe2_pro_L = 8;
    public static final int RbSuTypeCpe2_si_L = 9;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.3.1.1", type=-128)
    @InventoryAttribute
    public String getRbSuRfCardRevision() {
        return this.rbSuRfCardRevision;
    }

    public void setRbSuRfCardRevision(String rbSuRfCardRevision) {
        this.rbSuRfCardRevision = rbSuRfCardRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.3.1.2", type=-128)
    @InventoryAttribute
    public String getRbSuRfCardConfiguration() {
        return this.rbSuRfCardConfiguration;
    }

    public void setRbSuRfCardConfiguration(String rbSuRfCardConfiguration) {
        this.rbSuRfCardConfiguration = rbSuRfCardConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.3.1.3", type=-128)
    @InventoryAttribute
    public String getRbSuBootVersion() {
        return this.rbSuBootVersion;
    }

    public void setRbSuBootVersion(String rbSuBootVersion) {
        this.rbSuBootVersion = rbSuBootVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.3.1.4", type=2)
    @InventoryAttribute
    public Integer getRbSuType() {
        return this.rbSuType;
    }

    public void setRbSuType(Integer rbSuType) {
        this.rbSuType = rbSuType;
    }

    public static String toStringRbSuType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "cpe(1)";
                break;
            }
            case 2: {
                result = "cpe-pro(2)";
                break;
            }
            case 3: {
                result = "cpe-si(3)";
                break;
            }
            case 4: {
                result = "cpe-pro-L(4)";
                break;
            }
            case 5: {
                result = "cpe-si-L(5)";
                break;
            }
            case 6: {
                result = "cpe2-pro(6)";
                break;
            }
            case 7: {
                result = "cpe2-si(7)";
                break;
            }
            case 8: {
                result = "cpe2-pro-L(8)";
                break;
            }
            case 9: {
                result = "cpe2-si-L(9)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuRfCardRevision=").append(this.rbSuRfCardRevision).append(", ");
        result.append("rbSuRfCardConfiguration=").append(this.rbSuRfCardConfiguration).append(", ");
        result.append("rbSuBootVersion=").append(this.rbSuBootVersion).append(", ");
        result.append("rbSuType=").append(RbSuHwComponentsInfoSummaryEntry.toStringRbSuType(this.rbSuType)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSuMacAddr();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuHwComponentsInfoSummaryEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuHwComponentsInfoSummaryEntry>(){

            public ManagedObjectAccessHandler<RbSuHwComponentsInfoSummaryEntry> createHandler() {
                return new RbSUTableRowMOAccessHandler<RbSuHwComponentsInfoSummaryEntry>(RbSuHwComponentsInfoSummaryEntry.class);
            }
        });
    }
}

