/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.MultipleMatchFilter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.mo.RbSUTableRowMOAccessHandler;
import com.bwanms.rb.mo.RbSuFreqScanningEntryUnder402;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import com.bwanms.validation.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="RbSuFreqScanEntry")
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1", indexColumns={"RbSuMacAddr"})
public class RbSuFreqScanningEntry
extends ScalarMO {
    private static final long serialVersionUID = -76153511976545865L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbSuMacAddr;
    private String rbSuCurrentScanStartFreq;
    private String rbSuConfiguredScanStartFreq;
    private String rbSuCurrentScanEndFreq;
    private String rbSuConfiguredScanEndFreq;
    private String rbSuCurrentScanStep;
    private String rbSuConfiguredScanStep;
    private String rbSuCurrentScanMask;
    private String rbSuConfiguredScanMask;
    private Integer rbSuCurrentBandwidth;
    private Integer rbSuConfiguredBandwidth;
    private String rbSuConfiguredDiscreteFrequenciesList;
    private String rbSuDiscreteF1;
    private String rbSuDiscreteF2;
    private String rbSuDiscreteF3;
    private String rbSuDiscreteF4;
    private String rbSuDiscreteF5;
    private String rbSuDiscreteF6;
    private String rbSuDiscreteF7;
    private String rbSuDiscreteF8;
    private String rbSuDiscreteF9;
    private String rbSuDiscreteF10;
    public static final int SuCurrentBandwidthB175 = 1;
    public static final int SuCurrentBandwidthB35 = 2;
    public static final int SuCurrentBandwidthB50 = 3;
    public static final int SuCurrentBandwidthB70 = 4;
    public static final int SuCurrentBandwidthB100 = 5;
    public static final int SuConfiguredBandwidthB175 = 1;
    public static final int SuConfiguredBandwidthB35 = 2;
    public static final int SuConfiguredBandwidthB50 = 3;
    public static final int SuConfiguredBandwidthB70 = 4;
    public static final int SuConfiguredBandwidthB100 = 5;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @IdentifierAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.1", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @StateAttribute
    public String getRbSuCurrentScanStartFreq() {
        return this.rbSuCurrentScanStartFreq;
    }

    public void setRbSuCurrentScanStartFreq(String rbSuCurrentScanStartFreq) {
        this.rbSuCurrentScanStartFreq = rbSuCurrentScanStartFreq;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.2", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @ConfigAttribute
    public String getRbSuConfiguredScanStartFreq() {
        return this.rbSuConfiguredScanStartFreq;
    }

    public void setRbSuConfiguredScanStartFreq(String rbSuConfiguredScanStartFreq) {
        this.rbSuConfiguredScanStartFreq = rbSuConfiguredScanStartFreq;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.3", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuCurrentScanEndFreq() {
        return this.rbSuCurrentScanEndFreq;
    }

    public void setRbSuCurrentScanEndFreq(String rbSuCurrentScanEndFreq) {
        this.rbSuCurrentScanEndFreq = rbSuCurrentScanEndFreq;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.4", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @ConfigAttribute
    public String getRbSuConfiguredScanEndFreq() {
        return this.rbSuConfiguredScanEndFreq;
    }

    public void setRbSuConfiguredScanEndFreq(String rbSuConfiguredScanEndFreq) {
        this.rbSuConfiguredScanEndFreq = rbSuConfiguredScanEndFreq;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.5", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuCurrentScanStep() {
        return this.rbSuCurrentScanStep;
    }

    public void setRbSuCurrentScanStep(String rbSuCurrentScanStep) {
        this.rbSuCurrentScanStep = rbSuCurrentScanStep;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.6", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @ConfigAttribute
    public String getRbSuConfiguredScanStep() {
        return this.rbSuConfiguredScanStep;
    }

    public void setRbSuConfiguredScanStep(String rbSuConfiguredScanStep) {
        this.rbSuConfiguredScanStep = rbSuConfiguredScanStep;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.7", type=4)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuCurrentScanMask() {
        return this.rbSuCurrentScanMask;
    }

    public void setRbSuCurrentScanMask(String rbSuCurrentScanMask) {
        this.rbSuCurrentScanMask = rbSuCurrentScanMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.8", type=4)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @ConfigAttribute
    public String getRbSuConfiguredScanMask() {
        return this.rbSuConfiguredScanMask;
    }

    public void setRbSuConfiguredScanMask(String rbSuConfiguredScanMask) {
        this.rbSuConfiguredScanMask = rbSuConfiguredScanMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.19", type=2)
    @InventoryAttribute
    @Values(values={1, 2, 3, 4, 5}, toStringConvertorMethodName="toStringRbSuCurrentBandwidth")
    public Integer getRbSuCurrentBandwidth() {
        return this.rbSuCurrentBandwidth;
    }

    public void setRbSuCurrentBandwidth(Integer rbSuCurrentBandwidth) {
        this.rbSuCurrentBandwidth = rbSuCurrentBandwidth;
    }

    public static String toStringRbSuCurrentBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "NA(0)";
                break;
            }
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.20", type=2)
    @ConfigAttribute
    @Values(values={1, 2, 3, 4, 5}, toStringConvertorMethodName="toStringRbSuConfiguredBandwidth")
    public Integer getRbSuConfiguredBandwidth() {
        return this.rbSuConfiguredBandwidth;
    }

    public void setRbSuConfiguredBandwidth(Integer rbSuConfiguredBandwidth) {
        this.rbSuConfiguredBandwidth = rbSuConfiguredBandwidth;
    }

    public static String toStringRbSuConfiguredBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "N/A(0)";
                break;
            }
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.9", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF1() {
        return this.rbSuDiscreteF1;
    }

    public void setRbSuDiscreteF1(String rbSuDiscreteF1) {
        this.rbSuDiscreteF1 = rbSuDiscreteF1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.10", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF2() {
        return this.rbSuDiscreteF2;
    }

    public void setRbSuDiscreteF2(String rbSuDiscreteF2) {
        this.rbSuDiscreteF2 = rbSuDiscreteF2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.11", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF3() {
        return this.rbSuDiscreteF3;
    }

    public void setRbSuDiscreteF3(String rbSuDiscreteF3) {
        this.rbSuDiscreteF3 = rbSuDiscreteF3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.12", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF4() {
        return this.rbSuDiscreteF4;
    }

    public void setRbSuDiscreteF4(String rbSuDiscreteF4) {
        this.rbSuDiscreteF4 = rbSuDiscreteF4;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.13", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF5() {
        return this.rbSuDiscreteF5;
    }

    public void setRbSuDiscreteF5(String rbSuDiscreteF5) {
        this.rbSuDiscreteF5 = rbSuDiscreteF5;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.14", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF6() {
        return this.rbSuDiscreteF6;
    }

    public void setRbSuDiscreteF6(String rbSuDiscreteF6) {
        this.rbSuDiscreteF6 = rbSuDiscreteF6;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.15", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF7() {
        return this.rbSuDiscreteF7;
    }

    public void setRbSuDiscreteF7(String rbSuDiscreteF7) {
        this.rbSuDiscreteF7 = rbSuDiscreteF7;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.16", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF8() {
        return this.rbSuDiscreteF8;
    }

    public void setRbSuDiscreteF8(String rbSuDiscreteF8) {
        this.rbSuDiscreteF8 = rbSuDiscreteF8;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.17", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF9() {
        return this.rbSuDiscreteF9;
    }

    public void setRbSuDiscreteF9(String rbSuDiscreteF9) {
        this.rbSuDiscreteF9 = rbSuDiscreteF9;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.18", type=-128)
    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @InventoryAttribute
    public String getRbSuDiscreteF10() {
        return this.rbSuDiscreteF10;
    }

    public void setRbSuDiscreteF10(String rbSuDiscreteF10) {
        this.rbSuDiscreteF10 = rbSuDiscreteF10;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1.1.5"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.11.1.1.21", type=-128)
    @ConfigAttribute
    @Column(name="rbSuCfgDiscreteFreqList")
    public String getRbSuConfiguredDiscreteFrequenciesList() {
        return this.rbSuConfiguredDiscreteFrequenciesList;
    }

    public void setRbSuConfiguredDiscreteFrequenciesList(String rbSuConfiguredDiscreteFrequenciesList) {
        this.rbSuConfiguredDiscreteFrequenciesList = rbSuConfiguredDiscreteFrequenciesList;
    }

    @Transient
    public String getRbSuConfiguredDiscreteF(int index) {
        if (this.rbSuConfiguredDiscreteFrequenciesList == null) {
            return "";
        }
        int zeroBasedIndex = index - 1;
        String[] discreteArray = this.rbSuConfiguredDiscreteFrequenciesList.split(",");
        if (zeroBasedIndex >= discreteArray.length || zeroBasedIndex < 0) {
            return "";
        }
        try {
            double d = Double.parseDouble(discreteArray[zeroBasedIndex]);
            long temp = 0L;
            if (d != 0.0) {
                temp = (long)d;
                if (d == (double)temp) {
                    return String.format(Locale.ENGLISH, "%.0f", d);
                }
                return String.format(Locale.ENGLISH, "%.3f", d);
            }
            return String.format(Locale.ENGLISH, "%.0f", d);
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    public void setRbSuConfiguredDiscreteF(String value, int index) {
        double d;
        int zeroBasedIndex = index - 1;
        if (zeroBasedIndex > 9 || zeroBasedIndex < 0) {
            return;
        }
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            d = 0.0;
        }
        if (this.rbSuConfiguredDiscreteFrequenciesList == null) {
            this.rbSuConfiguredDiscreteFrequenciesList = "0,0,0,0,0,0,0,0,0,0";
        }
        String[] discreteArray = this.rbSuConfiguredDiscreteFrequenciesList.split(",");
        discreteArray[zeroBasedIndex] = d != 0.0 ? String.format(Locale.ENGLISH, "%.3f", d) : String.format(Locale.ENGLISH, "%.0f", d);
        StringBuilder sb = new StringBuilder();
        for (String s : discreteArray) {
            sb.append(s);
            sb.append(",");
        }
        this.rbSuConfiguredDiscreteFrequenciesList = sb.substring(0, sb.length() - 1);
    }

    @Transient
    public String getRbSuDiscreteF(int index) {
        switch (index) {
            case 1: {
                return this.rbSuDiscreteF1;
            }
            case 2: {
                return this.rbSuDiscreteF2;
            }
            case 3: {
                return this.rbSuDiscreteF3;
            }
            case 4: {
                return this.rbSuDiscreteF4;
            }
            case 5: {
                return this.rbSuDiscreteF5;
            }
            case 6: {
                return this.rbSuDiscreteF6;
            }
            case 7: {
                return this.rbSuDiscreteF7;
            }
            case 8: {
                return this.rbSuDiscreteF8;
            }
            case 9: {
                return this.rbSuDiscreteF9;
            }
            case 10: {
                return this.rbSuDiscreteF10;
            }
        }
        return "";
    }

    public void setRbSuDiscreteF(String value, int index) {
        try {
            Double.valueOf(value);
            switch (index) {
                case 1: {
                    this.rbSuDiscreteF1 = value;
                    break;
                }
                case 2: {
                    this.rbSuDiscreteF2 = value;
                    break;
                }
                case 3: {
                    this.rbSuDiscreteF3 = value;
                    break;
                }
                case 4: {
                    this.rbSuDiscreteF4 = value;
                    break;
                }
                case 5: {
                    this.rbSuDiscreteF5 = value;
                    break;
                }
                case 6: {
                    this.rbSuDiscreteF6 = value;
                    break;
                }
                case 7: {
                    this.rbSuDiscreteF7 = value;
                    break;
                }
                case 8: {
                    this.rbSuDiscreteF8 = value;
                    break;
                }
                case 9: {
                    this.rbSuDiscreteF9 = value;
                    break;
                }
                case 10: {
                    this.rbSuDiscreteF10 = value;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuCurrentScanStartFreq=").append(this.rbSuCurrentScanStartFreq).append(", ");
        result.append("rbSuConfiguredScanStartFreq=").append(this.rbSuConfiguredScanStartFreq).append(", ");
        result.append("rbSuCurrentScanEndFreq=").append(this.rbSuCurrentScanEndFreq).append(", ");
        result.append("rbSuConfiguredScanEndFreq=").append(this.rbSuConfiguredScanEndFreq).append(", ");
        result.append("rbSuCurrentScanStep=").append(this.rbSuCurrentScanStep).append(", ");
        result.append("rbSuConfiguredScanStep=").append(this.rbSuConfiguredScanStep).append(", ");
        result.append("rbSuCurrentScanMask=").append(this.rbSuCurrentScanMask).append(", ");
        result.append("rbSuConfiguredScanMask=").append(this.rbSuConfiguredScanMask).append(", ");
        result.append("rbSuDiscreteF1=").append(this.rbSuDiscreteF1).append(", ");
        result.append("rbSuDiscreteF2=").append(this.rbSuDiscreteF2).append(", ");
        result.append("rbSuDiscreteF3=").append(this.rbSuDiscreteF3).append(", ");
        result.append("rbSuDiscreteF4=").append(this.rbSuDiscreteF4).append(", ");
        result.append("rbSuDiscreteF5=").append(this.rbSuDiscreteF5).append(", ");
        result.append("rbSuDiscreteF6=").append(this.rbSuDiscreteF6).append(", ");
        result.append("rbSuDiscreteF7=").append(this.rbSuDiscreteF7).append(", ");
        result.append("rbSuDiscreteF8=").append(this.rbSuDiscreteF8).append(", ");
        result.append("rbSuDiscreteF9=").append(this.rbSuDiscreteF9).append(", ");
        result.append("rbSuDiscreteF10=").append(this.rbSuDiscreteF10).append(", ");
        result.append("rbSuConfiguredDiscreteFrequenciesList=").append(this.getRbSuConfiguredDiscreteFrequenciesList());
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSuMacAddr();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuFreqScanningEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuFreqScanningEntry>(){

            public ManagedObjectAccessHandler<RbSuFreqScanningEntry> createHandler() {
                return new RbSUTableRowMOAccessHandler<RbSuFreqScanningEntry>(RbSuFreqScanningEntry.class){

                    @Override
                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbSuFreqScanningEntry managedObject) throws MediationException {
                        Version bsVersion = ((RbSU)eq).getManagerBS().getSoftwareVersion();
                        if (bsVersion.isOlderThan(VersionFactory.getInstance().createVersion("4.1.1.5"))) {
                            managedObject.setRbSuConfiguredDiscreteFrequenciesList(null);
                            if (bsVersion.isOlderThan(VersionFactory.getInstance().createVersion("4.0.2"))) {
                                managedObject.setRbSuConfiguredBandwidth(null);
                            }
                        }
                        super.update(eq, access, networkResource, managedObject);
                    }

                    @Override
                    public List<RbSuFreqScanningEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
                        if (((RbSU)eq).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0.2")) < 0) {
                            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, RbSuFreqScanningEntryUnder402.class);
                            String instance = MacAddress.fromSimpleString((String)((RbSU)eq).getMacAddress()).toInstanceString();
                            List temp = access.fetchObject("BS", RbSuFreqScanningEntryUnder402.class, includedProperties, new String[]{instance});
                            if (temp.size() != 1) {
                                throw new RuntimeException("Got more than one row");
                            }
                            ArrayList<RbSuFreqScanningEntry> ret = new ArrayList<RbSuFreqScanningEntry>();
                            for (RbSuFreqScanningEntryUnder402 oldEntry : temp) {
                                RbSuFreqScanningEntry newEntry = new RbSuFreqScanningEntry();
                                newEntry.setNRConfiguration(oldEntry.getNRConfiguration());
                                newEntry.setRbSuMacAddr(oldEntry.getRbSuMacAddr());
                                newEntry.setRbSuCurrentScanStartFreq(oldEntry.getRbSuCurrentScanStartFreq());
                                newEntry.setRbSuConfiguredScanStartFreq(oldEntry.getRbSuConfiguredScanStartFreq());
                                newEntry.setRbSuCurrentScanEndFreq(oldEntry.getRbSuCurrentScanEndFreq());
                                newEntry.setRbSuConfiguredScanEndFreq(oldEntry.getRbSuConfiguredScanEndFreq());
                                newEntry.setRbSuCurrentScanStep(oldEntry.getRbSuCurrentScanStep());
                                newEntry.setRbSuConfiguredScanStep(oldEntry.getRbSuConfiguredScanStep());
                                newEntry.setRbSuCurrentScanMask(oldEntry.getRbSuCurrentScanMask());
                                newEntry.setRbSuConfiguredScanMask(oldEntry.getRbSuConfiguredScanMask());
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF1()), 1);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF2()), 2);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF3()), 3);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF4()), 4);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF5()), 5);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF6()), 6);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF7()), 7);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF8()), 8);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF9()), 9);
                                newEntry.setRbSuConfiguredDiscreteF(String.valueOf(oldEntry.getRbSuDiscreteF10()), 10);
                                ret.add(newEntry);
                            }
                            return ret;
                        }
                        return super.fetch(eq, access, networkResource, instanceQuery);
                    }
                };
            }
        });
    }
}

