/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.validation.WeakRange;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbSuBridgingParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbSuSupportDevicesLimit;
    private Integer rbSuMaxNumberOfSupportedDevices;
    private Integer rbSuBridgeAgingTime;
    public static final int RbSuSupportDevicesLimitEnable = 1;
    public static final int RbSuSupportDevicesLimitDisable = 2;
    public static final int RbSuSupportDevicesLimitUnknown = 3;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.4.1", type=2)
    @ConfigAttribute
    public Integer getRbSuSupportDevicesLimit() {
        return this.rbSuSupportDevicesLimit;
    }

    public void setRbSuSupportDevicesLimit(Integer rbSuSupportDevicesLimit) {
        this.rbSuSupportDevicesLimit = rbSuSupportDevicesLimit;
    }

    public static String toStringRbSuSupportDevicesLimit(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.4.2", type=2)
    @WeakRange(min=1L, max=512L)
    @Column(name="rbSuMaxNoOfSupportedDevices")
    @ConfigAttribute
    public Integer getRbSuMaxNumberOfSupportedDevices() {
        return this.rbSuMaxNumberOfSupportedDevices;
    }

    public void setRbSuMaxNumberOfSupportedDevices(Integer rbSuMaxNumberOfSupportedDevices) {
        this.rbSuMaxNumberOfSupportedDevices = rbSuMaxNumberOfSupportedDevices;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.4.3", type=2)
    @WeakRange(min=1L, max=1440L)
    @ConfigAttribute
    public Integer getRbSuBridgeAgingTime() {
        return this.rbSuBridgeAgingTime;
    }

    public void setRbSuBridgeAgingTime(Integer rbSuBridgeAgingTime) {
        this.rbSuBridgeAgingTime = rbSuBridgeAgingTime;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuSupportDevicesLimit=").append(RbSuBridgingParameters.toStringRbSuSupportDevicesLimit(this.rbSuSupportDevicesLimit)).append(", ");
        result.append("rbSuMaxNumberOfSupportedDevices=").append(this.rbSuMaxNumberOfSupportedDevices).append(", ");
        result.append("rbSuBridgeAgingTime=").append(this.rbSuBridgeAgingTime).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSuBridgingParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSuBridgingParameters>(){

            public ManagedObjectAccessHandler<RbSuBridgingParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSuBridgingParameters.class);
            }
        });
    }
}

