/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.MultipleMatchFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultNetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.mo.snmp.SNMPDataObjectTableRow;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.util.List;
import javax.persistence.Transient;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1", indexColumns={"RbSuMacAddr", "RbBstAuIndx"})
public class RbSuBestBstAuDataEntry
extends SNMPDataObjectTableRow {
    private static final long serialVersionUID = -1593190355335301208L;
    private String rbSuMacAddr;
    private Integer rbBstAuIndx;
    private String rbBstAuId;
    private String rbBstAuRxFrequency;
    private Integer rbBstAuSNR;
    private Integer rbBstAuRxAntennaNumber;

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    @StateAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1.1", type=2)
    @ConfigAttribute
    public Integer getRbBstAuIndx() {
        return this.rbBstAuIndx;
    }

    public void setRbBstAuIndx(Integer rbBstAuIndx) {
        this.rbBstAuIndx = rbBstAuIndx;
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1.2", type=4)
    @StateAttribute
    public String getRbBstAuId() {
        return this.rbBstAuId;
    }

    public void setRbBstAuId(String rbBstAuId) {
        this.rbBstAuId = rbBstAuId;
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1.3", type=-128)
    @StateAttribute
    public String getRbBstAuRxFrequency() {
        return this.rbBstAuRxFrequency;
    }

    public void setRbBstAuRxFrequency(String rbBstAuRxFrequency) {
        this.rbBstAuRxFrequency = rbBstAuRxFrequency;
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1.4", type=2)
    @StateAttribute
    public Integer getRbBstAuSNR() {
        return this.rbBstAuSNR;
    }

    public void setRbBstAuSNR(Integer rbBstAuSNR) {
        this.rbBstAuSNR = rbBstAuSNR;
    }

    @Transient
    public String getRowKey() {
        return MacAddress.fromOctetString((String)this.getRbSuMacAddr()).toInstanceString() + "." + this.getRbBstAuIndx();
    }

    @Filter(filterClass=MultipleMatchFilter.class, values={"operationMode", "2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.10.2.1.5", type=2)
    @StateAttribute
    public Integer getRbBstAuRxAntennaNumber() {
        return this.rbBstAuRxAntennaNumber;
    }

    public void setRbBstAuRxAntennaNumber(Integer rbBstAuRxAntennaNumber) {
        this.rbBstAuRxAntennaNumber = rbBstAuRxAntennaNumber;
    }

    public static String toStringRbBstAuRxAntennaNumber(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                result = value.toString();
                break;
            }
            case 7: {
                result = "External";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbBstAuIndx=").append(this.rbBstAuIndx).append(", ");
        result.append("rbBstAuId=").append(this.rbBstAuId).append(", ");
        result.append("rbBstAuRxFrequency=").append(this.rbBstAuRxFrequency).append(", ");
        result.append("rbBstAuSNR=").append(this.rbBstAuSNR).append(", ");
        result.append("rbBstAuRxAntennaNumber=").append(this.rbBstAuRxAntennaNumber).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbSuBestBstAuDataEntry.class, SNMP.class, (NetworkDomainObjectAccessHandler)new RbSuBestBstAuDataEntryNetworkDomainObjectAccessHandler(RbSuBestBstAuDataEntry.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbSuBestBstAuDataEntryNetworkDomainObjectAccessHandler
    extends DefaultNetworkDomainObjectAccessHandler<RbSuBestBstAuDataEntry> {
        public RbSuBestBstAuDataEntryNetworkDomainObjectAccessHandler(Class<RbSuBestBstAuDataEntry> moClass) {
            super(moClass);
        }

        public List<RbSuBestBstAuDataEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            RbSU su = (RbSU)eq;
            String instance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
            return super.fetch(eq, access, networkResource, instance + "*");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbSuBestBstAuDataEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + RbSuBestBstAuDataEntry.class.getName() + "]");
        }
    }
}

