/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.NullConfigFileMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Type;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.1.1", indexColumns={"RbSlotNumber"})
public class RbSlotConfigEntry
extends StaticTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbSlotNumber;
    private Integer rbSlotDetectedCard;
    public static final int RbSlotDetectedCardNotInstalled = 1;
    public static final int RbSlotDetectedCardUnknown = 2;
    public static final int RbSlotDetectedCardAu = 3;
    public static final int RbSlotDetectedCardNpu = 4;
    private Integer rbSlotConfiguredCard;
    public static final int RbSlotConfiguredCardNotInstalled = 1;
    public static final int RbSlotConfiguredCardUnknown = 2;
    public static final int RbSlotConfiguredCardAu = 3;
    public static final int RbSlotConfiguredCardNpu = 4;
    private Integer rbSlotAllowedCard;
    public static final int RbSlotAllowedCardNotInstalled = 1;
    public static final int RbSlotAllowedCardUnknown = 2;
    public static final int RbSlotAllowedCardAu = 3;
    public static final int RbSlotAllowedCardNpu = 4;
    private String rbSlotLedStatus;
    private Integer rbSlotFaultStatus;
    public static final int RbSlotFaultStatusNoFaults = 1;
    public static final int RbSlotFaultStatusMinor = 2;
    public static final int RbSlotFaultStatusMajor = 3;
    public static final int RbSlotFaultStatusCritical = 4;
    public static final int RbSlotFaultStatusDisconnected = 5;
    private Integer rbSlotExtractorState;
    public static final int RbSlotExtractorStateClosed = 1;
    public static final int RbSlotExtractorStateOpened = 2;
    public static final int RbSlotExtractorStateUnknown = 3;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.2", type=2)
    @StateAttribute
    public Integer getRbSlotDetectedCard() {
        return this.rbSlotDetectedCard;
    }

    public void setRbSlotDetectedCard(Integer rbSlotDetectedCard) {
        this.rbSlotDetectedCard = rbSlotDetectedCard;
    }

    public String toStringRbSlotDetectedCard(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "notInstalled(1)";
                break;
            }
            case 2: {
                result = "unknown(2)";
                break;
            }
            case 3: {
                result = "au(3)";
                break;
            }
            case 4: {
                result = "npu(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.3", type=2)
    @StateAttribute
    public Integer getRbSlotConfiguredCard() {
        return this.rbSlotConfiguredCard;
    }

    public void setRbSlotConfiguredCard(Integer rbSlotConfiguredCard) {
        this.rbSlotConfiguredCard = rbSlotConfiguredCard;
    }

    public String toStringRbSlotConfiguredCard(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "notInstalled(1)";
                break;
            }
            case 2: {
                result = "unknown(2)";
                break;
            }
            case 3: {
                result = "au(3)";
                break;
            }
            case 4: {
                result = "npu(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.4", type=2)
    @StateAttribute
    public Integer getRbSlotAllowedCard() {
        return this.rbSlotAllowedCard;
    }

    public void setRbSlotAllowedCard(Integer rbSlotAllowedCard) {
        this.rbSlotAllowedCard = rbSlotAllowedCard;
    }

    public String toStringRbSlotAllowedCard(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "notInstalled(1)";
                break;
            }
            case 2: {
                result = "unknown(2)";
                break;
            }
            case 3: {
                result = "au(3)";
                break;
            }
            case 4: {
                result = "npu(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.5", type=4)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSlotLedStatus() {
        return this.rbSlotLedStatus;
    }

    public void setRbSlotLedStatus(String rbSlotLedStatus) {
        this.rbSlotLedStatus = rbSlotLedStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.6", type=2)
    @StateAttribute
    public Integer getRbSlotFaultStatus() {
        return this.rbSlotFaultStatus;
    }

    public void setRbSlotFaultStatus(Integer rbSlotFaultStatus) {
        this.rbSlotFaultStatus = rbSlotFaultStatus;
    }

    public String toStringRbSlotFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noFaults(1)";
                break;
            }
            case 2: {
                result = "minor(2)";
                break;
            }
            case 3: {
                result = "major(3)";
                break;
            }
            case 4: {
                result = "critical(4)";
                break;
            }
            case 5: {
                result = "disconnected(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.7", type=2)
    @StateAttribute
    public Integer getRbSlotExtractorState() {
        return this.rbSlotExtractorState;
    }

    public void setRbSlotExtractorState(Integer rbSlotExtractorState) {
        this.rbSlotExtractorState = rbSlotExtractorState;
    }

    public String toStringRbSlotExtractorState(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "closed(1)";
                break;
            }
            case 2: {
                result = "opened(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbSlotDetectedCard=").append(this.toStringRbSlotDetectedCard(this.rbSlotDetectedCard)).append(", ");
        result.append("rbSlotConfiguredCard=").append(this.toStringRbSlotConfiguredCard(this.rbSlotConfiguredCard)).append(", ");
        result.append("rbSlotAllowedCard=").append(this.toStringRbSlotAllowedCard(this.rbSlotAllowedCard)).append(", ");
        result.append("rbSlotLedStatus=").append(this.rbSlotLedStatus).append(", ");
        result.append("rbSlotFaultStatus=").append(this.toStringRbSlotFaultStatus(this.rbSlotFaultStatus)).append(", ");
        result.append("rbSlotExtractorState=").append(this.toStringRbSlotExtractorState(this.rbSlotExtractorState)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSlotConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSlotConfigEntry>(){

            public ManagedObjectAccessHandler<RbSlotConfigEntry> createHandler() {
                return new NullConfigFileMOAccessHandler<RbSlotConfigEntry>();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSlotConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSlotConfigEntry>(){

            public ManagedObjectAccessHandler<RbSlotConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSlotConfigEntry.class);
            }
        });
    }
}

