/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.BooleanFilter;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.mo.RbSUTableRowNetworkAccessHandler;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.6.1.1", indexColumns={"RbSuMacAddr"})
public class RbSiSuInfoEntry
implements NetworkDomainObject {
    private static final long serialVersionUID = -1234418549535255537L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbSuMacAddr;
    private Integer rbSiSuAntennaSelection;
    private Integer rbSiSuSmartCardStatus;
    private Integer rbSiSuInterfaceType;
    public static final int RbSiSuAntennaSelectionAutomatic = 8;
    public static final int RbSiSuAntennaSelectionExternal = 7;
    public static final int RbSiSuAntennaSelectionInternal1 = 1;
    public static final int RbSiSuAntennaSelectionInternal2 = 2;
    public static final int RbSiSuAntennaSelectionInternal3 = 3;
    public static final int RbSiSuAntennaSelectionInternal4 = 4;
    public static final int RbSiSuAntennaSelectionInternal5 = 5;
    public static final int RbSiSuAntennaSelectionInternal6 = 6;
    public static final int RbSiSuAntennaSelectionUnknown = 0;
    public static final int RbSiSuSmartCardStatusInstalled = 1;
    public static final int RbSiSuSmartCardStatusNotInstalled = 2;
    public static final int RbSiSuSmartCardStatusUnknown = 0;
    public static final int RbSiSuSmartCardStatusFault = 3;
    public static final int RbSiSuInterfaceTypeUnknown = 0;
    public static final int RbSiSuInterfaceTypeEthernet = 1;
    public static final int RbSiSuInterfaceTypeUsb = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Filter(filterClass=BooleanFilter.class, values={"isSI"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @Filter(filterClass=BooleanFilter.class, values={"isSI"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.6.1.1.1", type=2)
    @StateAttribute
    public Integer getRbSiSuAntennaSelection() {
        return this.rbSiSuAntennaSelection;
    }

    public void setRbSiSuAntennaSelection(Integer rbSiSuAntennaSelection) {
        this.rbSiSuAntennaSelection = rbSiSuAntennaSelection;
    }

    public static String toStringRbSiSuAntennaSelection(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "internal1(1)";
                break;
            }
            case 2: {
                result = "internal2(2)";
                break;
            }
            case 3: {
                result = "internal3(3)";
                break;
            }
            case 4: {
                result = "internal4(4)";
                break;
            }
            case 5: {
                result = "internal5(5)";
                break;
            }
            case 6: {
                result = "internal6(6)";
                break;
            }
            case 7: {
                result = "external(7)";
                break;
            }
            case 8: {
                result = "automatic(8)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=BooleanFilter.class, values={"isSI"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.6.1.1.2", type=2)
    @StateAttribute
    public Integer getRbSiSuSmartCardStatus() {
        return this.rbSiSuSmartCardStatus;
    }

    public void setRbSiSuSmartCardStatus(Integer rbSiSuSmartCardStatus) {
        this.rbSiSuSmartCardStatus = rbSiSuSmartCardStatus;
    }

    public static String toStringRbSiSuSmartCardStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "installed(1)";
                break;
            }
            case 2: {
                result = "notInstalled(2)";
                break;
            }
            case 3: {
                result = "fault(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=BooleanFilter.class, values={"isSI"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.6.1.1.3", type=2)
    @StateAttribute
    public Integer getRbSiSuInterfaceType() {
        return this.rbSiSuInterfaceType;
    }

    public void setRbSiSuInterfaceType(Integer rbSiSuInterfaceType) {
        this.rbSiSuInterfaceType = rbSiSuInterfaceType;
    }

    public static String toStringRbSiSuInterfaceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "ethernet(1)";
                break;
            }
            case 2: {
                result = "usb(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSiSuAntennaSelection=").append(RbSiSuInfoEntry.toStringRbSiSuAntennaSelection(this.rbSiSuAntennaSelection)).append(", ");
        result.append("rbSiSuSmartCardStatus=").append(RbSiSuInfoEntry.toStringRbSiSuSmartCardStatus(this.rbSiSuSmartCardStatus)).append(", ");
        result.append("rbSiSuInterfaceType=").append(RbSiSuInfoEntry.toStringRbSiSuInterfaceType(this.rbSiSuInterfaceType)).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getRowKey() {
        return this.rbSuMacAddr;
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbSiSuInfoEntry.class, SNMP.class, new RbSUTableRowNetworkAccessHandler<RbSiSuInfoEntry>(RbSiSuInfoEntry.class));
    }
}

