/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilter;
import com.bwanms.meta.filters.AttributeFilterFactory;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.mo.DefaultManagedObjectIntrospector;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectIntrospector;
import com.bwanms.model.Equipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSUTableRowMOAccessHandler<M extends ManagedObject>
implements ManagedObjectAccessHandler<M> {
    private ManagedObjectIntrospector introspector = new DefaultManagedObjectIntrospector();
    private Class<M> moClass;

    public RbSUTableRowMOAccessHandler(Class<M> moClass) {
        this.moClass = moClass;
    }

    public List<M> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
        String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.moClass);
        String instance = MacAddress.fromSimpleString((String)((RbSU)eq).getMacAddress()).toInstanceString();
        List ret = access.fetchObject("BS", this.moClass, includedProperties, new String[]{instance});
        if (ret.size() != 1) {
            throw new RuntimeException("Got more than one row");
        }
        return ret;
    }

    public void add(Equipment eq, MOAccessSession access, String networkResource, M managedObject) throws MediationException {
        throw new UnsupportedOperationException("Cannot update [" + this.moClass.getName() + "]");
    }

    public void update(Equipment eq, MOAccessSession access, String networkResource, M managedObject) throws MediationException {
        AttributeFilter filter = AttributeFilterFactory.createFilter((Object)eq, this.moClass);
        String[] includedAttributes = AttributeFilterUtil.getMatchedAttributes((AttributeFilter)filter, (String[])this.introspector.getConfigurationAttributes(this.moClass));
        if (includedAttributes.length > 0) {
            access.commitObject("BS", managedObject, includedAttributes);
        }
    }

    public void delete(Equipment eq, MOAccessSession access, String networkResource, M managedObject) throws MediationException {
        throw new UnsupportedOperationException("Cannot delete [" + this.moClass.getName() + "]");
    }
}

