/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SuDb_Su;
import com.bwanms.util.MacAddress;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@Entity
@Table(name="RbRegisteredSu", indexes={@Index(name="IDX_REGSU_NRCFGID_MACADDR", columnNames={"nrConfigId", "rbSuSimpleMacAddr"})})
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.1.1", indexColumns={"RbSuMacAddr"})
public class RbRegisteredSuEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = 8063510076348893321L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbAuId;
    private String rbSuMacAddr;
    private Integer rbSuID;
    private Integer rbSuRegistrationState;
    public static final int RbSuRegistrationStateNotRegistered = 1;
    public static final int RbSuRegistrationStateRegistered = 2;
    public static final int RbSuRegistrationStateAuthenticated = 3;
    private Integer rbSuPersistence;
    public static final int RbSuPersistenceTemporary = 1;
    public static final int RbSuPersistencePermanent = 2;
    private String rbSuSerialNo;
    private String rbSuSysName;
    private Integer rbSuFaultStatus;
    public static final int RbSuFaultStatusNoFaults = 1;
    public static final int RbSuFaultStatusMinor = 2;
    public static final int RbSuFaultStatusMajor = 3;
    public static final int RbSuFaultStatusCritical = 4;
    public static final int RbSuFaultStatusDisconnected = 5;
    private String rbSuHwRevision;
    private String rbSuOperSwFileName;
    private String rbSuOperSwVersion;
    private String rbSuShadowSwFileName;
    private String rbSuShadowSwVersion;
    private Integer rbSuRunningSoftware;
    public static final int RbSuRunningSoftwareOperational = 1;
    public static final int RbSuRunningSoftwareShadow = 2;
    public static final int RbSuRunningSoftwareUnknown = 3;
    private Integer rbSuAllowedUsersType;
    public static final int RbSuAllowedUsersTypeResidentional = 1;
    public static final int RbSuAllowedUsersTypeUnknown = 2;
    private Integer rbSuAllowedQoS;
    public static final int RbSuAllowedQoSResidentional = 1;
    public static final int RbSuAllowedQoSUnknown = 2;
    private String rbSuAllowedService;
    private Integer rbSuRowStatus;
    public static final int RbSuRowStatusActive = 1;
    public static final int RbSuRowStatusNotInService = 2;
    public static final int RbSuRowStatusNotReady = 3;
    public static final int RbSuRowStatusCreateAndGo = 4;
    public static final int RbSuRowStatusCreateAndWait = 5;
    public static final int RbSuRowStatusDestroy = 6;
    private String rbSuHwConfigDescription;
    private String rbSuUpgradeSwFileName;
    private Integer rbSuServiceType;
    public static final int RbSuServiceTypeSuData = 1;
    public static final int RbSuServiceTypeSuVoice = 2;
    private Integer rbSuIduType;
    public static final int RbSuIduTypeBasic = 0;
    public static final int RbSuIduTypeVgDataVoice = 4;
    public static final int RbSuIduTypeVgData4Voice2 = 6;
    public static final int RbSuIduTypeVgDataVoice2 = 7;
    public static final int RbSuIduTypeNgData4Wireless = 11;
    private Integer rbSuExternalDevNumber;
    private Long rbSuCumulativePowerOnTime;
    private Integer rbSuType;
    private Integer rbSuAirInterfaceType;
    private Integer rbSuMACControlNumber;
    public static final int RbSuTypeUnknown = 0;
    public static final int RbSuTypeCpe = 1;
    public static final int RbSuTypeCpe_pro = 2;
    public static final int RbSuTypeCpe_si = 3;
    public static final int RbSuTypeCpe_pro_L = 4;
    public static final int RbSuTypeCpeSiL = 5;
    public static final int RbSuTypeCpe2Pro = 6;
    public static final int RbSuTypeCpe2Si = 7;
    public static final int RbSuTypeCpe2ProL = 8;
    public static final int RbSuTypeCpe2SiL = 9;
    public static final int RbSuAirInterfaceTypeTypeA = 1;
    public static final int RbSuAirInterfaceTypeTypeSi = 2;
    public static final int RbSuAirInterfaceTypeUnknown = 0;
    private String rbSuSimpleMacAddr;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.1", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAuId() {
        return this.rbAuId;
    }

    public void setRbAuId(Integer rbAuId) {
        this.rbAuId = rbAuId;
    }

    @Pattern(regex="^(\\p{XDigit}{2}:){5}(\\p{XDigit}{2})$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112, readOnly=true)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
        this.setRbSuSimpleMacAddr(null != rbSuMacAddr ? MacAddress.fromOctetString((String)rbSuMacAddr).toSimpleString() : null);
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.3", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuID() {
        return this.rbSuID;
    }

    public void setRbSuID(Integer rbSuID) {
        this.rbSuID = rbSuID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.4", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuRegistrationState() {
        return this.rbSuRegistrationState;
    }

    public void setRbSuRegistrationState(Integer rbSuRegistrationState) {
        this.rbSuRegistrationState = rbSuRegistrationState;
    }

    public String toStringRbSuRegistrationState(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "notRegistered(1)";
                break;
            }
            case 2: {
                result = "registered(2)";
                break;
            }
            case 3: {
                result = "authenticated(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakRange(min=1L, max=2L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.5", type=2)
    @ConfigAttribute
    public Integer getRbSuPersistence() {
        return this.rbSuPersistence;
    }

    public void setRbSuPersistence(Integer rbSuPersistence) {
        this.rbSuPersistence = rbSuPersistence;
    }

    @Transient
    public boolean isTemporary() {
        return new Integer(1).equals(this.rbSuPersistence);
    }

    public static String toStringRbSuPersistence(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "temporary(1)";
                break;
            }
            case 2: {
                result = "permanent(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.6", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbSuSerialNo() {
        return this.rbSuSerialNo;
    }

    public void setRbSuSerialNo(String rbSuSerialNo) {
        this.rbSuSerialNo = rbSuSerialNo;
    }

    @Length(min=0, max=32)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.7", type=-128)
    @ConfigAttribute
    public String getRbSuSysName() {
        return this.rbSuSysName;
    }

    public void setRbSuSysName(String rbSuSysName) {
        this.rbSuSysName = rbSuSysName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.8", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuFaultStatus() {
        return this.rbSuFaultStatus;
    }

    public void setRbSuFaultStatus(Integer rbSuFaultStatus) {
        this.rbSuFaultStatus = rbSuFaultStatus;
    }

    public String toStringRbSuFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noFaults(1)";
                break;
            }
            case 2: {
                result = "minor(2)";
                break;
            }
            case 3: {
                result = "major(3)";
                break;
            }
            case 4: {
                result = "critical(4)";
                break;
            }
            case 5: {
                result = "disconnected(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.9", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbSuHwRevision() {
        return this.rbSuHwRevision;
    }

    public void setRbSuHwRevision(String rbSuHwRevision) {
        this.rbSuHwRevision = rbSuHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.10", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSuOperSwFileName() {
        return this.rbSuOperSwFileName;
    }

    public void setRbSuOperSwFileName(String rbSuOperSwFileName) {
        this.rbSuOperSwFileName = rbSuOperSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.11", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSuOperSwVersion() {
        return this.rbSuOperSwVersion;
    }

    public void setRbSuOperSwVersion(String rbSuOperSwVersion) {
        this.rbSuOperSwVersion = rbSuOperSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.12", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSuShadowSwFileName() {
        return this.rbSuShadowSwFileName;
    }

    public void setRbSuShadowSwFileName(String rbSuShadowSwFileName) {
        this.rbSuShadowSwFileName = rbSuShadowSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.13", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSuShadowSwVersion() {
        return this.rbSuShadowSwVersion;
    }

    public void setRbSuShadowSwVersion(String rbSuShadowSwVersion) {
        this.rbSuShadowSwVersion = rbSuShadowSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.14", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuRunningSoftware() {
        return this.rbSuRunningSoftware;
    }

    public void setRbSuRunningSoftware(Integer rbSuRunningSoftware) {
        this.rbSuRunningSoftware = rbSuRunningSoftware;
    }

    public String toStringRbSuRunningSoftware(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "operational(1)";
                break;
            }
            case 2: {
                result = "shadow(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toStringRbSuOperVersionValidity(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "corrupted(1)";
                break;
            }
            case 2: {
                result = "valid(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.19", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuAllowedUsersType() {
        return this.rbSuAllowedUsersType;
    }

    public void setRbSuAllowedUsersType(Integer rbSuAllowedUsersType) {
        this.rbSuAllowedUsersType = rbSuAllowedUsersType;
    }

    public String toStringRbSuAllowedUsersType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "residentional(1)";
                break;
            }
            case 2: {
                result = "unknown(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.20", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuAllowedQoS() {
        return this.rbSuAllowedQoS;
    }

    public void setRbSuAllowedQoS(Integer rbSuAllowedQoS) {
        this.rbSuAllowedQoS = rbSuAllowedQoS;
    }

    public String toStringRbSuAllowedQoS(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "residentional(1)";
                break;
            }
            case 2: {
                result = "unknown(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.21", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbSuAllowedService() {
        return this.rbSuAllowedService;
    }

    public void setRbSuAllowedService(String rbSuAllowedService) {
        this.rbSuAllowedService = rbSuAllowedService;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.22", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbSuRowStatus;
    }

    public void setRowStatus(Integer rbSuRowStatus) {
        this.rbSuRowStatus = rbSuRowStatus;
    }

    public String toStringRbSuRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.24", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbSuHwConfigDescription() {
        return this.rbSuHwConfigDescription;
    }

    public void setRbSuHwConfigDescription(String rbSuHwConfigDescription) {
        this.rbSuHwConfigDescription = rbSuHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.25", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(min=0, max=255)
    @StateAttribute
    public String getRbSuUpgradeSwFileName() {
        return this.rbSuUpgradeSwFileName;
    }

    public void setRbSuUpgradeSwFileName(String rbSuUpgradeSwFileName) {
        this.rbSuUpgradeSwFileName = rbSuUpgradeSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.26", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuServiceType() {
        return this.rbSuServiceType;
    }

    public void setRbSuServiceType(Integer rbSuServiceType) {
        this.rbSuServiceType = rbSuServiceType;
    }

    public String toStringRbSuServiceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "suData(1)";
                break;
            }
            case 2: {
                result = "suVoice(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.27", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuIduType() {
        return this.rbSuIduType;
    }

    public void setRbSuIduType(Integer rbSuIduType) {
        this.rbSuIduType = rbSuIduType;
    }

    public String toStringRbSuIduType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "basic(0)";
                break;
            }
            case 4: {
                result = "vgDataVoice(4)";
                break;
            }
            case 6: {
                result = "vgData4Voice2(6)";
                break;
            }
            case 7: {
                result = "vgDataVoice2(7)";
                break;
            }
            case 11: {
                result = "ngData4Wireless(11)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.28", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbSuExternalDevNumber() {
        return this.rbSuExternalDevNumber;
    }

    public void setRbSuExternalDevNumber(Integer rbSuExternalDevNumber) {
        this.rbSuExternalDevNumber = rbSuExternalDevNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.30", type=66, readOnly=true)
    @StateAttribute
    public Long getRbSuCumulativePowerOnTime() {
        return this.rbSuCumulativePowerOnTime;
    }

    public void setRbSuCumulativePowerOnTime(Long rbSuCumulativePowerOnTime) {
        this.rbSuCumulativePowerOnTime = rbSuCumulativePowerOnTime;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.3.1.4", type=2)
    @InventoryAttribute
    public Integer getRbSuType() {
        return this.rbSuType;
    }

    public void setRbSuType(Integer rbSuType) {
        this.rbSuType = rbSuType;
    }

    public static String toStringRbSuType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "UNKNOWN";
                break;
            }
            case 1: {
                result = "CPE";
                break;
            }
            case 2: {
                result = "CPE_PRO";
                break;
            }
            case 3: {
                result = "CPE_SI";
                break;
            }
            case 4: {
                result = "CPE_PRO_L";
                break;
            }
            case 5: {
                result = "CPE_SI_L";
                break;
            }
            case 6: {
                result = "CPE_2_PRO";
                break;
            }
            case 7: {
                result = "CPE_2_SI";
                break;
            }
            case 8: {
                result = "CPE_2_PRO_L";
                break;
            }
            case 9: {
                result = "CPE_2_SI_L";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuId=").append(this.rbAuId).append(", ");
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuID=").append(this.rbSuID).append(", ");
        result.append("rbSuRegistrationState=").append(this.toStringRbSuRegistrationState(this.rbSuRegistrationState)).append(", ");
        result.append("rbSuPersistence=").append(RbRegisteredSuEntry.toStringRbSuPersistence(this.rbSuPersistence)).append(", ");
        result.append("rbSuSerialNo=").append(this.rbSuSerialNo).append(", ");
        result.append("rbSuSysName=").append(this.rbSuSysName).append(", ");
        result.append("rbSuFaultStatus=").append(this.toStringRbSuFaultStatus(this.rbSuFaultStatus)).append(", ");
        result.append("rbSuHwRevision=").append(this.rbSuHwRevision).append(", ");
        result.append("rbSuOperSwFileName=").append(this.rbSuOperSwFileName).append(", ");
        result.append("rbSuOperSwVersion=").append(this.rbSuOperSwVersion).append(", ");
        result.append("rbSuShadowSwFileName=").append(this.rbSuShadowSwFileName).append(", ");
        result.append("rbSuShadowSwVersion=").append(this.rbSuShadowSwVersion).append(", ");
        result.append("rbSuRunningSoftware=").append(this.toStringRbSuRunningSoftware(this.rbSuRunningSoftware)).append(", ");
        result.append("rbSuAllowedUsersType=").append(this.toStringRbSuAllowedUsersType(this.rbSuAllowedUsersType)).append(", ");
        result.append("rbSuAllowedQoS=").append(this.toStringRbSuAllowedQoS(this.rbSuAllowedQoS)).append(", ");
        result.append("rbSuAllowedService=").append(this.rbSuAllowedService).append(", ");
        result.append("rbSuRowStatus=").append(this.toStringRbSuRowStatus(this.rbSuRowStatus)).append(", ");
        result.append("rbSuHwConfigDescription=").append(this.rbSuHwConfigDescription).append(", ");
        result.append("rbSuUpgradeSwFileName=").append(this.rbSuUpgradeSwFileName).append(", ");
        result.append("rbSuServiceType=").append(this.toStringRbSuServiceType(this.rbSuServiceType)).append(", ");
        result.append("rbSuIduType=").append(this.toStringRbSuIduType(this.rbSuIduType)).append(", ");
        result.append("rbSuType=").append(RbRegisteredSuEntry.toStringRbSuType(this.rbSuType)).append(", ");
        result.append("rbSuExternalDevNumber=").append(this.rbSuExternalDevNumber).append(", ");
        result.append("rbSuAirInterfaceType=").append(RbRegisteredSuEntry.toStringRbSuAirInterfaceType(this.rbSuAirInterfaceType)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSuMacAddr();
    }

    @Transient
    public String getRuningSwVersion() {
        switch (this.rbSuRunningSoftware) {
            case 1: {
                return this.rbSuOperSwVersion;
            }
            case 2: {
                return this.rbSuShadowSwVersion;
            }
        }
        return "N/A";
    }

    @Transient
    public boolean isConnected() {
        return this.rbSuRegistrationState == 2 || this.rbSuRegistrationState == 3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.35", type=2)
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuAirInterfaceType() {
        return this.rbSuAirInterfaceType;
    }

    public void setRbSuAirInterfaceType(Integer rbSuAirInterfaceType) {
        this.rbSuAirInterfaceType = rbSuAirInterfaceType;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.34", type=2, readOnly=true)
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuMACControlNumber() {
        return this.rbSuMACControlNumber;
    }

    public void setRbSuMACControlNumber(Integer rbSuMACControlNumber) {
        this.rbSuMACControlNumber = rbSuMACControlNumber;
    }

    public static String toStringRbSuAirInterfaceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "typeA(1)";
                break;
            }
            case 2: {
                result = "typeSi(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String getRbSuSimpleMacAddr() {
        return this.rbSuSimpleMacAddr;
    }

    private void setRbSuSimpleMacAddr(String rbSuSimpleMacAddr) {
        this.rbSuSimpleMacAddr = rbSuSimpleMacAddr;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRegisteredSuEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRegisteredSuEntry>(){

            public ManagedObjectAccessHandler<RbRegisteredSuEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRegisteredSuEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRegisteredSuEntry>(){

            public ManagedObjectAccessHandler<RbRegisteredSuEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbRegisteredSuEntry>(RbRegisteredSuEntry.class){

                    public List<RbRegisteredSuEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
                        if (instanceQuery != null && !"*".equals(instanceQuery)) {
                            instanceQuery = MacAddress.fromOctetString((String)instanceQuery).toInstanceString();
                        }
                        return super.fetch(eq, access, networkResource, instanceQuery);
                    }

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbRegisteredSuEntry managedObject) throws MediationException {
                        if (null != managedObject.getRbSuAirInterfaceType() && 2 == managedObject.getRbSuAirInterfaceType()) {
                            managedObject.setRbSuSysName(null);
                        }
                        super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
                    }

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbRegisteredSuEntry managedObject) throws MediationException {
                        if (null != managedObject.getRbSuAirInterfaceType() && 2 == managedObject.getRbSuAirInterfaceType()) {
                            managedObject.setRbSuSysName(null);
                        }
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbRegisteredSuEntry, SuDb_Su> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbRegisteredSuEntry createEntry() {
            return new RbRegisteredSuEntry();
        }

        @Override
        protected Class<SuDb_Su> getDataObjectClass() {
            return SuDb_Su.class;
        }

        @Override
        protected void populateEntry(RbRegisteredSuEntry entry, SuDb_Su dataObject) {
            entry.setRbSuMacAddr(dataObject.getMACAddress().toUpperCase());
            entry.setRbSuSysName(dataObject.getName());
            entry.setRbSuPersistence(dataObject.getStatus());
            entry.setRbSuUpgradeSwFileName(dataObject.getSWFileName());
        }

        @Override
        public List<RbRegisteredSuEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            if (instanceQuery == null || "*".equals(instanceQuery)) {
                return super.fetch(eq, access, networkResource, instanceQuery);
            }
            if (instanceQuery.contains("*")) {
                throw new UnsupportedOperationException("Config file - fetch operation wrong instance query format");
            }
            instanceQuery = instanceQuery.toLowerCase();
            ArrayList<RbRegisteredSuEntry> entries = new ArrayList<RbRegisteredSuEntry>();
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.getDataObjectClass());
            List dataObjects = access.fetchObject(networkResource, this.getDataObjectClass(), includedProperties, instanceQuery);
            for (SuDb_Su dataObject : dataObjects) {
                if (!instanceQuery.equals(dataObject.getMACAddress())) continue;
                RbRegisteredSuEntry entry = this.createEntry();
                this.populateEntry(entry, dataObject);
                entries.add(entry);
                break;
            }
            return entries;
        }
    }
}

