/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AaaCfg_Aaa;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.validation.WeakRange;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="RbRadiusClientGeneralParam")
public class RbRadiusClientGeneralParameters
extends ScalarMO {
    private static final long serialVersionUID = -5577658416070379278L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbRadiusClientRetryInterval;
    private Integer rbRadiusClientMaxNumOfRetries;
    private Integer rbRadiusClientKeepAliveTimeout;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=5L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.1.2", type=2)
    @ConfigAttribute
    public Integer getRbRadiusClientRetryInterval() {
        return this.rbRadiusClientRetryInterval;
    }

    public void setRbRadiusClientRetryInterval(Integer rbRadiusClientRetryInterval) {
        this.rbRadiusClientRetryInterval = rbRadiusClientRetryInterval;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=0L, max=5L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.1.3", type=2)
    @Column(name="rbRadiusClientMaxNumOfRetr")
    @ConfigAttribute
    public Integer getRbRadiusClientMaxNumOfRetries() {
        return this.rbRadiusClientMaxNumOfRetries;
    }

    public void setRbRadiusClientMaxNumOfRetries(Integer rbRadiusClientMaxNumOfRetries) {
        this.rbRadiusClientMaxNumOfRetries = rbRadiusClientMaxNumOfRetries;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbRadiusClientRetryInterval=").append(this.rbRadiusClientRetryInterval).append(", ");
        result.append("rbRadiusClientMaxNumOfRetries=").append(this.rbRadiusClientMaxNumOfRetries).append(", ");
        result.append("rbRadiusClientKeepAliveTimeout=").append(this.rbRadiusClientKeepAliveTimeout).append(", ");
        result.append("]");
        return result.toString();
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.1.4", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=60L, max=180L)
    @ConfigAttribute
    public Integer getRbRadiusClientKeepAliveTimeout() {
        return this.rbRadiusClientKeepAliveTimeout;
    }

    public void setRbRadiusClientKeepAliveTimeout(Integer rbRadiusClientKeepAliveTimeout) {
        this.rbRadiusClientKeepAliveTimeout = rbRadiusClientKeepAliveTimeout;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusClientGeneralParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusClientGeneralParameters>(){

            public ManagedObjectAccessHandler<RbRadiusClientGeneralParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusClientGeneralParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusClientGeneralParameters>(){

            public ManagedObjectAccessHandler<RbRadiusClientGeneralParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbRadiusClientGeneralParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbRadiusClientGeneralParameters, AaaCfg_Aaa> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbRadiusClientGeneralParameters createEntry() {
            return new RbRadiusClientGeneralParameters();
        }

        @Override
        protected Class<AaaCfg_Aaa> getDataObjectClass() {
            return AaaCfg_Aaa.class;
        }

        @Override
        protected void populateEntry(RbRadiusClientGeneralParameters entry, AaaCfg_Aaa dataObject) {
            entry.setRbRadiusClientMaxNumOfRetries(dataObject.getMaxRetries());
            entry.setRbRadiusClientRetryInterval(dataObject.getRetransmitInterval());
            entry.setRbRadiusClientKeepAliveTimeout(dataObject.getKeepAliveTimeout());
        }
    }
}

