/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.ExactMatchFilter;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.FiltersOn;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.RbRadiusAuthServerTable;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuthServDb_AuthServ;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Pattern;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.150.2.1", indexColumns={"RbRadiusAuthServerAddress"})
public class RbRadiusAuthServerEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = -5058789939701331007L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbRadiusAuthServerAddress;
    private Integer rbRadiusAuthServerRowStatus;
    private Integer rbRadiusAuthServerIndex;
    private Integer rbRadiusAuthServerPortNumber;
    private Integer rbRadiusAuthServerOperStatus;
    private Integer rbRadiusAuthServerStatus;
    private Integer rbRadiusAuthServerType;
    private Integer rbRadiusAuthServerVlanId;
    private String rbRadiusAuthServerGateway;
    private String rbRadiusAuthServerSubnetMask;
    private String rbRadiusAuthServerIfcIpAddress;
    private Integer rbRadiusAuthDataPortAdopt;
    public static final int DataPortAdoptNone = 0;
    public static final int DataPortAdoptYes = 1;
    public static final int DataPortAdoptNo = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusNotInService = 2;
    public static final int RowStatusNotReady = 3;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusCreateAndWait = 5;
    public static final int RowStatusDestroy = 6;
    public static final int RbRadiusAuthServerOperStatusDown = 2;
    public static final int RbRadiusAuthServerOperStatusUp = 1;
    public static final int RbRadiusAuthServerStatusActive = 1;
    public static final int RbRadiusAuthServerStatusStandby = 2;
    public static final int RbRadiusAuthServerTypePrimary = 1;
    public static final int RbRadiusAuthServerTypeSecondary = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.9", type=2)
    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    public Integer getRbRadiusAuthServerVlanId() {
        return this.rbRadiusAuthServerVlanId;
    }

    public void setRbRadiusAuthServerVlanId(Integer rbRadiusAuthServerVlanId) {
        this.rbRadiusAuthServerVlanId = rbRadiusAuthServerVlanId;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.13", type=2)
    @ConfigAttribute
    public Integer getRbRadiusAuthDataPortAdopt() {
        return this.rbRadiusAuthDataPortAdopt;
    }

    public void setRbRadiusAuthDataPortAdopt(Integer rbRadiusAuthDataPortAdopt) {
        this.rbRadiusAuthDataPortAdopt = rbRadiusAuthDataPortAdopt;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.1", type=64, readOnly=true)
    @IdentifierAttribute
    public String getRbRadiusAuthServerAddress() {
        return this.rbRadiusAuthServerAddress;
    }

    public void setRbRadiusAuthServerAddress(String rbRadiusAuthServerAddress) {
        this.rbRadiusAuthServerAddress = rbRadiusAuthServerAddress;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.2", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbRadiusAuthServerRowStatus;
    }

    public void setRowStatus(Integer rbRadiusAuthServerRowStatus) {
        this.rbRadiusAuthServerRowStatus = rbRadiusAuthServerRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.3", type=2)
    @StateAttribute
    public Integer getRbRadiusAuthServerIndex() {
        return this.rbRadiusAuthServerIndex;
    }

    public void setRbRadiusAuthServerIndex(Integer rbRadiusAuthServerIndex) {
        this.rbRadiusAuthServerIndex = rbRadiusAuthServerIndex;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=0L, max=65535L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.4", type=2)
    @ConfigAttribute
    public Integer getRbRadiusAuthServerPortNumber() {
        return this.rbRadiusAuthServerPortNumber;
    }

    public void setRbRadiusAuthServerPortNumber(Integer rbRadiusAuthServerPortNumber) {
        this.rbRadiusAuthServerPortNumber = rbRadiusAuthServerPortNumber;
    }

    @Transient
    public String getRowKey() {
        return this.getRbRadiusAuthServerAddress();
    }

    public static String toStringRbRadiusAuthServerOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbRadiusAuthServerStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "standby(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbRadiusAuthServerType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "primary(1)";
                break;
            }
            case 2: {
                result = "secondary(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.7", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    public Integer getRbRadiusAuthServerOperStatus() {
        return this.rbRadiusAuthServerOperStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.6", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    public Integer getRbRadiusAuthServerStatus() {
        return this.rbRadiusAuthServerStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.5", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    public Integer getRbRadiusAuthServerType() {
        return this.rbRadiusAuthServerType;
    }

    public void setRbRadiusAuthServerOperStatus(Integer rbRadiusAuthServerOperStatus) {
        this.rbRadiusAuthServerOperStatus = rbRadiusAuthServerOperStatus;
    }

    public void setRbRadiusAuthServerStatus(Integer rbRadiusAuthServerStatus) {
        this.rbRadiusAuthServerStatus = rbRadiusAuthServerStatus;
    }

    public void setRbRadiusAuthServerType(Integer rbRadiusAuthServerType) {
        this.rbRadiusAuthServerType = rbRadiusAuthServerType;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.10", type=64)
    @ConfigAttribute
    public String getRbRadiusAuthServerGateway() {
        return this.rbRadiusAuthServerGateway;
    }

    public void setRbRadiusAuthServerGateway(String rbRadiusAuthServerGateway) {
        this.rbRadiusAuthServerGateway = rbRadiusAuthServerGateway;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.11", type=64)
    @ConfigAttribute
    public String getRbRadiusAuthServerSubnetMask() {
        return this.rbRadiusAuthServerSubnetMask;
    }

    public void setRbRadiusAuthServerSubnetMask(String rbRadiusAuthServerSubnetMask) {
        this.rbRadiusAuthServerSubnetMask = rbRadiusAuthServerSubnetMask;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.2.1.12", type=64)
    @ConfigAttribute
    public String getRbRadiusAuthServerIfcIpAddress() {
        return this.rbRadiusAuthServerIfcIpAddress;
    }

    public void setRbRadiusAuthServerIfcIpAddress(String rbRadiusAuthServerIfcIpAddress) {
        this.rbRadiusAuthServerIfcIpAddress = rbRadiusAuthServerIfcIpAddress;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbRadiusAuthServerAddress=").append(this.rbRadiusAuthServerAddress).append(", ");
        result.append("rbRadiusAuthServerRowStatus=").append(RbRadiusAuthServerEntry.toStringRowStatus(this.rbRadiusAuthServerRowStatus)).append(", ");
        result.append("rbRadiusAuthServerIndex=").append(this.rbRadiusAuthServerIndex).append(", ");
        result.append("rbRadiusAuthServerPortNumber=").append(this.rbRadiusAuthServerPortNumber).append(", ");
        result.append("rbRadiusAuthServerType=").append(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerType(this.rbRadiusAuthServerType)).append(", ");
        result.append("rbRadiusAuthServerStatus=").append(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerStatus(this.rbRadiusAuthServerStatus)).append(", ");
        result.append("rbRadiusAuthServerOperStatus=").append(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerOperStatus(this.rbRadiusAuthServerOperStatus)).append(", ");
        result.append("rbRadiusAuthServerGateway=").append(this.rbRadiusAuthServerGateway).append(", ");
        result.append("rbRadiusAuthServerSubnetMask=").append(this.rbRadiusAuthServerSubnetMask).append(", ");
        result.append("rbRadiusAuthServerVlanId=").append(this.rbRadiusAuthServerVlanId).append(", ");
        result.append("rbRadiusAuthDataPortAdopt=").append(this.rbRadiusAuthDataPortAdopt).append(", ");
        result.append("rbRadiusAuthServerIfcIpAddress=").append(this.rbRadiusAuthServerIfcIpAddress).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusAuthServerEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusAuthServerEntry>(){

            public ManagedObjectAccessHandler<RbRadiusAuthServerEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusAuthServerEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusAuthServerEntry>(){

            public ManagedObjectAccessHandler<RbRadiusAuthServerEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbRadiusAuthServerEntry>(RbRadiusAuthServerEntry.class){

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbRadiusAuthServerEntry managedObject) throws MediationException {
                        if (managedObject.getRbRadiusAuthServerOperStatus() != null) {
                            RbRadiusAuthServerTable table = new RbRadiusAuthServerTable(access.fetchObject(networkResource, RbRadiusAuthServerEntry.class));
                            for (RbRadiusAuthServerEntry entry : table.getEntries()) {
                                if (!managedObject.getRbRadiusAuthServerType().equals(entry.getRbRadiusAuthServerType()) || !managedObject.getRbRadiusAuthServerAddress().startsWith("127.0.0.")) continue;
                                if (null == managedObject.getRbRadiusAuthServerGateway()) {
                                    super.delete(eq, access, networkResource, (DynamicTableRowMO)entry);
                                    continue;
                                }
                                if (!entry.getRbRadiusAuthServerAddress().equals(managedObject.getRbRadiusAuthServerGateway())) continue;
                                super.delete(eq, access, networkResource, (DynamicTableRowMO)entry);
                            }
                        } else {
                            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
                        }
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbRadiusAuthServerEntry, AuthServDb_AuthServ> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbRadiusAuthServerEntry createEntry() {
            return new RbRadiusAuthServerEntry();
        }

        @Override
        protected Class<AuthServDb_AuthServ> getDataObjectClass() {
            return AuthServDb_AuthServ.class;
        }

        @Override
        protected void populateEntry(RbRadiusAuthServerEntry entry, AuthServDb_AuthServ dataObject) {
            entry.setRbRadiusAuthServerIndex(dataObject.getINDEX());
            entry.setRbRadiusAuthServerAddress(dataObject.getIpAddress());
            entry.setRbRadiusAuthServerPortNumber(dataObject.getUdpPort());
            entry.setRbRadiusAuthServerType(dataObject.getRowIndex() == 0 ? 1 : 2);
        }
    }
}

