/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.ExactMatchFilter;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.FiltersOn;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.RbRadiusAccountServerTable;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AcctServDb_AcctServ;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Pattern;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.150.3.1", indexColumns={"RbRadiusAcctServerAddress"})
public class RbRadiusAccountServerEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = 7259909003692543149L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbRadiusAcctServerAddress;
    private Integer rbRadiusAcctServerRowStatus;
    private Integer rbRadiusAcctServerIndex;
    private Integer rbRadiusAcctServerPortNumber;
    private Integer rbRadiusAcctServerStatus;
    private Integer rbRadiusAcctServerOperStatus;
    private Integer rbRadiusAcctServerType;
    private String rbRadiusAcctServerGateway;
    private String rbRadiusAcctServerSubnetMask;
    private String rbRadiusAcctServerIfcIpAddress;
    private Integer rbRadiusAcctServerVlanId;
    private Integer rbRadiusAcctDataPortAdopt;
    public static final int DataPortAdoptNone = 0;
    public static final int DataPortAdoptYes = 1;
    public static final int DataPortAdoptNo = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusNotInService = 2;
    public static final int RowStatusNotReady = 3;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusCreateAndWait = 5;
    public static final int RowStatusDestroy = 6;
    public static final int RbRadiusAcctServerOperStatusDown = 2;
    public static final int RbRadiusAcctServerOperStatusUp = 1;
    public static final int RbRadiusAcctServerStatusActive = 1;
    public static final int RbRadiusAcctServerStatusStandby = 2;
    public static final int RbRadiusAcctServerTypePrimary = 1;
    public static final int RbRadiusAcctServerTypeSecondary = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.9", type=2)
    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    public Integer getRbRadiusAcctServerVlanId() {
        return this.rbRadiusAcctServerVlanId;
    }

    public void setRbRadiusAcctServerVlanId(Integer rbRadiusAcctServerVlanId) {
        this.rbRadiusAcctServerVlanId = rbRadiusAcctServerVlanId;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.13", type=2)
    @ConfigAttribute
    public Integer getRbRadiusAcctDataPortAdopt() {
        return this.rbRadiusAcctDataPortAdopt;
    }

    public void setRbRadiusAcctDataPortAdopt(Integer rbRadiusAcctDataPortAdopt) {
        this.rbRadiusAcctDataPortAdopt = rbRadiusAcctDataPortAdopt;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.1", type=64)
    @ConfigAttribute
    public String getRbRadiusAcctServerAddress() {
        return this.rbRadiusAcctServerAddress;
    }

    public void setRbRadiusAcctServerAddress(String rbRadiusAcctServerAddress) {
        this.rbRadiusAcctServerAddress = rbRadiusAcctServerAddress;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.2", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbRadiusAcctServerRowStatus;
    }

    public void setRowStatus(Integer rbRadiusAcctServerRowStatus) {
        this.rbRadiusAcctServerRowStatus = rbRadiusAcctServerRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.3", type=2)
    @StateAttribute
    public Integer getRbRadiusAcctServerIndex() {
        return this.rbRadiusAcctServerIndex;
    }

    public void setRbRadiusAcctServerIndex(Integer rbRadiusAcctServerIndex) {
        this.rbRadiusAcctServerIndex = rbRadiusAcctServerIndex;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=0L, max=65535L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.4", type=2)
    @ConfigAttribute
    public Integer getRbRadiusAcctServerPortNumber() {
        return this.rbRadiusAcctServerPortNumber;
    }

    public void setRbRadiusAcctServerPortNumber(Integer rbRadiusAcctServerPortNumber) {
        this.rbRadiusAcctServerPortNumber = rbRadiusAcctServerPortNumber;
    }

    @Transient
    public String getRowKey() {
        return this.getRbRadiusAcctServerAddress();
    }

    public static String toStringRbRadiusAcctServerOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbRadiusAcctServerStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "standby(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbRadiusAcctServerType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "primary(1)";
                break;
            }
            case 2: {
                result = "secondary(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.7", type=2)
    public Integer getRbRadiusAcctServerOperStatus() {
        return this.rbRadiusAcctServerOperStatus;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.6", type=2)
    public Integer getRbRadiusAcctServerStatus() {
        return this.rbRadiusAcctServerStatus;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @WeakRange(min=1L, max=2L)
    @StateAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.5", type=2)
    public Integer getRbRadiusAcctServerType() {
        return this.rbRadiusAcctServerType;
    }

    public void setRbRadiusAcctServerOperStatus(Integer rbRadiusAcctServerOperStatus) {
        this.rbRadiusAcctServerOperStatus = rbRadiusAcctServerOperStatus;
    }

    public void setRbRadiusAcctServerStatus(Integer rbRadiusAcctServerStatus) {
        this.rbRadiusAcctServerStatus = rbRadiusAcctServerStatus;
    }

    public void setRbRadiusAcctServerType(Integer rbRadiusAcctServerType) {
        this.rbRadiusAcctServerType = rbRadiusAcctServerType;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.10", type=64)
    @ConfigAttribute
    public String getRbRadiusAcctServerGateway() {
        return this.rbRadiusAcctServerGateway;
    }

    public void setRbRadiusAcctServerGateway(String rbRadiusAcctServerGateway) {
        this.rbRadiusAcctServerGateway = rbRadiusAcctServerGateway;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.11", type=64)
    @ConfigAttribute
    public String getRbRadiusAcctServerSubnetMask() {
        return this.rbRadiusAcctServerSubnetMask;
    }

    public void setRbRadiusAcctServerSubnetMask(String rbRadiusAcctServerSubnetMask) {
        this.rbRadiusAcctServerSubnetMask = rbRadiusAcctServerSubnetMask;
    }

    @FiltersOn(filters={@Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"}), @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})})
    @Pattern(regex="^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.150.3.1.12", type=64)
    @ConfigAttribute
    public String getRbRadiusAcctServerIfcIpAddress() {
        return this.rbRadiusAcctServerIfcIpAddress;
    }

    public void setRbRadiusAcctServerIfcIpAddress(String rbRadiusAcctServerIfcIpAddress) {
        this.rbRadiusAcctServerIfcIpAddress = rbRadiusAcctServerIfcIpAddress;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbRadiusAcctServerAddress=").append(this.rbRadiusAcctServerAddress).append(", ");
        result.append("rbRadiusAcctServerRowStatus=").append(RbRadiusAccountServerEntry.toStringRowStatus(this.rbRadiusAcctServerRowStatus)).append(", ");
        result.append("rbRadiusAcctServerIndex=").append(this.rbRadiusAcctServerIndex).append(", ");
        result.append("rbRadiusAcctServerPortNumber=").append(this.rbRadiusAcctServerPortNumber).append(", ");
        result.append("rbRadiusAcctServerType=").append(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerType(this.rbRadiusAcctServerType)).append(", ");
        result.append("rbRadiusAcctServerStatus=").append(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerStatus(this.rbRadiusAcctServerStatus)).append(", ");
        result.append("rbRadiusAcctServerOperStatus=").append(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerOperStatus(this.rbRadiusAcctServerOperStatus)).append(", ");
        result.append("rbRadiusAcctServerGateway=").append(this.rbRadiusAcctServerGateway).append(", ");
        result.append("rbRadiusAcctServerSubnetMask=").append(this.rbRadiusAcctServerSubnetMask).append(", ");
        result.append("rbRadiusAcctDataPortAdopt=").append(this.rbRadiusAcctDataPortAdopt).append(", ");
        result.append("rbRadiusAcctServerVlanId=").append(this.rbRadiusAcctServerVlanId).append(", ");
        result.append("rbRadiusAcctServerIfcIpAddress=").append(this.rbRadiusAcctServerIfcIpAddress).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusAccountServerEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusAccountServerEntry>(){

            public ManagedObjectAccessHandler<RbRadiusAccountServerEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadiusAccountServerEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadiusAccountServerEntry>(){

            public ManagedObjectAccessHandler<RbRadiusAccountServerEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbRadiusAccountServerEntry>(RbRadiusAccountServerEntry.class){

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbRadiusAccountServerEntry managedObject) throws MediationException {
                        if (managedObject.getRbRadiusAcctServerOperStatus() != null) {
                            RbRadiusAccountServerTable table = new RbRadiusAccountServerTable(access.fetchObject(networkResource, RbRadiusAccountServerEntry.class));
                            for (RbRadiusAccountServerEntry entry : table.getEntries()) {
                                if (!managedObject.getRbRadiusAcctServerType().equals(entry.getRbRadiusAcctServerType()) || !managedObject.getRbRadiusAcctServerAddress().startsWith("127.0.0.")) continue;
                                if (null == managedObject.getRbRadiusAcctServerGateway()) {
                                    super.delete(eq, access, networkResource, (DynamicTableRowMO)entry);
                                    continue;
                                }
                                if (!entry.getRbRadiusAcctServerAddress().equals(managedObject.getRbRadiusAcctServerGateway())) continue;
                                super.delete(eq, access, networkResource, (DynamicTableRowMO)entry);
                            }
                        } else {
                            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
                        }
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbRadiusAccountServerEntry, AcctServDb_AcctServ> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbRadiusAccountServerEntry createEntry() {
            return new RbRadiusAccountServerEntry();
        }

        @Override
        protected Class<AcctServDb_AcctServ> getDataObjectClass() {
            return AcctServDb_AcctServ.class;
        }

        @Override
        protected void populateEntry(RbRadiusAccountServerEntry entry, AcctServDb_AcctServ dataObject) {
            entry.setRbRadiusAcctServerIndex(dataObject.getINDEX());
            entry.setRbRadiusAcctServerAddress(dataObject.getIpAddress());
            entry.setRbRadiusAcctServerPortNumber(dataObject.getUdpPort());
            entry.setRbRadiusAcctServerType(dataObject.getRowIndex() == 0 ? 1 : 2);
        }
    }
}

