/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.RadioClusterDb_RadioCluster;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.validator.Length;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.12.1.1", indexColumns={"RbRadioClusterId"})
public class RbRadioClusterEntry
extends DynamicTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbRadioClusterId;
    private String rbRadioClusterName;
    private String rbRadioClusterLocation;
    private Integer rbRadioClusterSectorHeading;
    private Integer rbRadioClusterSectorBeamWidth;
    private Integer rbRadioClusterRowStatus;
    public static final int RbRadioClusterRowStatusActive = 1;
    public static final int RbRadioClusterRowStatusNotInService = 2;
    public static final int RbRadioClusterRowStatusNotReady = 3;
    public static final int RbRadioClusterRowStatusCreateAndGo = 4;
    public static final int RbRadioClusterRowStatusCreateAndWait = 5;
    public static final int RbRadioClusterRowStatusDestroy = 6;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=1L, max=6L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.1", type=2, readOnly=true)
    @IdentifierAttribute
    public Integer getRbRadioClusterId() {
        return this.rbRadioClusterId;
    }

    public void setRbRadioClusterId(Integer rbRadioClusterId) {
        this.rbRadioClusterId = rbRadioClusterId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.2", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(min=0, max=32)
    @ConfigAttribute
    public String getRbRadioClusterName() {
        return this.rbRadioClusterName;
    }

    public void setRbRadioClusterName(String rbRadioClusterName) {
        this.rbRadioClusterName = rbRadioClusterName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.3", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(min=0, max=255)
    @ConfigAttribute
    public String getRbRadioClusterLocation() {
        return this.rbRadioClusterLocation;
    }

    public void setRbRadioClusterLocation(String rbRadioClusterLocation) {
        this.rbRadioClusterLocation = rbRadioClusterLocation;
    }

    @WeakRange(min=0L, max=359L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.4", type=2)
    @ConfigAttribute
    public Integer getRbRadioClusterSectorHeading() {
        return this.rbRadioClusterSectorHeading;
    }

    public void setRbRadioClusterSectorHeading(Integer rbRadioClusterSectorHeading) {
        this.rbRadioClusterSectorHeading = rbRadioClusterSectorHeading;
    }

    @WeakRange(min=0L, max=359L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.5", type=2)
    @ConfigAttribute
    public Integer getRbRadioClusterSectorBeamWidth() {
        return this.rbRadioClusterSectorBeamWidth;
    }

    public void setRbRadioClusterSectorBeamWidth(Integer rbRadioClusterSectorBeamWidth) {
        this.rbRadioClusterSectorBeamWidth = rbRadioClusterSectorBeamWidth;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.12.1.1.6", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbRadioClusterRowStatus;
    }

    public void setRowStatus(Integer rbRadioClusterRowStatus) {
        this.rbRadioClusterRowStatus = rbRadioClusterRowStatus;
    }

    public String toStringRbRadioClusterRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbRadioClusterId=").append(this.rbRadioClusterId).append(", ");
        result.append("rbRadioClusterName=").append(this.rbRadioClusterName).append(", ");
        result.append("rbRadioClusterLocation=").append(this.rbRadioClusterLocation).append(", ");
        result.append("rbRadioClusterSectorHeading=").append(this.rbRadioClusterSectorHeading).append(", ");
        result.append("rbRadioClusterSectorBeamWidth=").append(this.rbRadioClusterSectorBeamWidth).append(", ");
        result.append("rbRadioClusterRowStatus=").append(this.toStringRbRadioClusterRowStatus(this.rbRadioClusterRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Transient
    public String getRowKey() {
        return this.getRbRadioClusterId().toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadioClusterEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadioClusterEntry>(){

            public ManagedObjectAccessHandler<RbRadioClusterEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbRadioClusterEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbRadioClusterEntry>(){

            public ManagedObjectAccessHandler<RbRadioClusterEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbRadioClusterEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbRadioClusterEntry, RadioClusterDb_RadioCluster> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbRadioClusterEntry createEntry() {
            return new RbRadioClusterEntry();
        }

        @Override
        protected Class<RadioClusterDb_RadioCluster> getDataObjectClass() {
            return RadioClusterDb_RadioCluster.class;
        }

        @Override
        protected void populateEntry(RbRadioClusterEntry entry, RadioClusterDb_RadioCluster dataObject) {
            entry.setRbRadioClusterId(dataObject.getID());
            entry.setRbRadioClusterName(dataObject.getName());
            entry.setRbRadioClusterLocation(dataObject.getLocation());
            entry.setRbRadioClusterSectorBeamWidth(dataObject.getSectorAntenna().intValue());
            entry.setRbRadioClusterSectorHeading(dataObject.getSectorDirection().intValue());
        }
    }
}

