/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.QinQEntryCfg_QinQEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.9.2.1", indexColumns={"RbQinQVlanRangeIdx"})
public class RbQinQEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = 6888107429709127226L;
    private static final Logger log = Logger.getLogger(RbQinQEntry.class);
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbQinQVlanRangeIdx;
    private Integer rbQinQStartVlanRange;
    private Integer rbQinQEndVlanRange;
    private Integer rbQinQMetroTag;
    private Integer rbQinQRowStatus;
    public static final int RbQinQRowStatusActive = 1;
    public static final int RbQinQRowStatusNotInService = 2;
    public static final int RbQinQRowStatusNotReady = 3;
    public static final int RbQinQRowStatusCreateAndGo = 4;
    public static final int RbQinQRowStatusCreateAndWait = 5;
    public static final int RbQinQRowStatusDestroy = 6;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Transient
    public String getRowKey() {
        return this.rbQinQVlanRangeIdx.toString();
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.9.2.1.1", type=2)
    @ConfigAttribute
    public Integer getRbQinQVlanRangeIdx() {
        return this.rbQinQVlanRangeIdx;
    }

    public void setRbQinQVlanRangeIdx(Integer rbQinQVlanRangeIdx) {
        this.rbQinQVlanRangeIdx = rbQinQVlanRangeIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.9.2.1.2", type=2)
    @ConfigAttribute
    public Integer getRbQinQStartVlanRange() {
        return this.rbQinQStartVlanRange;
    }

    public void setRbQinQStartVlanRange(Integer rbQinQStartVlanRange) {
        this.rbQinQStartVlanRange = rbQinQStartVlanRange;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.9.2.1.3", type=2)
    @ConfigAttribute
    public Integer getRbQinQEndVlanRange() {
        return this.rbQinQEndVlanRange;
    }

    public void setRbQinQEndVlanRange(Integer rbQinQEndVlanRange) {
        this.rbQinQEndVlanRange = rbQinQEndVlanRange;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.9.2.1.4", type=2)
    @ConfigAttribute
    public Integer getRbQinQMetroTag() {
        return this.rbQinQMetroTag;
    }

    public void setRbQinQMetroTag(Integer rbQinQMetroTag) {
        this.rbQinQMetroTag = rbQinQMetroTag;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.9.2.1.5", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbQinQRowStatus;
    }

    public void setRowStatus(Integer rbQinQRowStatus) {
        this.rbQinQRowStatus = rbQinQRowStatus;
    }

    public String toStringRbQinQRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("vlan range id ").append(this.rbQinQVlanRangeIdx).append("start vlan range ").append(this.rbQinQStartVlanRange).append("end vlan range ").append(this.rbQinQEndVlanRange).append("metro tag ").append(this.rbQinQMetroTag).append("row status ").append(this.rbQinQRowStatus);
        return buffer.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbQinQEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbQinQEntry>(){

            public ManagedObjectAccessHandler<RbQinQEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbQinQEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbQinQEntry>(){

            public ManagedObjectAccessHandler<RbQinQEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbQinQEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbQinQEntry, QinQEntryCfg_QinQEntry> {
        private static final Version v_3_0 = VersionFactory.getInstance().createVersion("3.0");
        private static final Version v_4_0 = VersionFactory.getInstance().createVersion("4.0");

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbQinQEntry createEntry() {
            return new RbQinQEntry();
        }

        @Override
        protected Class<QinQEntryCfg_QinQEntry> getDataObjectClass() {
            return QinQEntryCfg_QinQEntry.class;
        }

        @Override
        protected void populateEntry(RbQinQEntry entry, QinQEntryCfg_QinQEntry dataObject) {
            entry.setRbQinQVlanRangeIdx(dataObject.getRbQinQVlanRangeIdx());
            entry.setRbQinQStartVlanRange(dataObject.getRbQinQStartVlanRange());
            entry.setRbQinQEndVlanRange(dataObject.getRbQinQEndVlanRange());
            entry.setRbQinQMetroTag(dataObject.getRbQinQMetroTag());
        }

        @Override
        public List<RbQinQEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            ArrayList<RbQinQEntry> entries = new ArrayList<RbQinQEntry>();
            Version swVersion = ((RbBaseStationEquipment)eq).getSoftwareVersion();
            if (swVersion.isOlderOrEqualWith(v_3_0) && swVersion.isNewerThan(v_4_0)) {
                List list = access.fetchObject(null, QinQEntryCfg_QinQEntry.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, QinQEntryCfg_QinQEntry.class), instanceQuery);
                for (QinQEntryCfg_QinQEntry qinQConfig : list) {
                    RbQinQEntry entry = new RbQinQEntry();
                    entry.setRbQinQVlanRangeIdx(qinQConfig.getRbQinQVlanRangeIdx());
                    entry.setRbQinQStartVlanRange(qinQConfig.getRbQinQStartVlanRange());
                    entry.setRbQinQEndVlanRange(qinQConfig.getRbQinQEndVlanRange());
                    entry.setRbQinQMetroTag(qinQConfig.getRbQinQMetroTag());
                    entries.add(entry);
                }
            }
            return entries;
        }
    }
}

