/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.NullConfigFileMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.7.1", indexColumns={"RbPsuNumber"})
public class RbPsuConfigEntry
extends StaticTableRowMO {
    public static final int PSUNumberBase = 9;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbPsuNumber;
    private Integer rbPsuStatus;
    public static final int RbPsuStatusOk = 1;
    public static final int RbPsuStatusFault = 2;
    public static final int RbPsuStatusNotInstalled = 3;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.7.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbPsuNumber() {
        return this.rbPsuNumber;
    }

    public void setRbPsuNumber(Integer rbPsuNumber) {
        this.rbPsuNumber = rbPsuNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.7.1.2", type=2)
    @StateAttribute
    public Integer getRbPsuStatus() {
        return this.rbPsuStatus;
    }

    public void setRbPsuStatus(Integer rbPsuStatus) {
        this.rbPsuStatus = rbPsuStatus;
    }

    public String toStringRbPsuStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "ok(1)";
                break;
            }
            case 2: {
                result = "fault(2)";
                break;
            }
            case 3: {
                result = "notInstalled(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbPsuNumber=").append(this.rbPsuNumber).append(", ");
        result.append("rbPsuStatus=").append(this.toStringRbPsuStatus(this.rbPsuStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPsuConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPsuConfigEntry>(){

            public ManagedObjectAccessHandler<RbPsuConfigEntry> createHandler() {
                return new NullConfigFileMOAccessHandler<RbPsuConfigEntry>();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPsuConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPsuConfigEntry>(){

            public ManagedObjectAccessHandler<RbPsuConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbPsuConfigEntry.class);
            }
        });
    }
}

