/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.NullConfigFileMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.8.1", indexColumns={"RbPiuNumber"})
public class RbPiuConfigEntry
extends StaticTableRowMO {
    public static final int PIUNumberBase = 13;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbPiuNumber;
    private String rbPiuHwRevision;
    private Integer rbPiuStatus;
    public static final int RbPiuStatusOk = 1;
    public static final int RbPiuStatusFault = 2;
    public static final int RbPiuStatusUnknown = 3;
    private Integer rbPiuMode;
    public static final Integer RbPiuModeMaster = 1;
    public static final Integer RbPiuModeRedundant = 2;
    public static final Integer RbPiuModeNotIntalled = 3;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.8.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbPiuNumber() {
        return this.rbPiuNumber;
    }

    public void setRbPiuNumber(Integer rbPiuNumber) {
        this.rbPiuNumber = rbPiuNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.8.1.4", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1"})
    public String getRbPiuHwRevision() {
        return this.rbPiuHwRevision;
    }

    public void setRbPiuHwRevision(String rbPiuHwRevision) {
        this.rbPiuHwRevision = rbPiuHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.8.1.2", type=2)
    @StateAttribute
    public Integer getRbPiuStatus() {
        return this.rbPiuStatus;
    }

    public void setRbPiuStatus(Integer rbPiuStatus) {
        this.rbPiuStatus = rbPiuStatus;
    }

    public String toStringRbPiuStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "ok(1)";
                break;
            }
            case 2: {
                result = "fault(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.8.1.3", type=2)
    @StateAttribute
    public Integer getRbPiuMode() {
        return this.rbPiuMode;
    }

    public void setRbPiuMode(Integer rbPiuMode) {
        this.rbPiuMode = rbPiuMode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbPiuNumber=").append(this.rbPiuNumber).append(", ");
        result.append("rbPiuStatus=").append(this.rbPiuMode).append(", ");
        result.append("rbPiuMode=").append(this.toStringRbPiuStatus(this.rbPiuStatus)).append(", ");
        result.append("rbPiuHwRevision=").append(this.rbPiuHwRevision);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPiuConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPiuConfigEntry>(){

            public ManagedObjectAccessHandler<RbPiuConfigEntry> createHandler() {
                return new NullConfigFileMOAccessHandler<RbPiuConfigEntry>();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPiuConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPiuConfigEntry>(){

            public ManagedObjectAccessHandler<RbPiuConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbPiuConfigEntry.class);
            }
        });
    }
}

