/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DataObjectTableRow;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.util.List;
import javax.persistence.Transient;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.4.6.1.1", indexColumns={"RbPMBurstSuMacAddr", "RbPMBurstDirection", "RbPMBurstRate"})
public class RbPMBursErrorRateEntry
implements DataObjectTableRow {
    private String rbPMBurstSuMacAddr;
    private Integer rbPMBurstDirection;
    private Integer rbPMBurstRate;
    private Long rbPMBurstTotal;
    private Long rbPMBurstError;
    private String rbPMBurstErrorRate;
    public static final int RbPMBurstDirectionDownLink = 1;
    public static final int RbPMBurstDirectionUpLink = 2;
    public static final int RbPMBurstRateNotDefined = 0;
    public static final int RbPMBurstRateRBpsk12 = 1;
    public static final int RbPMBurstRateRBpsk34 = 2;
    public static final int RbPMBurstRateRQpsk12 = 3;
    public static final int RbPMBurstRateRQpsk34 = 4;
    public static final int RbPMBurstRateR16Qam12 = 5;
    public static final int RbPMBurstRateR16Qam34 = 6;
    public static final int RbPMBurstRateR64Qam23 = 7;
    public static final int RbPMBurstRateR64Qam34 = 8;
    public static final int RbPMBurstCountersResetNoAction = 0;
    public static final int RbPMBurstCountersResetReset = 1;

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.1", type=112)
    public String getRbPMBurstSuMacAddr() {
        return this.rbPMBurstSuMacAddr;
    }

    public void setRbPMBurstSuMacAddr(String rbPMBurstSuMacAddr) {
        this.rbPMBurstSuMacAddr = rbPMBurstSuMacAddr;
    }

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.2", type=2)
    public Integer getRbPMBurstDirection() {
        return this.rbPMBurstDirection;
    }

    public void setRbPMBurstDirection(Integer rbPMBurstDirection) {
        this.rbPMBurstDirection = rbPMBurstDirection;
    }

    public static String toStringRbPMBurstDirection(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "downLink(1)";
                break;
            }
            case 2: {
                result = "upLink(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.3", type=2)
    public Integer getRbPMBurstRate() {
        return this.rbPMBurstRate;
    }

    public void setRbPMBurstRate(Integer rbPMBurstRate) {
        this.rbPMBurstRate = rbPMBurstRate;
    }

    public static String toStringRbPMBurstRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined(0)";
                break;
            }
            case 1: {
                result = "rBpsk12(1)";
                break;
            }
            case 2: {
                result = "rBpsk34(2)";
                break;
            }
            case 3: {
                result = "rQpsk12(3)";
                break;
            }
            case 4: {
                result = "rQpsk34(4)";
                break;
            }
            case 5: {
                result = "r16Qam12(5)";
                break;
            }
            case 6: {
                result = "r16Qam34(6)";
                break;
            }
            case 7: {
                result = "r64Qam23(7)";
                break;
            }
            case 8: {
                result = "r64Qam34(8)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbPMBurstCountersReset(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.5", type=65)
    public Long getRbPMBurstTotal() {
        return this.rbPMBurstTotal;
    }

    public void setRbPMBurstTotal(Long rbPMBurstTotal) {
        this.rbPMBurstTotal = rbPMBurstTotal;
    }

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.6", type=65)
    public Long getRbPMBurstError() {
        return this.rbPMBurstError;
    }

    public void setRbPMBurstError(Long rbPMBurstError) {
        this.rbPMBurstError = rbPMBurstError;
    }

    @Transient
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.6.1.1.7", type=-128)
    public String getRbPMBurstErrorRate() {
        return this.rbPMBurstErrorRate;
    }

    public void setRbPMBurstErrorRate(String rbPMBurstErrorRate) {
        this.rbPMBurstErrorRate = rbPMBurstErrorRate;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbPMBurstSuMacAddr=").append(this.rbPMBurstSuMacAddr).append(", ");
        result.append("rbPMBurstDirection=").append(RbPMBursErrorRateEntry.toStringRbPMBurstDirection(this.rbPMBurstDirection)).append(", ");
        result.append("rbPMBurstRate=").append(RbPMBursErrorRateEntry.toStringRbPMBurstRate(this.rbPMBurstRate)).append(", ");
        result.append("rbPMBurstTotal=").append(this.rbPMBurstTotal).append(", ");
        result.append("rbPMBurstError=").append(this.rbPMBurstError).append(", ");
        result.append("rbPMBurstErrorRate=").append(this.rbPMBurstErrorRate).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getRowKey() {
        return MacAddress.fromOctetString((String)this.getRbPMBurstSuMacAddr()).toInstanceString() + "." + this.getRbPMBurstDirection() + "." + this.getRbPMBurstRate();
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbPMBursErrorRateEntry.class, SNMP.class, (NetworkDomainObjectAccessHandler)new RbPMBurstErrorRateEntryNetworkDomainObjectAccessHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbPMBurstErrorRateEntryNetworkDomainObjectAccessHandler
    implements NetworkDomainObjectAccessHandler<RbPMBursErrorRateEntry> {
        private RbPMBurstErrorRateEntryNetworkDomainObjectAccessHandler() {
        }

        public List<RbPMBursErrorRateEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            RbSU su = (RbSU)eq;
            String instance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
            StringBuilder instances = new StringBuilder();
            for (int dir = 1; dir <= 2; ++dir) {
                for (int rate = 1; rate <= 8; ++rate) {
                    instances.append(instance + "." + dir + "." + rate + ",");
                }
            }
            instances.setLength(instances.length() - 1);
            return access.fetchObject(null, RbPMBursErrorRateEntry.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, RbPMBursErrorRateEntry.class), instances.toString());
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbPMBursErrorRateEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + RbPMBursErrorRateEntry.class.getName() + "]");
        }
    }
}

