/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PfConfig;
import com.bwanms.validation.WeakRange;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="RbBSPFGeneralParam")
public class RbPFGeneralParameters
extends ScalarMO {
    private static final long serialVersionUID = 2032593093374520297L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbBSPFRetryInterval;
    private Integer rbBSPFMaxNumOfRetries;
    private Integer rbBSPFKeepAliveTimeout;
    private Integer rbBSPFListenerPortNumber;
    private Integer rbBSPFSIPUdpPortNumber;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=1L, max=60L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.1.1", type=2)
    @ConfigAttribute
    public Integer getRbBSPFRetryInterval() {
        return this.rbBSPFRetryInterval;
    }

    public void setRbBSPFRetryInterval(Integer rbBSPFRetryInterval) {
        this.rbBSPFRetryInterval = rbBSPFRetryInterval;
    }

    @WeakRange(min=0L, max=5L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.1.2", type=2)
    @Column(name="rbBSPFMaxNumOfRetr")
    @ConfigAttribute
    public Integer getRbBSPFMaxNumOfRetries() {
        return this.rbBSPFMaxNumOfRetries;
    }

    public void setRbBSPFMaxNumOfRetries(Integer rbBSPFMaxNumOfRetries) {
        this.rbBSPFMaxNumOfRetries = rbBSPFMaxNumOfRetries;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.1.3", type=2)
    @WeakRange(min=60L, max=300L)
    @ConfigAttribute
    public Integer getRbBSPFKeepAliveTimeout() {
        return this.rbBSPFKeepAliveTimeout;
    }

    public void setRbBSPFKeepAliveTimeout(Integer rbBSPFKeepAliveTimeout) {
        this.rbBSPFKeepAliveTimeout = rbBSPFKeepAliveTimeout;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.1.4", type=2)
    @WeakRange(min=1L, max=65535L)
    @ConfigAttribute
    public Integer getRbBSPFListenerPortNumber() {
        return this.rbBSPFListenerPortNumber;
    }

    public void setRbBSPFListenerPortNumber(Integer rbBSPFListenerPortNumber) {
        this.rbBSPFListenerPortNumber = rbBSPFListenerPortNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.1.5", type=2)
    @WeakRange(min=1L, max=65535L)
    @ConfigAttribute
    public Integer getRbBSPFSIPUdpPortNumber() {
        return this.rbBSPFSIPUdpPortNumber;
    }

    public void setRbBSPFSIPUdpPortNumber(Integer rbBSPFSIPUdpPortNumber) {
        this.rbBSPFSIPUdpPortNumber = rbBSPFSIPUdpPortNumber;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbBSPFRetryInterval=").append(this.rbBSPFRetryInterval).append(", ");
        result.append("rbBSPFMaxNumOfRetries=").append(this.rbBSPFMaxNumOfRetries).append(", ");
        result.append("rbBSPFKeepAliveTimeout=").append(this.rbBSPFKeepAliveTimeout).append(", ");
        result.append("rbBSPFListenerPortNumber=").append(this.rbBSPFListenerPortNumber);
        result.append("rbBSPFSIPUdpPortNumber=").append(this.rbBSPFSIPUdpPortNumber);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPFGeneralParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPFGeneralParameters>(){

            public ManagedObjectAccessHandler<RbPFGeneralParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbPFGeneralParameters.class);
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPFGeneralParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPFGeneralParameters>(){

            public ManagedObjectAccessHandler<RbPFGeneralParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbPFGeneralParameters, PfConfig> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbPFGeneralParameters createEntry() {
            return new RbPFGeneralParameters();
        }

        @Override
        protected Class<PfConfig> getDataObjectClass() {
            return PfConfig.class;
        }

        @Override
        protected void populateEntry(RbPFGeneralParameters entry, PfConfig dataObject) {
            entry.setRbBSPFMaxNumOfRetries(dataObject.getMaxRetries());
            entry.setRbBSPFRetryInterval(dataObject.getRetransmitInterval());
            entry.setRbBSPFKeepAliveTimeout(dataObject.getKeepAliveTimeout());
        }
    }
}

