/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.OduDb_Odu;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.13.1.1", indexColumns={"RbOduConfigId"})
public class RbOduConfigEntry
extends DynamicTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbOduConfigId;
    private Integer rbOduAssociatedRadioClusterId;
    private String rbOduTxPower;
    private Integer rbOduAdminStatus;
    private Integer rbOduTemperature;
    private String rbOduHwRevision;
    private String rbOduHwConfigDescription;
    private Integer rbOduOperationalStatus;
    private String rbOduHwHC08Version;
    private String rbOduCpldVersion;
    private String rbOduCardSerialNumber;
    private Integer rbOduConfigFrequencyBand;
    private Integer rbOduRowStatus;
    private Integer rbOduMaxTxPower;
    private Integer rbOduActualTxPower;
    private String rbOduStatusMask;
    private String rbOduGeneralDescription;
    public static final int RbOduAdminStatusEnable = 1;
    public static final int RbOduAdminStatusDisable = 2;
    public static final int RbOduOperationalStatusInitFailure = 1;
    public static final int RbOduOperationalStatusDown = 2;
    public static final int RbOduOperationalStatusPowerOff = 3;
    public static final int RbOduOperationalStatusPowerOnWait = 4;
    public static final int RbOduOperationalStatusPowerOn = 5;
    public static final int RbOduOperationalStatusInitializing = 6;
    public static final int RbOduOperationalStatusUp = 7;
    public static final int RbOduOperationalStatusOperFailure = 8;
    public static final int RbOduRowStatusActive = 1;
    public static final int RbOduRowStatusNotInService = 2;
    public static final int RbOduRowStatusNotReady = 3;
    public static final int RbOduRowStatusCreateAndGo = 4;
    public static final int RbOduRowStatusCreateAndWait = 5;
    public static final int RbOduRowStatusDestroy = 6;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=1L, max=24L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbOduConfigId() {
        return this.rbOduConfigId;
    }

    public void setRbOduConfigId(Integer rbOduConfigId) {
        this.rbOduConfigId = rbOduConfigId;
    }

    @WeakRange(min=0L, max=6L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.2", type=2)
    @ConfigAttribute
    public Integer getRbOduAssociatedRadioClusterId() {
        return this.rbOduAssociatedRadioClusterId;
    }

    public void setRbOduAssociatedRadioClusterId(Integer rbOduAssociatedRadioClusterId) {
        this.rbOduAssociatedRadioClusterId = rbOduAssociatedRadioClusterId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.3", type=-128)
    @ConfigAttribute
    public String getRbOduTxPower() {
        return this.rbOduTxPower;
    }

    public void setRbOduTxPower(String rbOduTxPower) {
        this.rbOduTxPower = rbOduTxPower;
    }

    @WeakRange(min=1L, max=2L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.4", type=2)
    @ConfigAttribute
    public Integer getRbOduAdminStatus() {
        return this.rbOduAdminStatus;
    }

    public void setRbOduAdminStatus(Integer rbOduAdminStatus) {
        this.rbOduAdminStatus = rbOduAdminStatus;
    }

    public static String toStringRbOduAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.5", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbOduTemperature() {
        return this.rbOduTemperature;
    }

    public void setRbOduTemperature(Integer rbOduTemperature) {
        this.rbOduTemperature = rbOduTemperature;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.6", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduHwRevision() {
        return this.rbOduHwRevision;
    }

    public void setRbOduHwRevision(String rbOduHwRevision) {
        this.rbOduHwRevision = rbOduHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.7", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduHwConfigDescription() {
        return this.rbOduHwConfigDescription;
    }

    public void setRbOduHwConfigDescription(String rbOduHwConfigDescription) {
        this.rbOduHwConfigDescription = rbOduHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.8", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbOduOperationalStatus() {
        return this.rbOduOperationalStatus;
    }

    public void setRbOduOperationalStatus(Integer rbOduOperationalStatus) {
        this.rbOduOperationalStatus = rbOduOperationalStatus;
    }

    public static String toStringRbOduOperationalStatus(Integer value) {
        Object result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "initFailure(1)";
            }
            case 2: {
                return "down(2)";
            }
            case 3: {
                return "powerOff(3)";
            }
            case 4: {
                return "powerOnWait(4)";
            }
            case 5: {
                return "powerOn(5)";
            }
            case 6: {
                return "initializing(6)";
            }
            case 7: {
                return "up(7)";
            }
            case 8: {
                return "operFailure(8)";
            }
        }
        return "!!undefined(" + value + ")";
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.9", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduHwHC08Version() {
        return this.rbOduHwHC08Version;
    }

    public void setRbOduHwHC08Version(String rbOduHwHC08Version) {
        this.rbOduHwHC08Version = rbOduHwHC08Version;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.10", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduCpldVersion() {
        return this.rbOduCpldVersion;
    }

    public void setRbOduCpldVersion(String rbOduCpldVersion) {
        this.rbOduCpldVersion = rbOduCpldVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.11", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduCardSerialNumber() {
        return this.rbOduCardSerialNumber;
    }

    public void setRbOduCardSerialNumber(String rbOduCardSerialNumber) {
        this.rbOduCardSerialNumber = rbOduCardSerialNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.12", type=2)
    @ConfigAttribute
    public Integer getRbOduConfigFrequencyBand() {
        return this.rbOduConfigFrequencyBand;
    }

    public void setRbOduConfigFrequencyBand(Integer rbOduConfigFrequencyBand) {
        this.rbOduConfigFrequencyBand = rbOduConfigFrequencyBand;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.13", type=2)
    public Integer getRowStatus() {
        return this.rbOduRowStatus;
    }

    public void setRowStatus(Integer rbOduRowStatus) {
        this.rbOduRowStatus = rbOduRowStatus;
    }

    public static String toStringRbOduRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.4"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.14", type=2, readOnly=true)
    @InventoryAttribute
    public Integer getRbOduMaxTxPower() {
        return this.rbOduMaxTxPower;
    }

    public void setRbOduMaxTxPower(Integer rbOduMaxTxPower) {
        this.rbOduMaxTxPower = rbOduMaxTxPower;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1.1.7"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.15", type=2, readOnly=true)
    @InventoryAttribute
    public Integer getRbOduActualTxPower() {
        return this.rbOduActualTxPower;
    }

    public void setRbOduActualTxPower(Integer rbOduActualTxPower) {
        this.rbOduActualTxPower = rbOduActualTxPower;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.16", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduStatusMask() {
        return this.rbOduStatusMask;
    }

    public void setRbOduStatusMask(String rbOduStatusMask) {
        this.rbOduStatusMask = rbOduStatusMask;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.5"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.13.1.1.17", type=-128, readOnly=true)
    @InventoryAttribute
    public String getRbOduGeneralDescription() {
        return this.rbOduGeneralDescription;
    }

    public void setRbOduGeneralDescription(String rbOduGeneralDescription) {
        this.rbOduGeneralDescription = rbOduGeneralDescription;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbOduConfigId=").append(this.rbOduConfigId).append(", ");
        result.append("rbOduAssociatedRadioClusterId=").append(this.rbOduAssociatedRadioClusterId).append(", ");
        result.append("rbOduTxPower=").append(this.rbOduTxPower).append(", ");
        result.append("rbOduAdminStatus=").append(RbOduConfigEntry.toStringRbOduAdminStatus(this.rbOduAdminStatus)).append(", ");
        result.append("rbOduTemperature=").append(this.rbOduTemperature).append(", ");
        result.append("rbOduHwRevision=").append(this.rbOduHwRevision).append(", ");
        result.append("rbOduHwConfigDescription=").append(this.rbOduHwConfigDescription).append(", ");
        result.append("rbOduOperationalStatus=").append(RbOduConfigEntry.toStringRbOduOperationalStatus(this.rbOduOperationalStatus)).append(", ");
        result.append("rbOduHwHC08Version=").append(this.rbOduHwHC08Version).append(", ");
        result.append("rbOduCpldVersion=").append(this.rbOduCpldVersion).append(", ");
        result.append("rbOduCardSerialNumber=").append(this.rbOduCardSerialNumber).append(", ");
        result.append("rbOduConfigFrequencyBand=").append(this.rbOduConfigFrequencyBand).append(", ");
        result.append("rbOduRowStatus=").append(RbOduConfigEntry.toStringRbOduRowStatus(this.rbOduRowStatus)).append(", ");
        result.append("rbOduActualTxPower=").append(this.rbOduActualTxPower).append(", ");
        result.append("rbOduGeneralDescription=").append(this.toStringRbOduGeneralDescription(this.rbOduGeneralDescription));
        result.append("]");
        return result.toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Transient
    public String getRowKey() {
        return this.getRbOduConfigId().toString();
    }

    public String toStringRbOduGeneralDescription(String rbOduGeneralDescription) {
        if (null != rbOduGeneralDescription && !rbOduGeneralDescription.equals("")) {
            String[] values = rbOduGeneralDescription.split(" ");
            if (values.length > 5) {
                return values[4];
            }
            return values[0];
        }
        return rbOduGeneralDescription;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbOduConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbOduConfigEntry>(){

            public ManagedObjectAccessHandler<RbOduConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbOduConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbOduConfigEntry>(){

            public ManagedObjectAccessHandler<RbOduConfigEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbOduConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbOduConfigEntry, OduDb_Odu> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbOduConfigEntry createEntry() {
            return new RbOduConfigEntry();
        }

        @Override
        protected Class<OduDb_Odu> getDataObjectClass() {
            return OduDb_Odu.class;
        }

        @Override
        protected void populateEntry(RbOduConfigEntry entry, OduDb_Odu dataObject) {
            entry.setRbOduConfigId(dataObject.getID());
            entry.setRbOduAdminStatus(dataObject.getAdminStatus());
            entry.setRbOduAssociatedRadioClusterId(entry.getRbOduAssociatedRadioClusterId());
            entry.setRbOduConfigFrequencyBand(dataObject.getConfigFrequencyBand().intValue());
            entry.setRbOduTxPower(dataObject.getTxPower().toString());
        }
    }
}

