/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.MiCfg_Mi;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.2.1.1", indexColumns={"RbSlotNumber"})
public class RbNpuConfigEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = -4121556516613167103L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbSlotNumber;
    private String rbNpuSerialNo;
    private String rbNpuSysName;
    private Integer rbNpuFaultStatus;
    public static final int RbNpuFaultStatusNoFaults = 1;
    public static final int RbNpuFaultStatusMinor = 2;
    public static final int RbNpuFaultStatusMajor = 3;
    public static final int RbNpuFaultStatusCritical = 4;
    public static final int RbNpuFaultStatusDisconnected = 5;
    private String rbNpuHwRevision;
    private String rbNpuOperSwFileName;
    private String rbNpuOperSwVersion;
    private String rbNpuShadowSwFileName;
    private String rbNpuShadowSwVersion;
    private Integer rbNpuRunningSoftware;
    public static final int RbNpuRunningSoftwareOperational = 1;
    public static final int RbNpuRunningSoftwareShadow = 2;
    private Integer rbNpuRedundancyStatus;
    public static final int RbNpuRedundancyStatusActive = 1;
    public static final int RbNpuRedundancyStatusStandby = 2;
    private String rbNpuHwConfigDescription;
    private Integer rbNpuManagementInterface;
    public static final int RbNpuManagementInterfaceManagementPort = 1;
    public static final int RbNpuManagementInterfaceManagementAndDataPort = 2;
    private Integer rbNpuDrapTtlRetries;
    private String rbNpuBootSwVersion;
    private Integer rbNpuTemperature;
    private Long rbNpuCumulativePowerOnTime;
    private Integer rbNpuRedundantCPLDVersion;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.1", type=-128)
    @InventoryAttribute
    public String getRbNpuSerialNo() {
        return this.rbNpuSerialNo;
    }

    public void setRbNpuSerialNo(String rbNpuSerialNo) {
        this.rbNpuSerialNo = rbNpuSerialNo;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.2", type=-128)
    @StateAttribute
    public String getRbNpuSysName() {
        return this.rbNpuSysName;
    }

    public void setRbNpuSysName(String rbNpuSysName) {
        this.rbNpuSysName = rbNpuSysName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.3", type=2)
    @StateAttribute
    public Integer getRbNpuFaultStatus() {
        return this.rbNpuFaultStatus;
    }

    public void setRbNpuFaultStatus(Integer rbNpuFaultStatus) {
        this.rbNpuFaultStatus = rbNpuFaultStatus;
    }

    public static String toStringRbNpuFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noFaults(1)";
                break;
            }
            case 2: {
                result = "minor(2)";
                break;
            }
            case 3: {
                result = "major(3)";
                break;
            }
            case 4: {
                result = "critical(4)";
                break;
            }
            case 5: {
                result = "disconnected(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.4", type=-128)
    @InventoryAttribute
    public String getRbNpuHwRevision() {
        return this.rbNpuHwRevision;
    }

    public void setRbNpuHwRevision(String rbNpuHwRevision) {
        this.rbNpuHwRevision = rbNpuHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.5", type=-128)
    @StateAttribute
    public String getRbNpuOperSwFileName() {
        return this.rbNpuOperSwFileName;
    }

    public void setRbNpuOperSwFileName(String rbNpuOperSwFileName) {
        this.rbNpuOperSwFileName = rbNpuOperSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.6", type=-128)
    @StateAttribute
    public String getRbNpuOperSwVersion() {
        return this.rbNpuOperSwVersion;
    }

    public void setRbNpuOperSwVersion(String rbNpuOperSwVersion) {
        this.rbNpuOperSwVersion = rbNpuOperSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.7", type=-128)
    @StateAttribute
    public String getRbNpuShadowSwFileName() {
        return this.rbNpuShadowSwFileName;
    }

    public void setRbNpuShadowSwFileName(String rbNpuShadowSwFileName) {
        this.rbNpuShadowSwFileName = rbNpuShadowSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.8", type=-128)
    @StateAttribute
    public String getRbNpuShadowSwVersion() {
        return this.rbNpuShadowSwVersion;
    }

    public void setRbNpuShadowSwVersion(String rbNpuShadowSwVersion) {
        this.rbNpuShadowSwVersion = rbNpuShadowSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.9", type=2)
    @StateAttribute
    public Integer getRbNpuRunningSoftware() {
        return this.rbNpuRunningSoftware;
    }

    public void setRbNpuRunningSoftware(Integer rbNpuRunningSoftware) {
        this.rbNpuRunningSoftware = rbNpuRunningSoftware;
    }

    public static String toStringRbNpuRunningSoftware(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "operational(1)";
                break;
            }
            case 2: {
                result = "shadow(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.12", type=2)
    @StateAttribute
    public Integer getRbNpuRedundancyStatus() {
        return this.rbNpuRedundancyStatus;
    }

    public void setRbNpuRedundancyStatus(Integer rbNpuRedundancyStatus) {
        this.rbNpuRedundancyStatus = rbNpuRedundancyStatus;
    }

    public static String toStringRbNpuRedundancyStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "standby(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.15", type=-128)
    @StateAttribute
    public String getRbNpuHwConfigDescription() {
        return this.rbNpuHwConfigDescription;
    }

    public void setRbNpuHwConfigDescription(String rbNpuHwConfigDescription) {
        this.rbNpuHwConfigDescription = rbNpuHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.16", type=2)
    @InventoryAttribute
    public Integer getRbNpuManagementInterface() {
        return this.rbNpuManagementInterface;
    }

    public void setRbNpuManagementInterface(Integer rbNpuManagementInterface) {
        this.rbNpuManagementInterface = rbNpuManagementInterface;
    }

    public static String toStringRbNpuManagementInterface(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "managementPort(1)";
                break;
            }
            case 2: {
                result = "managementAndDataPort(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbNpuSerialNo=").append(this.rbNpuSerialNo).append(", ");
        result.append("rbNpuSysName=").append(this.rbNpuSysName).append(", ");
        result.append("rbNpuFaultStatus=").append(RbNpuConfigEntry.toStringRbNpuFaultStatus(this.rbNpuFaultStatus)).append(", ");
        result.append("rbNpuHwRevision=").append(this.rbNpuHwRevision).append(", ");
        result.append("rbNpuOperSwFileName=").append(this.rbNpuOperSwFileName).append(", ");
        result.append("rbNpuOperSwVersion=").append(this.rbNpuOperSwVersion).append(", ");
        result.append("rbNpuShadowSwFileName=").append(this.rbNpuShadowSwFileName).append(", ");
        result.append("rbNpuShadowSwVersion=").append(this.rbNpuShadowSwVersion).append(", ");
        result.append("rbNpuRunningSoftware=").append(RbNpuConfigEntry.toStringRbNpuRunningSoftware(this.rbNpuRunningSoftware)).append(", ");
        result.append("rbNpuRedundancyStatus=").append(RbNpuConfigEntry.toStringRbNpuRedundancyStatus(this.rbNpuRedundancyStatus)).append(", ");
        result.append("rbNpuHwConfigDescription=").append(this.rbNpuHwConfigDescription).append(", ");
        result.append("rbNpuDrapTtlRetries=").append(this.rbNpuDrapTtlRetries).append(", ");
        result.append("rbNpuTemperature=").append(this.rbNpuTemperature).append(", ");
        result.append("rbNpuBootSwVersion=").append(this.rbNpuBootSwVersion).append(", ");
        result.append("rbNpuManagementInterface=").append(RbNpuConfigEntry.toStringRbNpuManagementInterface(this.rbNpuManagementInterface)).append(", ");
        result.append("rbNpuCumulativePowerOnTime=").append(this.rbNpuCumulativePowerOnTime).append(", ");
        result.append("rbNpuBootSwVersion=").append(this.rbNpuBootSwVersion).append(", ");
        result.append("rbNpuTemperature=").append(this.rbNpuTemperature).append(", ");
        result.append("rbNpuDrapTtlRetries=").append(this.rbNpuDrapTtlRetries).append(", ");
        result.append("rbNpuRedundantCPLDVersion=").append(this.rbNpuRedundantCPLDVersion).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSlotNumber().toString();
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.2"})
    @WeakRange(min=1L, max=100L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.22", type=2)
    @ConfigAttribute
    public Integer getRbNpuDrapTtlRetries() {
        return this.rbNpuDrapTtlRetries;
    }

    public void setRbNpuDrapTtlRetries(Integer rbNpuDrapTtlRetries) {
        this.rbNpuDrapTtlRetries = rbNpuDrapTtlRetries;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.20", type=-128)
    @StateAttribute
    public String getRbNpuBootSwVersion() {
        return this.rbNpuBootSwVersion;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.21", type=2)
    @StateAttribute
    public Integer getRbNpuTemperature() {
        return this.rbNpuTemperature;
    }

    public void setRbNpuBootSwVersion(String rbNpuBootSwVersion) {
        this.rbNpuBootSwVersion = rbNpuBootSwVersion;
    }

    public void setRbNpuTemperature(Integer rbNpuTemperature) {
        this.rbNpuTemperature = rbNpuTemperature;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.19", type=66)
    @StateAttribute
    public Long getRbNpuCumulativePowerOnTime() {
        return this.rbNpuCumulativePowerOnTime;
    }

    public void setRbNpuCumulativePowerOnTime(Long rbNpuCumulativePowerOnTime) {
        this.rbNpuCumulativePowerOnTime = rbNpuCumulativePowerOnTime;
    }

    @Transient
    public String getRuningSwVersion() {
        if (this.rbNpuRunningSoftware == null) {
            return "unknown(3)";
        }
        switch (this.rbNpuRunningSoftware) {
            case 1: {
                return this.rbNpuOperSwVersion;
            }
            case 2: {
                return this.rbNpuShadowSwVersion;
            }
        }
        return "unknown(3)";
    }

    @Transient
    public boolean isConnected() {
        return this.rbNpuFaultStatus != null && this.rbNpuFaultStatus != 5;
    }

    @Transient
    public boolean isActive() {
        return this.rbNpuRedundancyStatus != null && this.rbNpuRedundancyStatus == 1;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.23", type=2)
    @StateAttribute
    public Integer getRbNpuRedundantCPLDVersion() {
        return this.rbNpuRedundantCPLDVersion;
    }

    public void setRbNpuRedundantCPLDVersion(Integer rbNpuRedundantCPLDVersion) {
        this.rbNpuRedundantCPLDVersion = rbNpuRedundantCPLDVersion;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbNpuConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbNpuConfigEntry>(){

            public ManagedObjectAccessHandler<RbNpuConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbNpuConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbNpuConfigEntry>(){

            public ManagedObjectAccessHandler<RbNpuConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbNpuConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    implements ManagedObjectAccessHandler<RbNpuConfigEntry> {
        static Version sw_V_2_1_1_2 = VersionFactory.getInstance().createVersion("2.1.1.2");

        private ConfigFileMOAccessHandler() {
        }

        public List<RbNpuConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            ArrayList<RbNpuConfigEntry> entries = new ArrayList<RbNpuConfigEntry>();
            MiCfg_Mi miCfg = (MiCfg_Mi)access.fetchObject(null, MiCfg_Mi.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, MiCfg_Mi.class)).get(0);
            RbNpuConfigEntry npuEntry = new RbNpuConfigEntry();
            npuEntry.setRbSlotNumber(5);
            npuEntry.setRbNpuSysName(miCfg.getName());
            Version swVersion = ((RbBaseStationEquipment)eq).getSoftwareVersion();
            if (swVersion.compareTo((Object)sw_V_2_1_1_2) >= 0) {
                SmCfg_Sm sm = (SmCfg_Sm)access.fetchObject(null, SmCfg_Sm.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SmCfg_Sm.class)).get(0);
                npuEntry.setRbNpuDrapTtlRetries(sm.getDrapRetries().intValue());
            }
            entries.add(npuEntry);
            return entries;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbNpuConfigEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot add [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbNpuConfigEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbNpuConfigEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot delete [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }
    }
}

