/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbNpuBridgingParameters
extends ScalarMO {
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbNpuBridgeAgingTime;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=0L, max=1440L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.2.1", type=2)
    @ConfigAttribute
    public Integer getRbNpuBridgeAgingTime() {
        return this.rbNpuBridgeAgingTime;
    }

    public void setRbNpuBridgeAgingTime(Integer rbNpuBridgeAgingTime) {
        this.rbNpuBridgeAgingTime = rbNpuBridgeAgingTime;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbNpuBridgeAgingTime=").append(this.rbNpuBridgeAgingTime).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbNpuBridgingParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbNpuBridgingParameters>(){

            public ManagedObjectAccessHandler<RbNpuBridgingParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbNpuBridgingParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbNpuBridgingParameters>(){

            public ManagedObjectAccessHandler<RbNpuBridgingParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbNpuBridgingParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbNpuBridgingParameters, SmCfg_Sm> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbNpuBridgingParameters createEntry() {
            return new RbNpuBridgingParameters();
        }

        @Override
        protected Class<SmCfg_Sm> getDataObjectClass() {
            return SmCfg_Sm.class;
        }

        @Override
        protected void populateEntry(RbNpuBridgingParameters entry, SmCfg_Sm dataObject) {
            Integer agingTime = dataObject.getBridgeAgeTime();
            entry.setRbNpuBridgeAgingTime(null != agingTime && 65535 != agingTime ? agingTime : 0);
        }
    }
}

