/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuChannelDb_AuChannel;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.4.1.20.1.1", indexColumns={"RbMBSTChannelId"})
public class RbMBSTChannelConfigEntry
extends StaticTableRowMO {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbMBSTChannelId;
    private Integer rbMBSTChannelAssociatedRadioClusterId;
    private Integer rbMBSTChannelAssociatedOduId;
    private String rbMBSTChannelTxFrequency;
    private String rbMBSTChannelRxFrequency;
    private Integer rbMBSTChannelAdminStatus;
    private String rbMBSTChannelConfiguredTxFrequency;
    private Integer rbMBSTChannelOduActualFrequencyBand;
    private Integer rbMBSTChannelOperStatus;
    public static final int RbMBSTChannelAdminStatusEnable = 1;
    public static final int RbMBSTChannelAdminStatusDisable = 2;
    public static final int RbMBSTChannelOperStatusUnknown = 0;
    public static final int RbMBSTChannelOperStatusUp = 1;
    public static final int RbMBSTChannelOperStatusDown = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbMBSTChannelId() {
        return this.rbMBSTChannelId;
    }

    public void setRbMBSTChannelId(Integer rbMBSTChannelId) {
        this.rbMBSTChannelId = rbMBSTChannelId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.2", type=2)
    @Column(name="RbMBSTChnRadioClusterId")
    @StateAttribute
    public Integer getRbMBSTChannelAssociatedRadioClusterId() {
        return this.rbMBSTChannelAssociatedRadioClusterId;
    }

    public void setRbMBSTChannelAssociatedRadioClusterId(Integer rbMBSTChannelAssociatedRadioClusterId) {
        this.rbMBSTChannelAssociatedRadioClusterId = rbMBSTChannelAssociatedRadioClusterId;
    }

    @Column(name="RbMBSTChnAssocODUId")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.3", type=2)
    @ConfigAttribute
    public Integer getRbMBSTChannelAssociatedOduId() {
        return this.rbMBSTChannelAssociatedOduId;
    }

    public void setRbMBSTChannelAssociatedOduId(Integer rbMBSTChannelAssociatedOduId) {
        this.rbMBSTChannelAssociatedOduId = rbMBSTChannelAssociatedOduId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.4", type=-128)
    @Column(name="RbMBSTChnTxFreq")
    @StateAttribute
    public String getRbMBSTChannelTxFrequency() {
        return this.rbMBSTChannelTxFrequency;
    }

    public void setRbMBSTChannelTxFrequency(String rbMBSTChannelTxFrequency) {
        this.rbMBSTChannelTxFrequency = rbMBSTChannelTxFrequency;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.5", type=-128)
    @Column(name="RbMBSTChnRxFreq")
    @StateAttribute
    public String getRbMBSTChannelRxFrequency() {
        return this.rbMBSTChannelRxFrequency;
    }

    public void setRbMBSTChannelRxFrequency(String rbMBSTChannelRxFrequency) {
        this.rbMBSTChannelRxFrequency = rbMBSTChannelRxFrequency;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.6", type=2)
    @Column(name="RbMBSTChnAdminStatus")
    @ConfigAttribute
    public Integer getRbMBSTChannelAdminStatus() {
        return this.rbMBSTChannelAdminStatus;
    }

    public void setRbMBSTChannelAdminStatus(Integer rbMBSTChannelAdminStatus) {
        this.rbMBSTChannelAdminStatus = rbMBSTChannelAdminStatus;
    }

    public static String toStringRbMBSTChannelAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.7", type=-128, readOnly=false)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Column(name="RbMBSTChnConfTxFreq")
    @ConfigAttribute
    public String getRbMBSTChannelConfiguredTxFrequency() {
        return this.rbMBSTChannelConfiguredTxFrequency;
    }

    public void setRbMBSTChannelConfiguredTxFrequency(String rbMBSTChannelConfiguredTxFrequency) {
        this.rbMBSTChannelConfiguredTxFrequency = rbMBSTChannelConfiguredTxFrequency;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.8", type=2)
    @Column(name="RbMBSTChnOduActFrqBand")
    @StateAttribute
    public Integer getRbMBSTChannelOduActualFrequencyBand() {
        return this.rbMBSTChannelOduActualFrequencyBand;
    }

    public void setRbMBSTChannelOduActualFrequencyBand(Integer rbMBSTChannelOduActualFrequencyBand) {
        this.rbMBSTChannelOduActualFrequencyBand = rbMBSTChannelOduActualFrequencyBand;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.20.1.1.9", type=2)
    @StateAttribute
    public Integer getRbMBSTChannelOperStatus() {
        return this.rbMBSTChannelOperStatus;
    }

    public void setRbMBSTChannelOperStatus(Integer rbMBSTChannelOperStatus) {
        this.rbMBSTChannelOperStatus = rbMBSTChannelOperStatus;
    }

    public static String toStringRbMBSTChannelOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbMBSTChannelId=").append(this.rbMBSTChannelId).append(", ");
        result.append("rbMBSTChannelAssociatedRadioClusterId=").append(this.rbMBSTChannelAssociatedRadioClusterId).append(", ");
        result.append("rbMBSTChannelAssociatedOduId=").append(this.rbMBSTChannelAssociatedOduId).append(", ");
        result.append("rbMBSTChannelTxFrequency=").append(this.rbMBSTChannelTxFrequency).append(", ");
        result.append("rbMBSTChannelRxFrequency=").append(this.rbMBSTChannelRxFrequency).append(", ");
        result.append("rbMBSTChannelAdminStatus=").append(RbMBSTChannelConfigEntry.toStringRbMBSTChannelAdminStatus(this.rbMBSTChannelAdminStatus)).append(", ");
        result.append("rbMBSTChannelConfiguredTxFrequency=").append(this.rbMBSTChannelConfiguredTxFrequency).append(", ");
        result.append("rbMBSTChannelOduActualFrequencyBand=").append(this.rbMBSTChannelOduActualFrequencyBand).append(", ");
        result.append("rbMBSTChannelOperStatus=").append(RbMBSTChannelConfigEntry.toStringRbMBSTChannelOperStatus(this.rbMBSTChannelOperStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.rbMBSTChannelId.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTChannelConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTChannelConfigEntry>(){

            public ManagedObjectAccessHandler<RbMBSTChannelConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTChannelConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTChannelConfigEntry>(){

            public ManagedObjectAccessHandler<RbMBSTChannelConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbMBSTChannelConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbMBSTChannelConfigEntry, AuChannelDb_AuChannel> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbMBSTChannelConfigEntry createEntry() {
            return new RbMBSTChannelConfigEntry();
        }

        @Override
        protected Class<AuChannelDb_AuChannel> getDataObjectClass() {
            return AuChannelDb_AuChannel.class;
        }

        @Override
        protected void populateEntry(RbMBSTChannelConfigEntry entry, AuChannelDb_AuChannel dataObject) {
            entry.setRbMBSTChannelId(dataObject.getID());
            entry.setRbMBSTChannelConfiguredTxFrequency(Double.toString((double)dataObject.getTxFrequency().longValue() / 1000.0));
            entry.setRbMBSTChannelAdminStatus(dataObject.getAdminStatus());
            entry.setRbMBSTChannelAssociatedOduId(dataObject.getAssociatedOdu());
        }
    }
}

