/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.validation.WeakRange;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbMBSTBridgingParameters
extends ScalarMO {
    private static final long serialVersionUID = 1416210978506553346L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbMBSTBridgeAgingTime;
    private Integer rbMBSTDrapTtlRetries;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=0L, max=1440L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.17.1", type=2)
    @ConfigAttribute
    public Integer getRbMBSTBridgeAgingTime() {
        return this.rbMBSTBridgeAgingTime;
    }

    public void setRbMBSTBridgeAgingTime(Integer rbMBSTBridgeAgingTime) {
        this.rbMBSTBridgeAgingTime = rbMBSTBridgeAgingTime;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.2"})
    @WeakRange(min=1L, max=100L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.25", type=2)
    @ConfigAttribute
    public Integer getRbMBSTDrapTtlRetries() {
        return this.rbMBSTDrapTtlRetries;
    }

    public void setRbMBSTDrapTtlRetries(Integer rbMBSTDrapTtlRetries) {
        this.rbMBSTDrapTtlRetries = rbMBSTDrapTtlRetries;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbMBSTBridgeAgingTime=").append(this.rbMBSTBridgeAgingTime).append(", ");
        result.append("rbMBSTDrapTtlRetries=").append(this.rbMBSTDrapTtlRetries);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTBridgingParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTBridgingParameters>(){

            public ManagedObjectAccessHandler<RbMBSTBridgingParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTBridgingParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTBridgingParameters>(){

            public ManagedObjectAccessHandler<RbMBSTBridgingParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbMBSTBridgingParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbMBSTBridgingParameters, SmCfg_Sm> {
        static Version sw_V_2_1_1_2 = VersionFactory.getInstance().createVersion("2.1.1.2");
        Version swVersion = null;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbMBSTBridgingParameters createEntry() {
            return new RbMBSTBridgingParameters();
        }

        @Override
        protected Class<SmCfg_Sm> getDataObjectClass() {
            return SmCfg_Sm.class;
        }

        @Override
        protected void populateEntry(RbMBSTBridgingParameters entry, SmCfg_Sm dataObject) {
            entry.setRbMBSTBridgeAgingTime(dataObject.getBridgeAgeTime());
            if (this.swVersion.compareTo((Object)sw_V_2_1_1_2) >= 0) {
                entry.setRbMBSTDrapTtlRetries(dataObject.getDrapRetries().intValue());
            }
        }

        @Override
        public List<RbMBSTBridgingParameters> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.swVersion = ((RbBaseStationEquipment)eq).getSoftwareVersion();
            return super.fetch(eq, access, networkResource, instanceQuery);
        }
    }
}

