/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuDb_Au;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="RbMBSTAddCfgParams")
public class RbMBSTAdditionalConfigParameters
extends ScalarMO {
    private static final long serialVersionUID = 6245131014168495985L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbMBSTMaxNumberOfCalls;
    private Integer rbMBSTActiveVoiceCalls;
    private Integer rbMBSTDiversityMode;
    public static final int RbMBSTDiversityModeNoDiversity = 1;
    public static final int RbMBSTDiversityModeSecondOrder = 2;
    public static final int RbMBSTDiversityModeFourthOrder = 3;
    public static final int RbMBSTDiversityModeSecondOrderRX = 5;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @WeakRange(min=0L, max=50L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.19.2", type=2)
    @ConfigAttribute
    public Integer getRbMBSTMaxNumberOfCalls() {
        return this.rbMBSTMaxNumberOfCalls;
    }

    public void setRbMBSTMaxNumberOfCalls(Integer rbMBSTMaxNumberOfCalls) {
        this.rbMBSTMaxNumberOfCalls = rbMBSTMaxNumberOfCalls;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.19.4", type=2)
    @StateAttribute
    public Integer getRbMBSTActiveVoiceCalls() {
        return this.rbMBSTActiveVoiceCalls;
    }

    public void setRbMBSTActiveVoiceCalls(Integer rbMBSTActiveVoiceCalls) {
        this.rbMBSTActiveVoiceCalls = rbMBSTActiveVoiceCalls;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.19.6", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=3.0"})
    @ConfigAttribute
    public Integer getRbMBSTDiversityMode() {
        return this.rbMBSTDiversityMode;
    }

    public void setRbMBSTDiversityMode(Integer rbMBSTDiversityMode) {
        this.rbMBSTDiversityMode = rbMBSTDiversityMode;
    }

    public static String toStringRbMBSTDiversityMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noDiversity(1)";
                break;
            }
            case 2: {
                result = "secondOrder(2)";
                break;
            }
            case 3: {
                result = "fourthOrder(3)";
                break;
            }
            case 5: {
                result = "secondOrder-RX(5)";
                break;
            }
            default: {
                result = "undefinedValue";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbMBSTMaxNumberOfCalls=").append(this.rbMBSTMaxNumberOfCalls).append(", ");
        result.append("rbMBSTActiveVoiceCalls=").append(this.rbMBSTActiveVoiceCalls).append(", ");
        result.append("rbMBSTDiversityMode=").append(this.rbMBSTDiversityMode);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTAdditionalConfigParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTAdditionalConfigParameters>(){

            public ManagedObjectAccessHandler<RbMBSTAdditionalConfigParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMBSTAdditionalConfigParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMBSTAdditionalConfigParameters>(){

            public ManagedObjectAccessHandler<RbMBSTAdditionalConfigParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbMBSTAdditionalConfigParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbMBSTAdditionalConfigParameters, AuDb_Au> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbMBSTAdditionalConfigParameters createEntry() {
            return new RbMBSTAdditionalConfigParameters();
        }

        @Override
        protected Class<AuDb_Au> getDataObjectClass() {
            return AuDb_Au.class;
        }

        @Override
        protected void populateEntry(RbMBSTAdditionalConfigParameters entry, AuDb_Au dataObject) {
            entry.setRbMBSTMaxNumberOfCalls(dataObject.getMaxCalls());
        }
    }
}

