/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.5.1.1", indexColumns={"RbSuMacAddr", "RbMacBehindSuAddr"})
public class RbMACBehindSUListEntry
extends StaticTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private String rbSuMacAddr;
    private String rbMacBehindSuAddr;
    private Integer rbMacBehindSuVlan;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.5.1.1.1", type=112)
    @StateAttribute
    public String getRbMacBehindSuAddr() {
        return this.rbMacBehindSuAddr;
    }

    public void setRbMacBehindSuAddr(String rbMacBehindSuAddr) {
        this.rbMacBehindSuAddr = rbMacBehindSuAddr;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.5.1.1.2", type=2)
    public Integer getRbMacBehindSuVlan() {
        return this.rbMacBehindSuVlan;
    }

    public void setRbMacBehindSuVlan(Integer rbMacBehindSuVlan) {
        this.rbMacBehindSuVlan = rbMacBehindSuVlan;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbMacBehindSuAddr=").append(this.rbMacBehindSuAddr).append(", ");
        result.append("rbMacBehindSuVlan=").append(this.rbMacBehindSuVlan).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Transient
    public String getRowKey() {
        return this.getRbMacBehindSuAddr();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMACBehindSUListEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMACBehindSUListEntry>(){

            public ManagedObjectAccessHandler<RbMACBehindSUListEntry> createHandler() {
                return new RbMACBehindSUListEntryMOAccessHandler(RbMACBehindSUListEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbMACBehindSUListEntryMOAccessHandler
    extends DefaultManagedObjectAccessHandler<RbMACBehindSUListEntry> {
        public RbMACBehindSUListEntryMOAccessHandler(Class<RbMACBehindSUListEntry> moClass) {
            super(moClass);
        }

        public List<RbMACBehindSUListEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            RbSU su = (RbSU)eq;
            String instance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
            return super.fetch(eq, access, networkResource, instance + "*");
        }
    }
}

