/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.DeniedMacAddressDb_DeniedMacAddress;
import com.bwanms.util.MacAddress;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Pattern;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.8.6.2.1", indexColumns={"RbMACAddressDenyMacAddress"})
public class RbMACAddressDenyListEntry
extends DynamicTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private String rbMACAddressDenyMacAddress;
    private Integer rbMACAddressDenyListRowStatus;
    public static final int RbMACAddressDenyListRowStatusActive = 1;
    public static final int RbMACAddressDenyListRowStatusNotInService = 2;
    public static final int RbMACAddressDenyListRowStatusNotReady = 3;
    public static final int RbMACAddressDenyListRowStatusCreateAndGo = 4;
    public static final int RbMACAddressDenyListRowStatusCreateAndWait = 5;
    public static final int RbMACAddressDenyListRowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Pattern(regex="^(\\p{XDigit}{2}:){5}(\\p{XDigit}{2})$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.6.2.1.1", type=112, readOnly=true)
    @IdentifierAttribute
    public String getRbMACAddressDenyMacAddress() {
        return this.rbMACAddressDenyMacAddress;
    }

    public void setRbMACAddressDenyMacAddress(String rbMACAddressDenyMacAddress) {
        this.rbMACAddressDenyMacAddress = rbMACAddressDenyMacAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.6.2.1.2", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbMACAddressDenyListRowStatus;
    }

    public void setRowStatus(Integer rbMACAddressDenyListRowStatus) {
        this.rbMACAddressDenyListRowStatus = rbMACAddressDenyListRowStatus;
    }

    public String toStringRbMACAddressDenyListRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbMACAddressDenyMacAddress=").append(this.rbMACAddressDenyMacAddress).append(", ");
        result.append("rbMACAddressDenyListRowStatus=").append(this.toStringRbMACAddressDenyListRowStatus(this.rbMACAddressDenyListRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return MacAddress.fromOctetString((String)this.getRbMACAddressDenyMacAddress()).toInstanceString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMACAddressDenyListEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMACAddressDenyListEntry>(){

            public ManagedObjectAccessHandler<RbMACAddressDenyListEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbMACAddressDenyListEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbMACAddressDenyListEntry>(){

            public ManagedObjectAccessHandler<RbMACAddressDenyListEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbMACAddressDenyListEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbMACAddressDenyListEntry, DeniedMacAddressDb_DeniedMacAddress> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbMACAddressDenyListEntry createEntry() {
            return new RbMACAddressDenyListEntry();
        }

        @Override
        protected Class<DeniedMacAddressDb_DeniedMacAddress> getDataObjectClass() {
            return DeniedMacAddressDb_DeniedMacAddress.class;
        }

        @Override
        protected void populateEntry(RbMACAddressDenyListEntry entry, DeniedMacAddressDb_DeniedMacAddress dataObject) {
            entry.setRbMACAddressDenyMacAddress(dataObject.getMACAddress().toUpperCase());
        }
    }
}

