/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DataObjectTableRow;
import com.bwanms.mo.DefaultNetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.protocols.snmp.SNMP;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.50.1.1", indexColumns={"RbLicenseId", "RbLicenseValue"})
public class RbLicenseBankEntry
implements DataObjectTableRow {
    private static final long serialVersionUID = -1654042169981149321L;
    private String instance;
    private Integer rbLicenseId;
    private Long rbLicenseValue;
    private Long rbLicenseCount;
    private String rbLicenseDescription;
    private Long rbLicenseTotal;
    public static final int RbLicenseIdBandwidth = 1;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.50.1.1.1", type=2)
    public Integer getRbLicenseId() {
        return this.rbLicenseId;
    }

    public void setRbLicenseId(Integer rbLicenseId) {
        this.rbLicenseId = rbLicenseId;
    }

    public static String toStringRbLicenseId(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "bandwidth(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.50.1.1.2", type=66)
    public Long getRbLicenseValue() {
        return this.rbLicenseValue;
    }

    public void setRbLicenseValue(Long rbLicenseValue) {
        this.rbLicenseValue = rbLicenseValue;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.50.1.1.3", type=66)
    public Long getRbLicenseCount() {
        return this.rbLicenseCount;
    }

    public void setRbLicenseCount(Long rbLicenseCount) {
        this.rbLicenseCount = rbLicenseCount;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.50.1.1.4", type=-128)
    public String getRbLicenseDescription() {
        return this.rbLicenseDescription;
    }

    public void setRbLicenseDescription(String rbLicenseDescription) {
        this.rbLicenseDescription = rbLicenseDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.50.1.1.5", type=66)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1"})
    public Long getRbLicenseTotal() {
        return this.rbLicenseTotal;
    }

    public void setRbLicenseTotal(Long rbLicenseTotal) {
        this.rbLicenseTotal = rbLicenseTotal;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbLicenseId=").append(RbLicenseBankEntry.toStringRbLicenseId(this.rbLicenseId)).append(", ");
        result.append("rbLicenseValue=").append(this.rbLicenseValue).append(", ");
        result.append("rbLicenseCount=").append(this.rbLicenseCount).append(", ");
        result.append("rbLicenseDescription=").append(this.rbLicenseDescription).append(", ");
        result.append("rbLicenseTotal=").append(this.rbLicenseTotal);
        result.append("]");
        return result.toString();
    }

    public String getRowKey() {
        return this.rbLicenseId + "." + this.rbLicenseValue;
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbLicenseBankEntry.class, SNMP.class, (NetworkDomainObjectAccessHandler)new DefaultNetworkDomainObjectAccessHandler(RbLicenseBankEntry.class));
    }
}

