/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.RbFilterEntry;
import com.bwanms.rb.mo.RbFilterGeneralConfig;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.FltrFiltersDb_FltrFilters;
import com.bwanms.rb.mo.configfile.FltrL3RulesDb_FltrL3Rules;
import com.bwanms.util.BeanUtils;
import com.bwanms.validation.WeakNotNull;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1", indexColumns={"RbL34FilteringRuleIdx"})
public class RbL3L4FilteringRuleEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = -520983047593321296L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Long rbL34FilteringRuleIdx;
    private Integer rbL34FilteringRuleRowStatus;
    private String rbL34FilteringRuleName;
    private String rbL34FilteringRuleSrcIpAddress;
    private String rbL34FilteringRuleSrcMask;
    private String rbL34FilteringRuleDestIpAddress;
    private String rbL34FilteringRuleDestMask;
    private Integer rbL34FilteringRuleIpProtocol;
    private Integer rbL34FilteringRuleSrcUdpTcpPort;
    private Integer rbL34FilteringRuleDestUdpTcpPort;
    private Integer rbInterface;
    public static final int RbL34FilteringRuleRowStatusActive = 1;
    public static final int RbL34FilteringRuleRowStatusNotInService = 2;
    public static final int RbL34FilteringRuleRowStatusNotReady = 3;
    public static final int RbL34FilteringRuleRowStatusCreateAndGo = 4;
    public static final int RbL34FilteringRuleRowStatusCreateAndWait = 5;
    public static final int RbL34FilteringRuleRowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbL34FilteringRuleIdx() {
        return this.rbL34FilteringRuleIdx;
    }

    public void setRbL34FilteringRuleIdx(Long rbL34FilteringRuleIdx) {
        this.rbL34FilteringRuleIdx = rbL34FilteringRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.2", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbL34FilteringRuleRowStatus;
    }

    public void setRowStatus(Integer rbL34FilteringRuleRowStatus) {
        this.rbL34FilteringRuleRowStatus = rbL34FilteringRuleRowStatus;
    }

    public String toStringRbL34FilteringRuleRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakNotNull
    @Length(min=1, max=32)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.3", type=-128)
    @ConfigAttribute
    public String getRbL34FilteringRuleName() {
        return this.rbL34FilteringRuleName;
    }

    public void setRbL34FilteringRuleName(String rbL34FilteringRuleName) {
        this.rbL34FilteringRuleName = rbL34FilteringRuleName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.4", type=64)
    @Column(name="rbL34FiltRuleSrcIpAddress")
    @ConfigAttribute
    public String getRbL34FilteringRuleSrcIpAddress() {
        return this.rbL34FilteringRuleSrcIpAddress;
    }

    public void setRbL34FilteringRuleSrcIpAddress(String rbL34FilteringRuleSrcIpAddress) {
        this.rbL34FilteringRuleSrcIpAddress = rbL34FilteringRuleSrcIpAddress;
    }

    @Pattern(regex="^255\\.255\\.255\\.(255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(254|252|248|240|224|192|128|0)\\.0$|^255\\.(254|252|248|240|224|192|128|0)\\.0\\.0$|^(254|252|248|240|224|192|128|0)\\.0\\.0\\.0$", message="Wrong IP Mask")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.5", type=64)
    @ConfigAttribute
    public String getRbL34FilteringRuleSrcMask() {
        return this.rbL34FilteringRuleSrcMask;
    }

    public void setRbL34FilteringRuleSrcMask(String rbL34FilteringRuleSrcMask) {
        this.rbL34FilteringRuleSrcMask = rbL34FilteringRuleSrcMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.6", type=64)
    @Column(name="rbL34FiltRuleDestIpAddress")
    @ConfigAttribute
    public String getRbL34FilteringRuleDestIpAddress() {
        return this.rbL34FilteringRuleDestIpAddress;
    }

    public void setRbL34FilteringRuleDestIpAddress(String rbL34FilteringRuleDestIpAddress) {
        this.rbL34FilteringRuleDestIpAddress = rbL34FilteringRuleDestIpAddress;
    }

    @Pattern(regex="^255\\.255\\.255\\.(255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(254|252|248|240|224|192|128|0)\\.0$|^255\\.(254|252|248|240|224|192|128|0)\\.0\\.0$|^(254|252|248|240|224|192|128|0)\\.0\\.0\\.0$", message="Wrong IP Mask")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.7", type=64)
    @ConfigAttribute
    public String getRbL34FilteringRuleDestMask() {
        return this.rbL34FilteringRuleDestMask;
    }

    public void setRbL34FilteringRuleDestMask(String rbL34FilteringRuleDestMask) {
        this.rbL34FilteringRuleDestMask = rbL34FilteringRuleDestMask;
    }

    @WeakRange(min=0L, max=255L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.8", type=2)
    @ConfigAttribute
    public Integer getRbL34FilteringRuleIpProtocol() {
        return this.rbL34FilteringRuleIpProtocol;
    }

    public void setRbL34FilteringRuleIpProtocol(Integer rbL34FilteringRuleIpProtocol) {
        this.rbL34FilteringRuleIpProtocol = rbL34FilteringRuleIpProtocol;
    }

    @WeakRange(min=0L, max=65535L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.9", type=2)
    @Column(name="rbL34FiltRuleSrcUdpTcpPort")
    @ConfigAttribute
    public Integer getRbL34FilteringRuleSrcUdpTcpPort() {
        return this.rbL34FilteringRuleSrcUdpTcpPort;
    }

    public void setRbL34FilteringRuleSrcUdpTcpPort(Integer rbL34FilteringRuleSrcUdpTcpPort) {
        this.rbL34FilteringRuleSrcUdpTcpPort = rbL34FilteringRuleSrcUdpTcpPort;
    }

    @WeakRange(min=0L, max=65535L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.2.1.1.10", type=2)
    @Column(name="rbL34FiltRuleDestUdpTcpPort")
    @ConfigAttribute
    public Integer getRbL34FilteringRuleDestUdpTcpPort() {
        return this.rbL34FilteringRuleDestUdpTcpPort;
    }

    public void setRbL34FilteringRuleDestUdpTcpPort(Integer rbL34FilteringRuleDestUdpTcpPort) {
        this.rbL34FilteringRuleDestUdpTcpPort = rbL34FilteringRuleDestUdpTcpPort;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbL34FilteringRuleIdx=").append(this.rbL34FilteringRuleIdx).append(", ");
        result.append("rbL34FilteringRuleRowStatus=").append(this.toStringRbL34FilteringRuleRowStatus(this.rbL34FilteringRuleRowStatus)).append(", ");
        result.append("rbL34FilteringRuleName=").append(this.rbL34FilteringRuleName).append(", ");
        result.append("rbL34FilteringRuleSrcIpAddress=").append(this.rbL34FilteringRuleSrcIpAddress).append(", ");
        result.append("rbL34FilteringRuleSrcMask=").append(this.rbL34FilteringRuleSrcMask).append(", ");
        result.append("rbL34FilteringRuleDestIpAddress=").append(this.rbL34FilteringRuleDestIpAddress).append(", ");
        result.append("rbL34FilteringRuleDestMask=").append(this.rbL34FilteringRuleDestMask).append(", ");
        result.append("rbL34FilteringRuleIpProtocol=").append(this.rbL34FilteringRuleIpProtocol).append(", ");
        result.append("rbL34FilteringRuleSrcUdpTcpPort=").append(this.rbL34FilteringRuleSrcUdpTcpPort).append(", ");
        result.append("rbL34FilteringRuleDestUdpTcpPort=").append(this.rbL34FilteringRuleDestUdpTcpPort).append(", ");
        result.append("]");
        return result.toString();
    }

    @ConfigAttribute
    public Integer getRbInterface() {
        return this.rbInterface;
    }

    public void setRbInterface(Integer rbInterface) {
        this.rbInterface = rbInterface;
    }

    @Transient
    public String getRowKey() {
        return this.getRbL34FilteringRuleIdx().toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbL3L4FilteringRuleEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbL3L4FilteringRuleEntry>(){

            public ManagedObjectAccessHandler<RbL3L4FilteringRuleEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbL3L4FilteringRuleEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbL3L4FilteringRuleEntry>(){

            public ManagedObjectAccessHandler<RbL3L4FilteringRuleEntry> createHandler() {
                return new RbL3L4FilteringRuleTableRowMOAccessHandler(RbL3L4FilteringRuleEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbL3L4FilteringRuleTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbL3L4FilteringRuleEntry> {
        public RbL3L4FilteringRuleTableRowMOAccessHandler(Class<RbL3L4FilteringRuleEntry> moClass) {
            super(moClass);
        }

        public List<RbL3L4FilteringRuleEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            List<RbFilterEntry> filters = this.prefetch(eq, access, networkResource);
            List l34FilteringRules = super.fetch(eq, access, networkResource, instanceQuery);
            for (RbL3L4FilteringRuleEntry l34Rule : l34FilteringRules) {
                int ifIdx = 0;
                for (RbFilterEntry filter : filters) {
                    if (!filter.getRbFilterRuleIndex().equals(l34Rule.getRbL34FilteringRuleIdx())) continue;
                    ifIdx |= filter.getRbInterfaceFilteringIdx().intValue();
                }
                l34Rule.setRbInterface(ifIdx);
            }
            return l34FilteringRules;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbL3L4FilteringRuleEntry managedObject) throws MediationException {
            if (managedObject.getRbL34FilteringRuleIdx() < 0L) {
                List data = access.fetchObject(null, RbFilterGeneralConfig.class, new String[]{"rbGetNewL34FilterRuleID"}, (String)null);
                long idx = (Long)BeanUtils.getPropertyValue(data.get(0), (String)"rbGetNewL34FilterRuleID");
                managedObject.setRbL34FilteringRuleIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
            for (int i = 1; i < 3; ++i) {
                if (((long)i & managedObject.getRbInterface().longValue()) <= 0L) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(2);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL34FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(4);
                access.commitObject(networkResource, (Object)valueObject, AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class));
            }
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbL3L4FilteringRuleEntry managedObject) throws MediationException {
            List<RbFilterEntry> filters = this.prefetch(eq, access, networkResource);
            int ruleIntf = managedObject.getRbInterface();
            for (RbFilterEntry filter : filters) {
                if (!filter.getRbFilterRuleIndex().equals(managedObject.getRbL34FilteringRuleIdx())) continue;
                int filterIntf = filter.getRbInterfaceFilteringIdx().intValue();
                if ((filterIntf & ruleIntf) == 0) {
                    filter.setRowStatus(6);
                    access.commitObject(networkResource, (Object)filter, new String[]{"rowStatus"});
                    continue;
                }
                ruleIntf &= ~filterIntf;
            }
            for (int i = 1; i < 3; ++i) {
                if ((i & ruleIntf) <= 0) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(2);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL34FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(4);
                access.commitObject(networkResource, (Object)valueObject, AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class));
            }
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbL3L4FilteringRuleEntry managedObject) throws MediationException {
            for (int i = 1; i < 3; ++i) {
                if (((long)i & managedObject.getRbInterface().longValue()) <= 0L) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(2);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL34FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(6);
                access.commitObject(networkResource, (Object)valueObject, new String[]{"rowStatus"});
            }
            super.delete(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }

        private List<RbFilterEntry> prefetch(Equipment eq, MOAccessSession access, String networkResource) throws MediationException {
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class);
            List filters = access.fetchObject(networkResource, RbFilterEntry.class, includedProperties, "*");
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                if (((RbFilterEntry)((Object)it.next())).getRbFilterRuleType() == 2) continue;
                it.remove();
            }
            return filters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbL3L4FilteringRuleEntry, FltrL3RulesDb_FltrL3Rules> {
        private List<FltrFiltersDb_FltrFilters> l34Filters = null;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbL3L4FilteringRuleEntry createEntry() {
            return new RbL3L4FilteringRuleEntry();
        }

        @Override
        protected Class<FltrL3RulesDb_FltrL3Rules> getDataObjectClass() {
            return FltrL3RulesDb_FltrL3Rules.class;
        }

        @Override
        protected void populateEntry(RbL3L4FilteringRuleEntry entry, FltrL3RulesDb_FltrL3Rules dataObject) {
            entry.setRbL34FilteringRuleIdx(dataObject.getINDEX());
            entry.setRbL34FilteringRuleName(dataObject.getName());
            entry.setRbL34FilteringRuleIpProtocol(dataObject.getProtocol());
            entry.setRbL34FilteringRuleSrcIpAddress(dataObject.getSrcIpAddr());
            entry.setRbL34FilteringRuleSrcMask(dataObject.getSrcIpAddrMask());
            entry.setRbL34FilteringRuleSrcUdpTcpPort(dataObject.getSrcPort());
            entry.setRbL34FilteringRuleDestIpAddress(dataObject.getDstIpAddr());
            entry.setRbL34FilteringRuleDestMask(dataObject.getDstIpAddrMask());
            entry.setRbL34FilteringRuleDestUdpTcpPort(dataObject.getDstPort());
            int ifIdx = 0;
            for (FltrFiltersDb_FltrFilters filter : this.l34Filters) {
                if (!entry.getRbL34FilteringRuleIdx().equals(filter.getFilteringRuleINDEX())) continue;
                ifIdx |= filter.getIfcId().intValue();
            }
            entry.setRbInterface(ifIdx);
        }

        @Override
        public List<RbL3L4FilteringRuleEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, FltrFiltersDb_FltrFilters.class);
            List filtersTable = access.fetchObject(null, FltrFiltersDb_FltrFilters.class, includedProperties, "*");
            if (this.l34Filters == null) {
                this.l34Filters = new ArrayList<FltrFiltersDb_FltrFilters>();
            }
            this.l34Filters.clear();
            for (FltrFiltersDb_FltrFilters filter : filtersTable) {
                if (filter.getFilteringRuleType() != 2) continue;
                this.l34Filters.add(filter);
            }
        }
    }
}

