/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.RbFilterEntry;
import com.bwanms.rb.mo.RbFilterGeneralConfig;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.FltrFiltersDb_FltrFilters;
import com.bwanms.rb.mo.configfile.FltrL2RulesDb_FltrL2Rules;
import com.bwanms.util.BeanUtils;
import com.bwanms.validation.WeakNotNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1", indexColumns={"RbL2FilteringRuleIdx"})
public class RbL2FilteringRuleEntry
extends DynamicTableRowMO {
    private static final long serialVersionUID = 473275298260957367L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Long rbL2FilteringRuleIdx;
    private Integer rbL2FilteringRuleRowStatus;
    private String rbL2FilteringRuleName;
    private String rbL2FilteringRuleSrcMacAddress;
    private String rbL2FilteringRuleSrcMask;
    private String rbL2FilteringRuleDestMacAddress;
    private String rbL2FilteringRuleDestMask;
    private Integer rbL2FilteringRuleEthType;
    private Integer rbInterface;
    public static final int RbL2FilteringRuleRowStatusActive = 1;
    public static final int RbL2FilteringRuleRowStatusNotInService = 2;
    public static final int RbL2FilteringRuleRowStatusNotReady = 3;
    public static final int RbL2FilteringRuleRowStatusCreateAndGo = 4;
    public static final int RbL2FilteringRuleRowStatusCreateAndWait = 5;
    public static final int RbL2FilteringRuleRowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @ConfigAttribute
    public Integer getRbInterface() {
        return this.rbInterface;
    }

    public void setRbInterface(Integer rbInterface) {
        this.rbInterface = rbInterface;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbL2FilteringRuleIdx() {
        return this.rbL2FilteringRuleIdx;
    }

    public void setRbL2FilteringRuleIdx(Long rbL2FilteringRuleIdx) {
        this.rbL2FilteringRuleIdx = rbL2FilteringRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.2", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbL2FilteringRuleRowStatus;
    }

    public void setRowStatus(Integer rbL2FilteringRuleRowStatus) {
        this.rbL2FilteringRuleRowStatus = rbL2FilteringRuleRowStatus;
    }

    public String toStringRbL2FilteringRuleRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakNotNull
    @Length(min=1, max=32)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.3", type=-128)
    @ConfigAttribute
    public String getRbL2FilteringRuleName() {
        return this.rbL2FilteringRuleName;
    }

    public void setRbL2FilteringRuleName(String rbL2FilteringRuleName) {
        this.rbL2FilteringRuleName = rbL2FilteringRuleName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.4", type=112)
    @Column(name="rbL2FiltRuleSrcMacAddress")
    @ConfigAttribute
    public String getRbL2FilteringRuleSrcMacAddress() {
        return this.rbL2FilteringRuleSrcMacAddress;
    }

    public void setRbL2FilteringRuleSrcMacAddress(String rbL2FilteringRuleSrcMacAddress) {
        this.rbL2FilteringRuleSrcMacAddress = rbL2FilteringRuleSrcMacAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.5", type=112)
    @ConfigAttribute
    public String getRbL2FilteringRuleSrcMask() {
        return this.rbL2FilteringRuleSrcMask;
    }

    public void setRbL2FilteringRuleSrcMask(String rbL2FilteringRuleSrcMask) {
        this.rbL2FilteringRuleSrcMask = rbL2FilteringRuleSrcMask;
    }

    @Pattern(regex="^(\\p{XDigit}{2}:){5}(\\p{XDigit}{2})$", message="Wrong MAC Address. Must be of the form HH-HH-HH-HH-HH-HH, where H is a hexadecimal")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.6", type=112)
    @Column(name="rbL2FiltRuleDestMacAddress")
    @ConfigAttribute
    public String getRbL2FilteringRuleDestMacAddress() {
        return this.rbL2FilteringRuleDestMacAddress;
    }

    public void setRbL2FilteringRuleDestMacAddress(String rbL2FilteringRuleDestMacAddress) {
        this.rbL2FilteringRuleDestMacAddress = rbL2FilteringRuleDestMacAddress;
    }

    @Pattern(regex="(?i)^((ff:){5}(f[fec80]|[ec80]0)|(ff:){4}(f[ec80]|[ec80]0):00|(ff:){3}(f[ec80]|[ec80]0)(:00){2}|(ff:){2}(f[ec80]|[ec80]0)(:00){3}|ff:(f[ec80]|[ec80]0)(:00){4}|(f[fec80]|[ec8]0)(:00){5})$", message="Wrong MAC Mask. Must be of the form HH-HH-HH-HH-HH-HH, where H is a hexadecimal")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.7", type=112)
    @ConfigAttribute
    public String getRbL2FilteringRuleDestMask() {
        return this.rbL2FilteringRuleDestMask;
    }

    public void setRbL2FilteringRuleDestMask(String rbL2FilteringRuleDestMask) {
        this.rbL2FilteringRuleDestMask = rbL2FilteringRuleDestMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.1.1.1.8", type=2)
    @ConfigAttribute
    public Integer getRbL2FilteringRuleEthType() {
        return this.rbL2FilteringRuleEthType;
    }

    public void setRbL2FilteringRuleEthType(Integer rbL2FilteringRuleEthType) {
        this.rbL2FilteringRuleEthType = rbL2FilteringRuleEthType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbL2FilteringRuleIdx=").append(this.rbL2FilteringRuleIdx).append(", ");
        result.append("rbL2FilteringRuleRowStatus=").append(this.toStringRbL2FilteringRuleRowStatus(this.rbL2FilteringRuleRowStatus)).append(", ");
        result.append("rbL2FilteringRuleName=").append(this.rbL2FilteringRuleName).append(", ");
        result.append("rbL2FilteringRuleSrcMacAddress=").append(this.rbL2FilteringRuleSrcMacAddress).append(", ");
        result.append("rbL2FilteringRuleSrcMask=").append(this.rbL2FilteringRuleSrcMask).append(", ");
        result.append("rbL2FilteringRuleDestMacAddress=").append(this.rbL2FilteringRuleDestMacAddress).append(", ");
        result.append("rbL2FilteringRuleDestMask=").append(this.rbL2FilteringRuleDestMask).append(", ");
        result.append("rbL2FilteringRuleEthType=").append(this.rbL2FilteringRuleEthType).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbL2FilteringRuleIdx().toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbL2FilteringRuleEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbL2FilteringRuleEntry>(){

            public ManagedObjectAccessHandler<RbL2FilteringRuleEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbL2FilteringRuleEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbL2FilteringRuleEntry>(){

            public ManagedObjectAccessHandler<RbL2FilteringRuleEntry> createHandler() {
                return new RbL2FilteringRuleTableRowMOAccessHandler(RbL2FilteringRuleEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbL2FilteringRuleTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbL2FilteringRuleEntry> {
        public RbL2FilteringRuleTableRowMOAccessHandler(Class<RbL2FilteringRuleEntry> moClass) {
            super(moClass);
        }

        public List<RbL2FilteringRuleEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            List<RbFilterEntry> filters = this.prefetch(eq, access, networkResource);
            List l2FilteringRules = super.fetch(eq, access, networkResource, instanceQuery);
            for (RbL2FilteringRuleEntry l2Rule : l2FilteringRules) {
                int ifIdx = 0;
                for (RbFilterEntry filter : filters) {
                    if (!filter.getRbFilterRuleIndex().equals(l2Rule.getRbL2FilteringRuleIdx())) continue;
                    ifIdx |= filter.getRbInterfaceFilteringIdx().intValue();
                }
                l2Rule.setRbInterface(ifIdx);
            }
            return l2FilteringRules;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbL2FilteringRuleEntry managedObject) throws MediationException {
            if (managedObject.getRbL2FilteringRuleIdx() < 0L) {
                List data = access.fetchObject(null, RbFilterGeneralConfig.class, new String[]{"rbGetNewL2FilterRuleID"});
                long idx = (Long)BeanUtils.getPropertyValue(data.get(0), (String)"rbGetNewL2FilterRuleID");
                managedObject.setRbL2FilteringRuleIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
            for (int i = 1; i < 3; ++i) {
                if (((long)i & managedObject.getRbInterface().longValue()) <= 0L) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(1);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL2FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(4);
                access.commitObject(networkResource, (Object)valueObject, AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class));
            }
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbL2FilteringRuleEntry managedObject) throws MediationException {
            List<RbFilterEntry> filters = this.prefetch(eq, access, networkResource);
            int ruleIntf = managedObject.getRbInterface();
            for (RbFilterEntry filter : filters) {
                if (!filter.getRbFilterRuleIndex().equals(managedObject.getRbL2FilteringRuleIdx())) continue;
                int filterIntf = filter.getRbInterfaceFilteringIdx().intValue();
                if ((filterIntf & ruleIntf) == 0) {
                    filter.setRowStatus(6);
                    access.commitObject(networkResource, (Object)filter, new String[]{"rowStatus"});
                    continue;
                }
                ruleIntf &= ~filterIntf;
            }
            for (int i = 1; i < 3; ++i) {
                if ((i & ruleIntf) <= 0) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(1);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL2FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(4);
                access.commitObject(networkResource, (Object)valueObject, AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class));
            }
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbL2FilteringRuleEntry managedObject) throws MediationException {
            for (int i = 1; i < 3; ++i) {
                if (((long)i & managedObject.getRbInterface().longValue()) <= 0L) continue;
                RbFilterEntry valueObject = new RbFilterEntry();
                valueObject.setRbFilterRuleType(1);
                valueObject.setRbFilterRuleIndex(managedObject.getRbL2FilteringRuleIdx());
                valueObject.setRbInterfaceFilteringIdx(new Long(i));
                valueObject.setRowStatus(6);
                access.commitObject(networkResource, (Object)valueObject, new String[]{"rowStatus"});
            }
            super.delete(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }

        private List<RbFilterEntry> prefetch(Equipment eq, MOAccessSession access, String networkResource) throws MediationException {
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, RbFilterEntry.class);
            List filters = access.fetchObject(networkResource, RbFilterEntry.class, includedProperties, "*");
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                if (((RbFilterEntry)((Object)it.next())).getRbFilterRuleType() == 1) continue;
                it.remove();
            }
            return filters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbL2FilteringRuleEntry, FltrL2RulesDb_FltrL2Rules> {
        private List<FltrFiltersDb_FltrFilters> l2Filters = null;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbL2FilteringRuleEntry createEntry() {
            return new RbL2FilteringRuleEntry();
        }

        @Override
        protected Class<FltrL2RulesDb_FltrL2Rules> getDataObjectClass() {
            return FltrL2RulesDb_FltrL2Rules.class;
        }

        @Override
        protected void populateEntry(RbL2FilteringRuleEntry entry, FltrL2RulesDb_FltrL2Rules dataObject) {
            entry.setRbL2FilteringRuleIdx(dataObject.getINDEX());
            entry.setRbL2FilteringRuleName(dataObject.getName());
            entry.setRbL2FilteringRuleEthType(dataObject.getEthertype());
            entry.setRbL2FilteringRuleSrcMacAddress(dataObject.getSrcMACAddr());
            entry.setRbL2FilteringRuleSrcMask(dataObject.getSrcMACAddrMask());
            entry.setRbL2FilteringRuleDestMacAddress(dataObject.getDstMACAddr());
            entry.setRbL2FilteringRuleDestMask(dataObject.getDstMACAddrMask());
            int ifIdx = 0;
            for (FltrFiltersDb_FltrFilters filter : this.l2Filters) {
                if (!entry.getRbL2FilteringRuleIdx().equals(filter.getFilteringRuleINDEX())) continue;
                ifIdx |= filter.getIfcId().intValue();
            }
            entry.setRbInterface(ifIdx);
        }

        @Override
        public List<RbL2FilteringRuleEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, FltrFiltersDb_FltrFilters.class);
            List filtersTable = access.fetchObject(null, FltrFiltersDb_FltrFilters.class, includedProperties, "*");
            if (this.l2Filters == null) {
                this.l2Filters = new ArrayList<FltrFiltersDb_FltrFilters>();
            }
            this.l2Filters.clear();
            for (FltrFiltersDb_FltrFilters filter : filtersTable) {
                if (filter.getFilteringRuleType() != 1) continue;
                this.l2Filters.add(filter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RbInterface {
        None(0),
        FromWireless(1),
        FromNetwork(2),
        FromBoth(3),
        Undefined;

        private final int value;
        private int undefinedValue;

        private RbInterface(int value) {
            this.undefinedValue = -1;
            this.value = value;
        }

        private RbInterface() {
            this.value = this.undefinedValue = -1;
        }

        public int value() {
            return this.value;
        }

        public int undefinedValue() {
            return this.undefinedValue;
        }

        public String text(Internationalizer i18n) {
            return i18n.translateString(this.name());
        }

        public static RbInterface getInterface(int value) {
            for (RbInterface i : RbInterface.values()) {
                if (i.value != value) continue;
                return i;
            }
            RbInterface.Undefined.undefinedValue = value;
            return Undefined;
        }
    }
}

