/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.gui.configuration.DataPortConfigForm;
import com.bwanms.rb.mo.configfile.MiCfg_Mi;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.IPv4Mask;
import com.bwanms.validation.IPv4Validator;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EmbeddableSuperclass
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.9.1.1", indexColumns={"IpIfConfigIfIndex"})
public class RbIpIfConfigEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = 959066185493831140L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer ipIfConfigIfIndex;
    private Integer ipIfConfigVlanId;
    private String ipIfConfigIpAddress;
    private String ipIfConfigNetworkMask;
    private String ipIfConfigDefaultGateway;
    private String ipIfStaticRouteSubnet;
    private String ipIfStaticRouteSubnetMask;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.1", type=2, readOnly=true)
    @IdentifierAttribute
    public Integer getIpIfConfigIfIndex() {
        return this.ipIfConfigIfIndex;
    }

    public void setIpIfConfigIfIndex(Integer ipIfConfigIfIndex) {
        this.ipIfConfigIfIndex = ipIfConfigIfIndex;
    }

    @WeakRange(min=0L, max=4095L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.2", type=2)
    @ConfigAttribute
    public Integer getIpIfConfigVlanId() {
        return this.ipIfConfigVlanId;
    }

    public void setIpIfConfigVlanId(Integer ipIfConfigVlanId) {
        this.ipIfConfigVlanId = ipIfConfigVlanId;
    }

    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.3", type=64)
    @ConfigAttribute
    public String getIpIfConfigIpAddress() {
        return this.ipIfConfigIpAddress;
    }

    public void setIpIfConfigIpAddress(String ipIfConfigIpAddress) {
        this.ipIfConfigIpAddress = ipIfConfigIpAddress;
    }

    @IPv4Mask
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.4", type=64)
    @ConfigAttribute
    public String getIpIfConfigNetworkMask() {
        return this.ipIfConfigNetworkMask;
    }

    public void setIpIfConfigNetworkMask(String ipIfConfigNetworkMask) {
        this.ipIfConfigNetworkMask = ipIfConfigNetworkMask;
    }

    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.5", type=64)
    @ConfigAttribute
    public String getIpIfConfigDefaultGateway() {
        return this.ipIfConfigDefaultGateway;
    }

    public void setIpIfConfigDefaultGateway(String ipIfConfigDefaultGateway) {
        this.ipIfConfigDefaultGateway = ipIfConfigDefaultGateway;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.6", type=64)
    @ConfigAttribute
    public String getIpIfStaticRouteSubnet() {
        return this.ipIfStaticRouteSubnet;
    }

    public void setIpIfStaticRouteSubnet(String ipIfStaticRouteSubnet) {
        this.ipIfStaticRouteSubnet = ipIfStaticRouteSubnet;
    }

    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.9.1.1.7", type=64)
    @ConfigAttribute
    public String getIpIfStaticRouteSubnetMask() {
        return this.ipIfStaticRouteSubnetMask;
    }

    public void setIpIfStaticRouteSubnetMask(String ipIfStaticRouteSubnetMask) {
        this.ipIfStaticRouteSubnetMask = ipIfStaticRouteSubnetMask;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("ipIfConfigIfIndex=").append(this.ipIfConfigIfIndex).append(", ");
        result.append("ipIfConfigVlanId=").append(this.ipIfConfigVlanId).append(", ");
        result.append("ipIfConfigIpAddress=").append(this.ipIfConfigIpAddress).append(", ");
        result.append("ipIfConfigNetworkMask=").append(this.ipIfConfigNetworkMask).append(", ");
        result.append("ipIfConfigDefaultGateway=").append(this.ipIfConfigDefaultGateway).append(", ");
        result.append("ipIfStaticRouteSubnet=").append(this.ipIfStaticRouteSubnet).append(", ");
        result.append("ipIfStaticRouteSubnetMask=").append(this.ipIfStaticRouteSubnetMask).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        int firstByte;
        Internationalizer i18n = Internationalizer.getInternationalizer(DataPortConfigForm.class);
        if (this.ipIfConfigIpAddress != null) {
            if (this.ipIfConfigIpAddress.startsWith("0.")) {
                invalidValues.add(new InvalidValue(i18n.translateString("IpAddressCantStartWith0"), RbIpIfConfigEntry.class, "ipIfConfigIpAddress", (Object)this.getIpIfConfigIpAddress(), (Object)this));
            } else if (IPv4Validator.isValidBroadcastIp((String)this.ipIfConfigIpAddress, (String)this.ipIfConfigNetworkMask)) {
                invalidValues.add(new InvalidValue(i18n.translateString("IpAddressCantBeBroadcast"), RbIpIfConfigEntry.class, "ipIfConfigIpAddress", (Object)this.getIpIfConfigIpAddress(), (Object)this));
            } else {
                try {
                    firstByte = Integer.parseInt(this.ipIfConfigIpAddress.substring(0, this.ipIfConfigIpAddress.indexOf(46)));
                    if (firstByte >= 224 && firstByte <= 239) {
                        invalidValues.add(new InvalidValue(i18n.translateString("FirstByteCantBeInInterval224_239"), RbIpIfConfigEntry.class, "ipIfConfigIpAddress", (Object)this.getIpIfConfigIpAddress(), (Object)this));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.ipIfConfigDefaultGateway != null) {
            if (this.ipIfConfigDefaultGateway.startsWith("0.")) {
                invalidValues.add(new InvalidValue(i18n.translateString("DefaultGatewayCantStartWith0"), RbIpIfConfigEntry.class, "ipIfConfigDefaultGateway", (Object)this.ipIfConfigDefaultGateway, (Object)this));
            } else {
                try {
                    firstByte = Integer.parseInt(this.ipIfConfigDefaultGateway.substring(0, this.ipIfConfigDefaultGateway.indexOf(46)));
                    if (firstByte >= 224 && firstByte <= 239) {
                        invalidValues.add(new InvalidValue(i18n.translateString("FirstByteCantBeInInterval224_239"), RbIpIfConfigEntry.class, "ipIfConfigDefaultGateway", (Object)this.ipIfConfigDefaultGateway, (Object)this));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.ipIfStaticRouteSubnet != null && this.ipIfConfigIfIndex == 2) {
            if (!IPv4Validator.isValidIp((String)this.ipIfStaticRouteSubnet)) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpAddress"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnet", (Object)this.ipIfStaticRouteSubnet, (Object)this));
            } else if (this.ipIfStaticRouteSubnet.equals("0.0.0.0")) {
                invalidValues.add(new InvalidValue(i18n.translateString("IpAddressCantStartWith0"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnet", (Object)this.ipIfStaticRouteSubnet, (Object)this));
            } else {
                try {
                    int firstByte2 = Integer.parseInt(this.ipIfStaticRouteSubnet.substring(0, this.ipIfStaticRouteSubnet.indexOf(46)));
                    if (firstByte2 >= 224 && firstByte2 <= 239) {
                        invalidValues.add(new InvalidValue(i18n.translateString("FirstByteCantBeInInterval224_239"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnet", (Object)this.ipIfStaticRouteSubnet, (Object)this));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (IPv4Validator.isValidIp((String)this.ipIfStaticRouteSubnetMask)) {
                if (!IPv4Validator.isValidHostMask((String)this.ipIfStaticRouteSubnetMask)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnetMask"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnetMask", (Object)this.ipIfStaticRouteSubnetMask, (Object)this));
                }
            } else if (IPv4Validator.isValidBroadcastIp((String)this.ipIfStaticRouteSubnet, (String)this.ipIfStaticRouteSubnetMask)) {
                invalidValues.add(new InvalidValue(i18n.translateString("IpAddressCantBeBroadcast"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnet", (Object)this.ipIfStaticRouteSubnet, (Object)this));
            } else {
                try {
                    int firstByte3 = Integer.parseInt(this.ipIfStaticRouteSubnet.substring(0, this.ipIfStaticRouteSubnet.indexOf(46)));
                    if (firstByte3 >= 224 && firstByte3 <= 239) {
                        invalidValues.add(new InvalidValue(i18n.translateString("FirstByteCantBeInInterval224_239"), RbIpIfConfigEntry.class, "ipIfStaticRouteSubnet", (Object)this.ipIfStaticRouteSubnet, (Object)this));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Transient
    public String getRowKey() {
        return this.getIpIfConfigIfIndex().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbIpIfConfigEntry>
    implements ManagedObjectAccessHandler<E> {
        protected ConfigFileMOAccessHandler() {
        }

        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            ArrayList<E> entries = new ArrayList<E>();
            SmCfg_Sm smCfg = (SmCfg_Sm)access.fetchObject(null, SmCfg_Sm.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SmCfg_Sm.class)).get(0);
            MiCfg_Mi miCfg = (MiCfg_Mi)access.fetchObject(null, MiCfg_Mi.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, MiCfg_Mi.class)).get(0);
            E dataPort = this.createEntry();
            ((RbIpIfConfigEntry)((Object)dataPort)).setIpIfConfigIfIndex(1);
            ((RbIpIfConfigEntry)((Object)dataPort)).setIpIfConfigIpAddress(smCfg.getIfDataIpAddr());
            ((RbIpIfConfigEntry)((Object)dataPort)).setIpIfConfigNetworkMask(smCfg.getIfDataSnMask());
            ((RbIpIfConfigEntry)((Object)dataPort)).setIpIfConfigDefaultGateway(smCfg.getIfDataGwIpAddr());
            ((RbIpIfConfigEntry)((Object)dataPort)).setIpIfConfigVlanId(smCfg.getManagementVLAN());
            entries.add(dataPort);
            E mgmtPort = this.createEntry();
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfConfigIfIndex(2);
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfConfigIpAddress(miCfg.getIfDataIpAddr());
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfConfigNetworkMask(miCfg.getIfDataSnMask());
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfConfigDefaultGateway(miCfg.getIfDataGwIpAddr());
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfStaticRouteSubnet(miCfg.getIfMngmMSn());
            ((RbIpIfConfigEntry)((Object)mgmtPort)).setIpIfStaticRouteSubnetMask(miCfg.getIfMngmMSnMask());
            entries.add(mgmtPort);
            return entries;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot add [" + managedObject.getClass().getName() + "]");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + managedObject.getClass().getName() + "]");
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot delete [" + managedObject.getClass().getName() + "]");
        }

        protected abstract E createEntry();
    }
}

