/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.FltrInterfacesDb_FltrInterfaces;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1", indexColumns={"RbInterfaceFilteringType", "RbInterfaceFilteringIdx"})
public class RbInterfaceFilteringEntry
extends StaticTableRowMO {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbInterfaceFilteringType;
    private Long rbInterfaceFilteringIdx;
    private String rbInterfaceFilteringName;
    private Integer rbInterfaceFilteringAdminStatus;
    private Integer rbInterfaceFilteringActiveFilterType;
    private Integer rbInterfaceFilteringAction;
    public static final int RbInterfaceFilteringTypeFromWireless = 1;
    public static final int RbInterfaceFilteringTypeFromNetwork = 2;
    public static final int RbInterfaceFilteringAdminStatusEnable = 1;
    public static final int RbInterfaceFilteringAdminStatusDisable = 2;
    public static final int RbInterfaceFilteringActiveFilterTypeFilterL2 = 1;
    public static final int RbInterfaceFilteringActiveFilterTypeFilterL34 = 2;
    public static final int RbInterfaceFilteringActionDeny = 1;
    public static final int RbInterfaceFilteringActionAllow = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.1", type=2)
    @StateAttribute
    public Integer getRbInterfaceFilteringType() {
        return this.rbInterfaceFilteringType;
    }

    public void setRbInterfaceFilteringType(Integer rbInterfaceFilteringType) {
        this.rbInterfaceFilteringType = rbInterfaceFilteringType;
    }

    public static String toStringRbInterfaceFilteringType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "fromWireless(1)";
                break;
            }
            case 2: {
                result = "fromNetwork(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.2", type=66)
    @IdentifierAttribute
    public Long getRbInterfaceFilteringIdx() {
        return this.rbInterfaceFilteringIdx;
    }

    public void setRbInterfaceFilteringIdx(Long rbInterfaceFilteringIdx) {
        this.rbInterfaceFilteringIdx = rbInterfaceFilteringIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.3", type=4)
    @StateAttribute
    public String getRbInterfaceFilteringName() {
        return this.rbInterfaceFilteringName;
    }

    public void setRbInterfaceFilteringName(String rbInterfaceFilteringName) {
        this.rbInterfaceFilteringName = rbInterfaceFilteringName;
    }

    @Column(name="rbIfFilteringAdminStatus")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.4", type=2)
    @ConfigAttribute
    public Integer getRbInterfaceFilteringAdminStatus() {
        return this.rbInterfaceFilteringAdminStatus;
    }

    public void setRbInterfaceFilteringAdminStatus(Integer rbInterfaceFilteringAdminStatus) {
        this.rbInterfaceFilteringAdminStatus = rbInterfaceFilteringAdminStatus;
    }

    public static String toStringRbInterfaceFilteringAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Column(name="rbIfFilteringActiveFilterType")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.5", type=2)
    @ConfigAttribute
    public Integer getRbInterfaceFilteringActiveFilterType() {
        return this.rbInterfaceFilteringActiveFilterType;
    }

    public void setRbInterfaceFilteringActiveFilterType(Integer rbInterfaceFilteringActiveFilterType) {
        this.rbInterfaceFilteringActiveFilterType = rbInterfaceFilteringActiveFilterType;
    }

    public static String toStringRbInterfaceFilteringActiveFilterType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "filterL2(1)";
                break;
            }
            case 2: {
                result = "filterL34(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.6", type=2)
    @ConfigAttribute
    public Integer getRbInterfaceFilteringAction() {
        return this.rbInterfaceFilteringAction;
    }

    public void setRbInterfaceFilteringAction(Integer rbInterfaceFilteringAction) {
        this.rbInterfaceFilteringAction = rbInterfaceFilteringAction;
    }

    public static String toStringRbInterfaceFilteringAction(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "deny(1)";
                break;
            }
            case 2: {
                result = "allow(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbInterfaceFilteringType=").append(RbInterfaceFilteringEntry.toStringRbInterfaceFilteringType(this.rbInterfaceFilteringType)).append(", ");
        result.append("rbInterfaceFilteringIdx=").append(this.rbInterfaceFilteringIdx).append(", ");
        result.append("rbInterfaceFilteringName=").append(this.rbInterfaceFilteringName).append(", ");
        result.append("rbInterfaceFilteringAdminStatus=").append(RbInterfaceFilteringEntry.toStringRbInterfaceFilteringAdminStatus(this.rbInterfaceFilteringAdminStatus)).append(", ");
        result.append("rbInterfaceFilteringActiveFilterType=").append(RbInterfaceFilteringEntry.toStringRbInterfaceFilteringActiveFilterType(this.rbInterfaceFilteringActiveFilterType)).append(", ");
        result.append("rbInterfaceFilteringAction=").append(RbInterfaceFilteringEntry.toStringRbInterfaceFilteringAction(this.rbInterfaceFilteringAction)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbInterfaceFilteringType() + "." + this.getRbInterfaceFilteringIdx();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbInterfaceFilteringEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbInterfaceFilteringEntry>(){

            public ManagedObjectAccessHandler<RbInterfaceFilteringEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbInterfaceFilteringEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbInterfaceFilteringEntry>(){

            public ManagedObjectAccessHandler<RbInterfaceFilteringEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbInterfaceFilteringEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbInterfaceFilteringEntry, FltrInterfacesDb_FltrInterfaces> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbInterfaceFilteringEntry createEntry() {
            return new RbInterfaceFilteringEntry();
        }

        @Override
        protected Class<FltrInterfacesDb_FltrInterfaces> getDataObjectClass() {
            return FltrInterfacesDb_FltrInterfaces.class;
        }

        @Override
        protected void populateEntry(RbInterfaceFilteringEntry entry, FltrInterfacesDb_FltrInterfaces dataObject) {
            entry.setRbInterfaceFilteringAction(dataObject.getDfltFilteringRule());
            entry.setRbInterfaceFilteringType(dataObject.getFilteringType());
            entry.setRbInterfaceFilteringAdminStatus(dataObject.getAdminStatus());
            entry.setRbInterfaceFilteringIdx(dataObject.getINDEX());
            entry.setRbInterfaceFilteringName(dataObject.getName());
            entry.setRbInterfaceFilteringActiveFilterType(dataObject.getIfcType().intValue());
        }
    }
}

