/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.FltrFiltersDb_FltrFilters;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.8.4.1.1", indexColumns={"RbInterfaceFilteringIdx", "RbFilterRuleType", "RbFilterRuleIndex"})
public class RbFilterEntry
extends DynamicTableRowMO {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Long rbInterfaceFilteringIdx;
    private Integer rbFilterRuleType;
    private Long rbFilterRuleIndex;
    private Integer rbFilterRowStatus;
    public static final int RbFilterRuleTypeFilterL2 = 1;
    public static final int RbFilterRuleTypeFilterL34 = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusNotInService = 2;
    public static final int RowStatusNotReady = 3;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusCreateAndWait = 5;
    public static final int RowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.3.1.1.2", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbInterfaceFilteringIdx() {
        return this.rbInterfaceFilteringIdx;
    }

    public void setRbInterfaceFilteringIdx(Long rbInterfaceFilteringIdx) {
        this.rbInterfaceFilteringIdx = rbInterfaceFilteringIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.4.1.1.1", type=2)
    @ConfigAttribute
    public Integer getRbFilterRuleType() {
        return this.rbFilterRuleType;
    }

    public void setRbFilterRuleType(Integer rbFilterRuleType) {
        this.rbFilterRuleType = rbFilterRuleType;
    }

    public static String toStringRbFilterRuleType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "filterL2(1)";
                break;
            }
            case 2: {
                result = "filterL34(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.4.1.1.2", type=66)
    @ConfigAttribute
    public Long getRbFilterRuleIndex() {
        return this.rbFilterRuleIndex;
    }

    public void setRbFilterRuleIndex(Long rbFilterRuleIndex) {
        this.rbFilterRuleIndex = rbFilterRuleIndex;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.8.4.1.1.3", type=2)
    public Integer getRowStatus() {
        return this.rbFilterRowStatus;
    }

    public void setRowStatus(Integer rbFilterRowStatus) {
        this.rbFilterRowStatus = rbFilterRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbInterfaceFilteringIdx=").append(this.rbInterfaceFilteringIdx).append(", ");
        result.append("rbFilterRuleType=").append(RbFilterEntry.toStringRbFilterRuleType(this.rbFilterRuleType)).append(", ");
        result.append("rbFilterRuleIndex=").append(this.rbFilterRuleIndex).append(", ");
        result.append("rbFilterRowStatus=").append(RbFilterEntry.toStringRowStatus(this.rbFilterRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbInterfaceFilteringIdx() + "." + this.getRbFilterRuleType() + "." + this.getRbFilterRuleIndex();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbFilterEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbFilterEntry>(){

            public ManagedObjectAccessHandler<RbFilterEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbFilterEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbFilterEntry>(){

            public ManagedObjectAccessHandler<RbFilterEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbFilterEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbFilterEntry, FltrFiltersDb_FltrFilters> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbFilterEntry createEntry() {
            return new RbFilterEntry();
        }

        @Override
        protected Class<FltrFiltersDb_FltrFilters> getDataObjectClass() {
            return FltrFiltersDb_FltrFilters.class;
        }

        @Override
        protected void populateEntry(RbFilterEntry entry, FltrFiltersDb_FltrFilters dataObject) {
            entry.setRbInterfaceFilteringIdx(dataObject.getIfcId().longValue());
            entry.setRbFilterRuleType(dataObject.getFilteringRuleType());
            entry.setRbFilterRuleIndex(dataObject.getFilteringRuleINDEX());
        }
    }
}

