/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.mo.configfile.MiCfg_Mi;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.validation.Values;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@EmbeddableSuperclass
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.7.1.1.1", indexColumns={"EthConfigIfIndex"})
public class RbEthIfConfigEntry
extends StaticTableRowMO {
    public static final int EthConfigAutoNegotiationDisable = 2;
    public static final int EthConfigAutoNegotiationEnable = 1;
    public static final int EthConfigCurrentdAutoNegotiationDisable = 2;
    public static final int EthConfigCurrentdAutoNegotiationEnable = 1;
    public static final int EthConfigCurrentLinkSpeedAndDuplexFullDuplex100Mbps = 2;
    public static final int EthConfigCurrentLinkSpeedAndDuplexFullDuplex10Mbps = 4;
    public static final int EthConfigCurrentLinkSpeedAndDuplexFullDuplex1Gbps = 6;
    public static final int EthConfigCurrentLinkSpeedAndDuplexHalfDuplex100Mbps = 3;
    public static final int EthConfigCurrentLinkSpeedAndDuplexHalfDuplex10Mbps = 5;
    public static final int EthConfigCurrentLinkSpeedAndDuplexHalfDuplex1Gbps = 7;
    public static final int EthConfigCurrentLinkSpeedAndDuplexUnknown = 1;
    public static final int EthConfigLinkSpeedAndDuplexFullDuplex100Mbps = 2;
    public static final int EthConfigLinkSpeedAndDuplexFullDuplex10Mbps = 4;
    public static final int EthConfigLinkSpeedAndDuplexFullDuplex1Gbps = 6;
    public static final int EthConfigLinkSpeedAndDuplexHalfDuplex100Mbps = 3;
    public static final int EthConfigLinkSpeedAndDuplexHalfDuplex10Mbps = 5;
    public static final int EthConfigLinkSpeedAndDuplexHalfDuplex1Gbps = 7;
    public static final int EthConfigLinkSpeedAndDuplexUnknown = 1;
    private Integer ethConfigAutoNegotiation;
    private Integer ethConfigCurrentdAutoNegotiation;
    private Integer ethConfigCurrentLinkSpeedAndDuplex;
    private Integer ethConfigIfIndex;
    private Integer ethConfigLinkSpeedAndDuplex;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;

    @Values(values={1, 2}, toStringConvertorMethodName="toStringEthConfigAutoNegotiation")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.1.1.1.2", type=2)
    @ConfigAttribute
    public Integer getEthConfigAutoNegotiation() {
        return this.ethConfigAutoNegotiation;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.1.1.1.4", type=2, readOnly=true)
    @Column(name="ethCfgCurrAutoNegotiation")
    @StateAttribute
    public Integer getEthConfigCurrentdAutoNegotiation() {
        return this.ethConfigCurrentdAutoNegotiation;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.1.1.1.5", type=2, readOnly=true)
    @Column(name="ethCfgCurrLinkSpeedAndDuplex")
    @StateAttribute
    public Integer getEthConfigCurrentLinkSpeedAndDuplex() {
        return this.ethConfigCurrentLinkSpeedAndDuplex;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.1.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getEthConfigIfIndex() {
        return this.ethConfigIfIndex;
    }

    @WeakRange(min=1L, max=7L)
    @Values(values={2, 3, 4, 5}, toStringConvertorMethodName="toStringEthConfigLinkSpeedAndDuplex")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.1.1.1.3", type=2)
    @ConfigAttribute
    public Integer getEthConfigLinkSpeedAndDuplex() {
        return this.ethConfigLinkSpeedAndDuplex;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public String getInstance() {
        return this.instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setEthConfigAutoNegotiation(Integer ethConfigAutoNegotiation) {
        this.ethConfigAutoNegotiation = ethConfigAutoNegotiation;
    }

    public void setEthConfigCurrentdAutoNegotiation(Integer ethConfigCurrentdAutoNegotiation) {
        this.ethConfigCurrentdAutoNegotiation = ethConfigCurrentdAutoNegotiation;
    }

    public void setEthConfigCurrentLinkSpeedAndDuplex(Integer ethConfigCurrentLinkSpeedAndDuplex) {
        this.ethConfigCurrentLinkSpeedAndDuplex = ethConfigCurrentLinkSpeedAndDuplex;
    }

    public void setEthConfigIfIndex(Integer ethConfigIfIndex) {
        this.ethConfigIfIndex = ethConfigIfIndex;
    }

    public void setEthConfigLinkSpeedAndDuplex(Integer ethConfigLinkSpeedAndDuplex) {
        this.ethConfigLinkSpeedAndDuplex = ethConfigLinkSpeedAndDuplex;
    }

    public final void setId(long id) {
        this.id = id;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("ethConfigIfIndex=").append(this.ethConfigIfIndex).append(", ");
        result.append("ethConfigAutoNegotiation=").append(RbEthIfConfigEntry.toStringEthConfigAutoNegotiation(this.ethConfigAutoNegotiation)).append(", ");
        result.append("ethConfigLinkSpeedAndDuplex=").append(RbEthIfConfigEntry.toStringEthConfigLinkSpeedAndDuplex(this.ethConfigLinkSpeedAndDuplex)).append(", ");
        result.append("ethConfigCurrentdAutoNegotiation=").append(RbEthIfConfigEntry.toStringEthConfigCurrentdAutoNegotiation(this.ethConfigCurrentdAutoNegotiation)).append(", ");
        result.append("ethConfigCurrentLinkSpeedAndDuplex=").append(RbEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(this.ethConfigCurrentLinkSpeedAndDuplex)).append(", ");
        result.append("]");
        return result.toString();
    }

    public static String toStringEthConfigAutoNegotiation(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    public static String toStringEthConfigCurrentdAutoNegotiation(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    public static String toStringEthConfigCurrentLinkSpeedAndDuplex(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "unknown(1)";
                break;
            }
            case 2: {
                result = "fullDuplex100Mbps(2)";
                break;
            }
            case 3: {
                result = "halfDuplex100Mbps(3)";
                break;
            }
            case 4: {
                result = "fullDuplex10Mbps(4)";
                break;
            }
            case 5: {
                result = "halfDuplex10Mbps(5)";
                break;
            }
            case 6: {
                result = "fullDuplex1Gbps(6)";
                break;
            }
            case 7: {
                result = "halfDuplex1Gbps(7)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    public static String toStringEthConfigLinkSpeedAndDuplex(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "unknown(1)";
                break;
            }
            case 2: {
                result = "fullDuplex100Mbps(2)";
                break;
            }
            case 3: {
                result = "halfDuplex100Mbps(3)";
                break;
            }
            case 4: {
                result = "fullDuplex10Mbps(4)";
                break;
            }
            case 5: {
                result = "halfDuplex10Mbps(5)";
                break;
            }
            case 6: {
                result = "fullDuplex1Gbps(6)";
                break;
            }
            case 7: {
                result = "halfDuplex1Gbps(7)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @Transient
    public String getRowKey() {
        return this.getEthConfigIfIndex().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbEthIfConfigEntry>
    implements ManagedObjectAccessHandler<E> {
        protected ConfigFileMOAccessHandler() {
        }

        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            ArrayList<E> entries = new ArrayList<E>();
            SmCfg_Sm smCfg = (SmCfg_Sm)access.fetchObject(null, SmCfg_Sm.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SmCfg_Sm.class)).get(0);
            MiCfg_Mi miCfg = (MiCfg_Mi)access.fetchObject(null, MiCfg_Mi.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, MiCfg_Mi.class)).get(0);
            E dataPort = this.createEntry();
            ((RbEthIfConfigEntry)((Object)dataPort)).setEthConfigIfIndex(1);
            ((RbEthIfConfigEntry)((Object)dataPort)).setEthConfigAutoNegotiation(2);
            ((RbEthIfConfigEntry)((Object)dataPort)).setEthConfigLinkSpeedAndDuplex(smCfg.getIfDataSpeed());
            entries.add(dataPort);
            E mgmtPort = this.createEntry();
            ((RbEthIfConfigEntry)((Object)mgmtPort)).setEthConfigIfIndex(2);
            ((RbEthIfConfigEntry)((Object)mgmtPort)).setEthConfigCurrentLinkSpeedAndDuplex(1);
            ((RbEthIfConfigEntry)((Object)mgmtPort)).setEthConfigAutoNegotiation(1);
            entries.add(mgmtPort);
            return entries;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot add [" + managedObject.getClass().getName() + "]");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + managedObject.getClass().getName() + "]");
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot delete [" + managedObject.getClass().getName() + "]");
        }

        protected abstract E createEntry();
    }
}

