/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.MigpsCfg_Migps;
import com.bwanms.rb.mo.configfile.SmgpsCfg_Smgps;
import com.bwanms.validation.Values;
import com.bwanms.validation.WeakRange;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.validator.Pattern;

@Entity
public class RbChainConfig
extends ScalarMO {
    private static final long serialVersionUID = 5874168227998789683L;
    public static final String PROP_ID = "id";
    public static final String PROP_NR_CONFIGURATION = "nrConfiguration";
    public static final String PROP_RBGPS_SUPPORTED = "rbGPSSupported";
    public static final String PROP_RB_CONFIGURED_CHAIN_NUMBER = "rbConfiguredChainNumber";
    public static final String PROP_RB_CURRENT_CHAIN_NUMBER = "rbCurrentChainNumber";
    public static final String PROP_RBGPS_CONFIGURED_TYPE = "rbGPSConfiguredType";
    public static final String PROP_RBGPS_CURRENT_TYPE = "rbGPSCurrentType";
    public static final String PROP_RB_TIME_ZONE_OFFSET_FROMUTC = "rbTimeZoneOffsetFromUTC";
    public static final String PROP_RB_STOP_TX_AFTER_HOLD_OVER_TIMEOUT = "rbStopTxAfterHoldOverTimeout";
    public static final String PROP_RB_HOLD_OVER_PASSED_TIMEOUT = "rbHoldOverPassedTimeout";
    public static final String PROP_RB_DAYLIGHT_SAVING_STATUS = "rbDaylightSavingStatus";
    public static final String PROP_RB_DAYLIGHT_SAVING_DATE_START = "rbDaylightSavingDateStart";
    public static final String PROP_RB_DAYLIGHT_SAVING_DATE_STOP = "rbDaylightSavingDateStop";
    public static final String PROP_RB_DAYLIGHT_SAVING_ADV_FACTOR = "rbDaylightSavingAdvFactor";
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbGPSSupported;
    private Long rbConfiguredChainNumber;
    private Long rbCurrentChainNumber;
    private Integer rbGPSConfiguredType;
    private Integer rbGPSCurrentType;
    private String rbTimeZoneOffsetFromUTC;
    private Integer rbStopTxAfterHoldOverTimeout;
    private Long rbHoldOverPassedTimeout;
    private Integer rbDaylightSavingStatus;
    private String rbDaylightSavingDateStart;
    private String rbDaylightSavingDateStop;
    private String rbDaylightSavingAdvFactor;
    public static final int RbGPSSupportedSupported = 1;
    public static final int RbGPSSupportedNotSupported = 2;
    public static final int RbGPSConfiguredTypeNone = 0;
    public static final int RbGPSConfiguredTypeTrimble = 1;
    public static final int RbGPSConfiguredTypeSymetricom = 2;
    public static final int RbGPSCurrentTypeNone = 0;
    public static final int RbGPSCurrentTypeTrimble = 1;
    public static final int RbGPSCurrentTypeSymetricom = 2;
    public static final int RbStopTxAfterHoldOverTimeoutEnable = 1;
    public static final int RbStopTxAfterHoldOverTimeoutDisable = 2;
    public static final int RbDaylightSavingStatusEnable = 1;
    public static final int RbDaylightSavingStatusDisable = 2;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.1", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    public Integer getRbGPSSupported() {
        return this.rbGPSSupported;
    }

    public void setRbGPSSupported(Integer rbGPSSupported) {
        this.rbGPSSupported = rbGPSSupported;
    }

    public static String toStringRbGPSSupported(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "supported(1)";
                break;
            }
            case 2: {
                result = "notSupported(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.2", type=66)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @WeakRange(min=1L, max=1500L)
    public Long getRbConfiguredChainNumber() {
        return this.rbConfiguredChainNumber;
    }

    public void setRbConfiguredChainNumber(Long rbConfiguredChainNumber) {
        this.rbConfiguredChainNumber = rbConfiguredChainNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.3", type=66)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    public Long getRbCurrentChainNumber() {
        return this.rbCurrentChainNumber;
    }

    public void setRbCurrentChainNumber(Long rbCurrentChainNumber) {
        this.rbCurrentChainNumber = rbCurrentChainNumber;
    }

    @Values(values={0, 1, 2}, toStringConvertorMethodName="toStringRbGPSConfiguredType")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.4", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    public Integer getRbGPSConfiguredType() {
        return this.rbGPSConfiguredType;
    }

    public void setRbGPSConfiguredType(Integer rbGPSConfiguredType) {
        this.rbGPSConfiguredType = rbGPSConfiguredType;
    }

    public static String toStringRbGPSConfiguredType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "none(0)";
                break;
            }
            case 1: {
                result = "trimble(1)";
                break;
            }
            case 2: {
                result = "symetricom(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.5", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    public Integer getRbGPSCurrentType() {
        return this.rbGPSCurrentType;
    }

    public void setRbGPSCurrentType(Integer rbGPSCurrentType) {
        this.rbGPSCurrentType = rbGPSCurrentType;
    }

    public static String toStringRbGPSCurrentType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "none(0)";
                break;
            }
            case 1: {
                result = "trimble(1)";
                break;
            }
            case 2: {
                result = "symetricom(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.6", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @Pattern(regex="-((0?\\d?|1?[01]?):[03]0|12:00)|\\+((0?\\d?|1?[0-2]?):[03]0|13:00)", message="{wrong.utc.offset}")
    public String getRbTimeZoneOffsetFromUTC() {
        return this.rbTimeZoneOffsetFromUTC;
    }

    public void setRbTimeZoneOffsetFromUTC(String rbTimeZoneOffsetFromUTC) {
        this.rbTimeZoneOffsetFromUTC = rbTimeZoneOffsetFromUTC;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbStopTxAfterHoldOverTimeout")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.7", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    public Integer getRbStopTxAfterHoldOverTimeout() {
        return this.rbStopTxAfterHoldOverTimeout;
    }

    public void setRbStopTxAfterHoldOverTimeout(Integer rbStopTxAfterHoldOverTimeout) {
        this.rbStopTxAfterHoldOverTimeout = rbStopTxAfterHoldOverTimeout;
    }

    public static String toStringRbStopTxAfterHoldOverTimeout(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.8", type=66)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @WeakRange(min=0L, max=2880L)
    public Long getRbHoldOverPassedTimeout() {
        return this.rbHoldOverPassedTimeout;
    }

    public void setRbHoldOverPassedTimeout(Long rbHoldOverPassedTimeout) {
        this.rbHoldOverPassedTimeout = rbHoldOverPassedTimeout;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbDaylightSavingStatus")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.9", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @ConfigAttribute
    public Integer getRbDaylightSavingStatus() {
        return this.rbDaylightSavingStatus;
    }

    public void setRbDaylightSavingStatus(Integer rbDaylightSavingStatus) {
        this.rbDaylightSavingStatus = rbDaylightSavingStatus;
    }

    public static String toStringRbDaylightSavingStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.10", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @ConfigAttribute
    public String getRbDaylightSavingDateStart() {
        return this.rbDaylightSavingDateStart;
    }

    public void setRbDaylightSavingDateStart(String rbDaylightSavingDateStart) {
        this.rbDaylightSavingDateStart = rbDaylightSavingDateStart;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.11", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @ConfigAttribute
    public String getRbDaylightSavingDateStop() {
        return this.rbDaylightSavingDateStop;
    }

    public void setRbDaylightSavingDateStop(String rbDaylightSavingDateStop) {
        this.rbDaylightSavingDateStop = rbDaylightSavingDateStop;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.14.12", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @ConfigAttribute
    @Pattern(regex="\\+?0[0-4]:(00|15|30|45)", message="{wrong.daylight.adv.factor}")
    public String getRbDaylightSavingAdvFactor() {
        return this.rbDaylightSavingAdvFactor;
    }

    public void setRbDaylightSavingAdvFactor(String rbDaylightSavingAdvFactor) {
        this.rbDaylightSavingAdvFactor = rbDaylightSavingAdvFactor;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbGPSSupported=").append(RbChainConfig.toStringRbGPSSupported(this.rbGPSSupported)).append(", ");
        result.append("rbConfiguredChainNumber=").append(this.rbConfiguredChainNumber).append(", ");
        result.append("rbCurrentChainNumber=").append(this.rbCurrentChainNumber).append(", ");
        result.append("rbGPSConfiguredType=").append(RbChainConfig.toStringRbGPSConfiguredType(this.rbGPSConfiguredType)).append(", ");
        result.append("rbGPSCurrentType=").append(RbChainConfig.toStringRbGPSCurrentType(this.rbGPSCurrentType)).append(", ");
        result.append("rbTimeZoneOffsetFromUTC=").append(this.rbTimeZoneOffsetFromUTC).append(", ");
        result.append("rbStopTxAfterHoldOverTimeout=").append(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(this.rbStopTxAfterHoldOverTimeout)).append(", ");
        result.append("rbHoldOverPassedTimeout=").append(this.rbHoldOverPassedTimeout).append(", ");
        result.append("rbDaylightSavingStatus=").append(RbChainConfig.toStringRbDaylightSavingStatus(this.rbDaylightSavingStatus)).append(", ");
        if (this.rbDaylightSavingStatus == 1) {
            result.append("rbDaylightSavingDateStart=").append(this.rbDaylightSavingDateStart).append(", ");
            result.append("rbDaylightSavingDateStop=").append(this.rbDaylightSavingDateStop).append(", ");
            result.append("rbDaylightSavingAdvFactor=").append(this.rbDaylightSavingAdvFactor).append(", ");
        }
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbChainConfig.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbChainConfig>(){

            public ManagedObjectAccessHandler<RbChainConfig> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbChainConfig.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbChainConfig>(){

            public ManagedObjectAccessHandler<RbChainConfig> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbChainConfig.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbChainConfig, MigpsCfg_Migps> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbChainConfig createEntry() {
            return new RbChainConfig();
        }

        @Override
        protected Class<MigpsCfg_Migps> getDataObjectClass() {
            return MigpsCfg_Migps.class;
        }

        @Override
        public List<RbChainConfig> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            List<RbChainConfig> entries = super.fetch(eq, access, networkResource, instanceQuery);
            SmgpsCfg_Smgps smgpsCfg = (SmgpsCfg_Smgps)access.fetchObject(null, SmgpsCfg_Smgps.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SmgpsCfg_Smgps.class)).get(0);
            RbChainConfig entry = (RbChainConfig)((Object)entries.get(0));
            entry.setRbHoldOverPassedTimeout(smgpsCfg.getHoldOverPassedTimeout());
            return entries;
        }

        @Override
        protected void populateEntry(RbChainConfig entry, MigpsCfg_Migps dataObject) {
            entry.setRbConfiguredChainNumber(dataObject.getChainNumber());
            entry.setRbGPSConfiguredType(dataObject.getGpsType());
        }
    }
}

