/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.configfile.RbConfigFileParameter;
import com.bwanms.rb.configfile.RbConfigFileTableEntry;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.Smv2Cfg_Smv2;
import com.bwanms.validation.Values;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.validator.Pattern;

@Entity
@RbConfigFileTableEntry(resourceName="SMV2.cfg", tableName="SMV2")
public class RbBsRadioParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbBsATPCSupport;
    private Integer rbBsOptimalRSSI;
    private String rbBSConfiguredOperatorId;
    private String rbBSConfiguredCellId;
    private String rbLocalClockDateAndTime;
    public static final int RbBsATPCSupportEnabled = 1;
    public static final int RbBsATPCSupportDisabled = 2;
    public static final int RbBsATPCSupportNotDefined = 3;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbBsATPCSupport")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.1.1", type=2)
    @ConfigAttribute
    public Integer getRbBsATPCSupport() {
        return this.rbBsATPCSupport;
    }

    public void setRbBsATPCSupport(Integer rbBsATPCSupport) {
        this.rbBsATPCSupport = rbBsATPCSupport;
    }

    public static String toStringRbBsATPCSupport(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "NA(0)";
                break;
            }
            case 1: {
                result = "enabled(1)";
                break;
            }
            case 2: {
                result = "disabled(2)";
                break;
            }
            case 3: {
                result = "notDefined(3)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.1.2", type=2)
    @RbConfigFileParameter(name="AtpcOptimalRssi")
    @ConfigAttribute
    public Integer getRbBsOptimalRSSI() {
        return this.rbBsOptimalRSSI;
    }

    public void setRbBsOptimalRSSI(Integer rbBsOptimalRSSI) {
        this.rbBsOptimalRSSI = rbBsOptimalRSSI;
    }

    @Pattern(regex="^(\\p{XDigit}{2}:){2}\\p{XDigit}{2}$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.2.1", type=4)
    @ConfigAttribute
    public String getRbBSConfiguredOperatorId() {
        return this.rbBSConfiguredOperatorId;
    }

    public void setRbBSConfiguredOperatorId(String rbBSConfiguredOperatorId) {
        this.rbBSConfiguredOperatorId = rbBSConfiguredOperatorId;
    }

    @Pattern(regex="^\\p{XDigit}{2}:\\p{XDigit}{2}$")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.2.2", type=4)
    @ConfigAttribute
    public String getRbBSConfiguredCellId() {
        return this.rbBSConfiguredCellId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.3.1", type=-128)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.5-4.0.0]"})
    @ConfigAttribute
    public String getRbLocalClockDateAndTime() {
        return this.rbLocalClockDateAndTime;
    }

    public String setRbLocalClockDateAndTime(String rbLocalClockDateAndTime) {
        this.rbLocalClockDateAndTime = rbLocalClockDateAndTime;
        return this.rbLocalClockDateAndTime;
    }

    public void setRbBSConfiguredCellId(String rbBSConfiguredCellId) {
        this.rbBSConfiguredCellId = rbBSConfiguredCellId;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbBsATPCSupport=").append(RbBsRadioParameters.toStringRbBsATPCSupport(this.rbBsATPCSupport)).append(", ");
        result.append("rbBsOptimalRSSI=").append(this.rbBsOptimalRSSI).append(", ");
        result.append("rbBSConfiguredOperatorId=").append(this.rbBSConfiguredOperatorId).append(", ");
        result.append("rbBSConfiguredCellId=").append(this.rbBSConfiguredCellId).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBsRadioParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBsRadioParameters>(){

            public ManagedObjectAccessHandler<RbBsRadioParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBsRadioParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBsRadioParameters>(){

            public ManagedObjectAccessHandler<RbBsRadioParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbBsRadioParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbBsRadioParameters, Smv2Cfg_Smv2> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbBsRadioParameters createEntry() {
            return new RbBsRadioParameters();
        }

        @Override
        protected Class<Smv2Cfg_Smv2> getDataObjectClass() {
            return Smv2Cfg_Smv2.class;
        }

        @Override
        protected void populateEntry(RbBsRadioParameters entry, Smv2Cfg_Smv2 dataObject) {
            entry.setRbBSConfiguredOperatorId(dataObject.getBaseStationId().substring(0, 8));
            entry.setRbBSConfiguredCellId(dataObject.getBaseStationId().substring(9, 14));
            entry.setRbBsOptimalRSSI(dataObject.getAtpcOptimalRssi());
        }
    }
}

