/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.Smv2Cfg_Smv2;
import com.bwanms.validation.Values;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbBsRFModeParameters
extends ScalarMO {
    private static final long serialVersionUID = -1801884779626852612L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbBsRFConfiguredDuplexMode;
    private Integer rbBsRFCurrentDuplexMode;
    private Integer rbBsRFConfiguredDlUlRatio;
    private Integer rbBsRFCurrentDlUlRatio;
    public static final int RbBsRFConfiguredDuplexModeFdd = 1;
    public static final int RbBsRFConfiguredDuplexModeTdd = 2;
    public static final int RbBsRFCurrentDuplexModeFdd = 1;
    public static final int RbBsRFCurrentDuplexModeTdd = 2;
    public static final int RbBsRFConfiguredDlUlRatioUnavailable = 0;
    public static final int RbBsRFConfiguredDlUlRatioTdd65 = 1;
    public static final int RbBsRFConfiguredDlUlRatioTdd60 = 2;
    public static final int RbBsRFConfiguredDlUlRatioTdd55 = 3;
    public static final int RbBsRFConfiguredDlUlRatioTdd50 = 4;
    public static final int RbBsRFConfiguredDlUlRatioTdd45 = 5;
    public static final int RbBsRFConfiguredDlUlRatioTdd40 = 6;
    public static final int RbBsRFConfiguredDlUlRatioTdd35 = 7;
    public static final int RbBsRFCurrentDlUlRatioUnavailable = 0;
    public static final int RbBsRFCurrentDlUlRatioTdd65 = 1;
    public static final int RbBsRFCurrentDlUlRatioTdd60 = 2;
    public static final int RbBsRFCurrentDlUlRatioTdd55 = 3;
    public static final int RbBsRFCurrentDlUlRatioTdd50 = 4;
    public static final int RbBsRFCurrentDlUlRatioTdd45 = 5;
    public static final int RbBsRFCurrentDlUlRatioTdd40 = 6;
    public static final int RbBsRFCurrentDlUlRatioTdd35 = 7;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.3.1", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbBsRFConfiguredDuplexMode")
    public Integer getRbBsRFConfiguredDuplexMode() {
        return this.rbBsRFConfiguredDuplexMode;
    }

    public void setRbBsRFConfiguredDuplexMode(Integer rbBsRFConfiguredDuplexMode) {
        this.rbBsRFConfiguredDuplexMode = rbBsRFConfiguredDuplexMode;
    }

    public static String toStringRbBsRFConfiguredDuplexMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "fdd(1)";
                break;
            }
            case 2: {
                result = "tdd(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.3.2", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    public Integer getRbBsRFCurrentDuplexMode() {
        return this.rbBsRFCurrentDuplexMode;
    }

    public void setRbBsRFCurrentDuplexMode(Integer rbBsRFCurrentDuplexMode) {
        this.rbBsRFCurrentDuplexMode = rbBsRFCurrentDuplexMode;
    }

    public static String toStringRbBsRFCurrentDuplexMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "fdd(1)";
                break;
            }
            case 2: {
                result = "tdd(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.3.3", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @Values(values={1, 2, 3, 4, 5, 6, 7}, toStringConvertorMethodName="toStringRbBsRFConfiguredDlUlRatio")
    public Integer getRbBsRFConfiguredDlUlRatio() {
        return this.rbBsRFConfiguredDlUlRatio;
    }

    public void setRbBsRFConfiguredDlUlRatio(Integer rbBsRFConfiguredDlUlRatio) {
        this.rbBsRFConfiguredDlUlRatio = rbBsRFConfiguredDlUlRatio;
    }

    public static String toStringRbBsRFConfiguredDlUlRatio(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unavailable(0)";
                break;
            }
            case 1: {
                result = "tdd65(1)";
                break;
            }
            case 2: {
                result = "tdd60(2)";
                break;
            }
            case 3: {
                result = "tdd55(3)";
                break;
            }
            case 4: {
                result = "tdd50(4)";
                break;
            }
            case 5: {
                result = "tdd45(5)";
                break;
            }
            case 6: {
                result = "tdd40(6)";
                break;
            }
            case 7: {
                result = "tdd35(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.3.4", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    public Integer getRbBsRFCurrentDlUlRatio() {
        return this.rbBsRFCurrentDlUlRatio;
    }

    public void setRbBsRFCurrentDlUlRatio(Integer rbBsRFCurrentDlUlRatio) {
        this.rbBsRFCurrentDlUlRatio = rbBsRFCurrentDlUlRatio;
    }

    public static String toStringRbBsRFCurrentDlUlRatio(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unavailable(0)";
                break;
            }
            case 1: {
                result = "tdd65(1)";
                break;
            }
            case 2: {
                result = "tdd60(2)";
                break;
            }
            case 3: {
                result = "tdd55(3)";
                break;
            }
            case 4: {
                result = "tdd50(4)";
                break;
            }
            case 5: {
                result = "tdd45(5)";
                break;
            }
            case 6: {
                result = "tdd40(6)";
                break;
            }
            case 7: {
                result = "tdd35(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbBsRFConfiguredDuplexMode=").append(RbBsRFModeParameters.toStringRbBsRFConfiguredDuplexMode(this.rbBsRFConfiguredDuplexMode)).append(", ");
        result.append("rbBsRFCurrentDuplexMode=").append(RbBsRFModeParameters.toStringRbBsRFCurrentDuplexMode(this.rbBsRFCurrentDuplexMode)).append(", ");
        result.append("rbBsRFConfiguredDlUlRatio=").append(RbBsRFModeParameters.toStringRbBsRFConfiguredDlUlRatio(this.rbBsRFConfiguredDlUlRatio)).append(", ");
        result.append("rbBsRFCurrentDlUlRatio=").append(RbBsRFModeParameters.toStringRbBsRFCurrentDlUlRatio(this.rbBsRFCurrentDlUlRatio)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBsRFModeParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBsRFModeParameters>(){

            public ManagedObjectAccessHandler<RbBsRFModeParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBsRFModeParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBsRFModeParameters>(){

            public ManagedObjectAccessHandler<RbBsRFModeParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler<RbBsRFModeParameters>(RbBsRFModeParameters.class){

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbBsRFModeParameters managedObject) throws MediationException {
                        if (managedObject.getRbBsRFConfiguredDlUlRatio() == 0) {
                            managedObject.setRbBsRFConfiguredDlUlRatio(null);
                        }
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbBsRFModeParameters, Smv2Cfg_Smv2> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbBsRFModeParameters createEntry() {
            return new RbBsRFModeParameters();
        }

        @Override
        protected Class<Smv2Cfg_Smv2> getDataObjectClass() {
            return Smv2Cfg_Smv2.class;
        }

        @Override
        protected void populateEntry(RbBsRFModeParameters entry, Smv2Cfg_Smv2 dataObject) {
            entry.setRbBsRFConfiguredDuplexMode(dataObject.getDuplexMode());
            if (entry.getRbBsRFConfiguredDuplexMode().equals(1)) {
                entry.setRbBsRFConfiguredDlUlRatio(0);
            } else {
                entry.setRbBsRFConfiguredDlUlRatio(dataObject.getTDDratio());
            }
        }
    }
}

