/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.validation.Values;
import com.bwanms.validation.WeakRange;

public class RbBerTestSetup
implements NetworkElementCommand {
    private static final long serialVersionUID = -1965550431722567013L;
    private Integer rbBerTestDataSize;
    private Integer rbBerTestModulation;
    private Integer rbBerTestAction;
    private Integer rbBerTestStatus;
    private String rbBerTestSU;
    private Integer rbBerTestTrafficPriority;
    private Integer rbBerTestIterationNumber;
    private Integer rbBerTestSubChannelsNumber;
    private long equipmentId;
    public static final int RbBerTestModulationNotDefined = 0;
    public static final int RbBerTestModulationRBpsk12 = 1;
    public static final int RbBerTestModulationRBpsk34 = 2;
    public static final int RbBerTestModulationRQpsk12 = 3;
    public static final int RbBerTestModulationRQpsk34 = 4;
    public static final int RbBerTestModulationR16Qam12 = 5;
    public static final int RbBerTestModulationR16Qam34 = 6;
    public static final int RbBerTestModulationR64Qam23 = 7;
    public static final int RbBerTestModulationR64Qam34 = 8;
    public static final int RbBerTestActionStart = 1;
    public static final int RbBerTestActionAbort = 2;
    public static final int RbBerTestActionNone = 3;
    public static final int RbBerTestStatusInactive = 1;
    public static final int RbBerTestStatusActive = 2;
    public static final int RbBerTestStatusFinished = 3;
    public static final int RbBerTestStatusFailed = 4;
    public static final int RbBerTestStatusSuDisconnected = 5;
    public static final int RbBerTestTrafficPriorityRealTime = 1;
    public static final int RbBerTestTrafficPriorityNotRealTime = 2;
    public static final int RbBerTestTrafficPriorityBestEffort = 3;

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public final void setEquipmentId(long id) {
        this.equipmentId = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.1", type=2)
    @WeakRange(min=1000L, max=2000000L)
    public Integer getRbBerTestDataSize() {
        return this.rbBerTestDataSize;
    }

    public void setRbBerTestDataSize(Integer rbBerTestDataSize) {
        this.rbBerTestDataSize = rbBerTestDataSize;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.2", type=2)
    @WeakRange(min=0L, max=8L)
    @Values(values={0, 1, 2, 3, 4, 5, 6, 7, 8}, toStringConvertorMethodName="toStringRbBerTestModulation")
    public Integer getRbBerTestModulation() {
        return this.rbBerTestModulation;
    }

    public void setRbBerTestModulation(Integer rbBerTestModulation) {
        this.rbBerTestModulation = rbBerTestModulation;
    }

    public static String toStringRbBerTestModulation(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined(0)";
                break;
            }
            case 1: {
                result = "rBpsk12(1)";
                break;
            }
            case 2: {
                result = "rBpsk34(2)";
                break;
            }
            case 3: {
                result = "rQpsk12(3)";
                break;
            }
            case 4: {
                result = "rQpsk34(4)";
                break;
            }
            case 5: {
                result = "r16Qam12(5)";
                break;
            }
            case 6: {
                result = "r16Qam34(6)";
                break;
            }
            case 7: {
                result = "r64Qam23(7)";
                break;
            }
            case 8: {
                result = "r64Qam34(8)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.3", type=2)
    @WeakRange(min=1L, max=3L)
    public Integer getRbBerTestAction() {
        return this.rbBerTestAction;
    }

    public void setRbBerTestAction(Integer rbBerTestAction) {
        this.rbBerTestAction = rbBerTestAction;
    }

    public static String toStringRbBerTestAction(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "start(1)";
                break;
            }
            case 2: {
                result = "abort(2)";
                break;
            }
            case 3: {
                result = "none(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.4", type=2)
    public Integer getRbBerTestStatus() {
        return this.rbBerTestStatus;
    }

    public void setRbBerTestStatus(Integer rbBerTestStatus) {
        this.rbBerTestStatus = rbBerTestStatus;
    }

    public static String toStringRbBerTestStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "inactive(1)";
                break;
            }
            case 2: {
                result = "active(2)";
                break;
            }
            case 3: {
                result = "finished(3)";
                break;
            }
            case 4: {
                result = "failed(4)";
                break;
            }
            case 5: {
                result = "suDisconnected(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.5", type=112)
    public String getRbBerTestSU() {
        return this.rbBerTestSU;
    }

    public void setRbBerTestSU(String rbBerTestSU) {
        this.rbBerTestSU = rbBerTestSU;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.6", type=2)
    @WeakRange(min=0L, max=3L)
    public Integer getRbBerTestTrafficPriority() {
        return this.rbBerTestTrafficPriority;
    }

    public void setRbBerTestTrafficPriority(Integer rbBerTestTrafficPriority) {
        this.rbBerTestTrafficPriority = rbBerTestTrafficPriority;
    }

    public static String toStringRbBerTestTrafficPriority(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "realTime(1)";
                break;
            }
            case 2: {
                result = "notRealTime(2)";
                break;
            }
            case 3: {
                result = "bestEffort(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.8", type=2)
    @WeakRange(min=1L, max=1000L)
    public Integer getRbBerTestIterationNumber() {
        return this.rbBerTestIterationNumber;
    }

    public void setRbBerTestIterationNumber(Integer rbBerTestIterationNumber) {
        this.rbBerTestIterationNumber = rbBerTestIterationNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.8.1.1.9", type=2)
    @WeakRange(min=1L, max=16L)
    public Integer getRbBerTestSubChannelsNumber() {
        return this.rbBerTestSubChannelsNumber;
    }

    public void setRbBerTestSubChannelsNumber(Integer rbBerTestSubChannelsNumber) {
        this.rbBerTestSubChannelsNumber = rbBerTestSubChannelsNumber;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbBerTestDataSize=").append(this.rbBerTestDataSize).append(", ");
        result.append("rbBerTestModulation=").append(RbBerTestSetup.toStringRbBerTestModulation(this.rbBerTestModulation)).append(", ");
        result.append("rbBerTestAction=").append(RbBerTestSetup.toStringRbBerTestAction(this.rbBerTestAction)).append(", ");
        result.append("rbBerTestStatus=").append(RbBerTestSetup.toStringRbBerTestStatus(this.rbBerTestStatus)).append(", ");
        result.append("rbBerTestSU=").append(this.rbBerTestSU).append(", ");
        result.append("rbBerTestTrafficPriority=").append(RbBerTestSetup.toStringRbBerTestTrafficPriority(this.rbBerTestTrafficPriority)).append(", ");
        result.append("rbBerTestIterationNumber=").append(this.rbBerTestIterationNumber).append(", ");
        result.append("rbBerTestSubChannelsNumber=").append(this.rbBerTestSubChannelsNumber).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getName() {
        return "RbBerTestSetup command";
    }
}

