/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.SwitchingMode_Appl;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbBSSwitchingModeParameters
extends ScalarMO {
    private static final long serialVersionUID = -4121556516613167103L;
    public static int SWITCHING_MODE_ETHERNET_CS = 1;
    public static int SWITCHING_MODE_IP_CS = 2;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbCrtServiceSwitchingMode;
    private Integer rbCfgServiceSwitchingMode;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1.1"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.5.1", type=2)
    @StateAttribute
    public Integer getRbCrtServiceSwitchingMode() {
        return this.rbCrtServiceSwitchingMode;
    }

    public void setRbCrtServiceSwitchingMode(Integer productType) {
        this.rbCrtServiceSwitchingMode = productType;
    }

    public static String toStringRbServiceProvisioningMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "ethernet-CS(1)";
                break;
            }
            case 2: {
                result = "ip-CS(2)";
                break;
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1.1"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.5.2", type=2)
    @ConfigAttribute
    public Integer getRbCfgServiceSwitchingMode() {
        return this.rbCfgServiceSwitchingMode;
    }

    public void setRbCfgServiceSwitchingMode(Integer productType) {
        this.rbCfgServiceSwitchingMode = productType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbCrtServiceSwitchingMode=").append(this.rbCrtServiceSwitchingMode).append(", ");
        result.append("rbCfgServiceSwitchingMode=").append(this.rbCfgServiceSwitchingMode);
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSSwitchingModeParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSSwitchingModeParameters>(){

            public ManagedObjectAccessHandler<RbBSSwitchingModeParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSSwitchingModeParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSSwitchingModeParameters>(){

            public ManagedObjectAccessHandler<RbBSSwitchingModeParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbBSSwitchingModeParameters.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    implements ManagedObjectAccessHandler<RbBSSwitchingModeParameters> {
        static Version sw_V_4_1_1 = VersionFactory.getInstance().createVersion("4.1.1");

        private ConfigFileMOAccessHandler() {
        }

        public List<RbBSSwitchingModeParameters> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            ArrayList<RbBSSwitchingModeParameters> entries = new ArrayList<RbBSSwitchingModeParameters>();
            RbBSSwitchingModeParameters newEntry = new RbBSSwitchingModeParameters();
            RbBaseStationEquipment bsEq = (RbBaseStationEquipment)eq;
            if (bsEq instanceof RbBS && bsEq.getSoftwareVersion().compareTo((Object)sw_V_4_1_1) >= 0) {
                SwitchingMode_Appl sm = (SwitchingMode_Appl)access.fetchObject(null, SwitchingMode_Appl.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SwitchingMode_Appl.class)).get(0);
                newEntry.setRbCrtServiceSwitchingMode(sm.getActualProdType());
            }
            entries.add(newEntry);
            return entries;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbBSSwitchingModeParameters managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot add [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbBSSwitchingModeParameters managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbBSSwitchingModeParameters managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot delete [" + ((Object)((Object)managedObject)).getClass().getName() + "]");
        }
    }
}

