/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.VersionAndModelFilter;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PF;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.11.6.2.1", indexColumns={"RbBSPFServerAddress"})
public class RbBSPFServersEntry
extends DynamicTableRowMO
implements Identifiable {
    private static final long serialVersionUID = 2468648576822141741L;
    public static final int MAX_NUMBER_OF_PF_SERVERS = 20;
    public static final int NEW_MAX_NUMBER_OF_PF_SERVERS = 10;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbBSPFServerAddress;
    private Integer rbBSPFServerPortNumber;
    private Integer rbBSPFServerPFVlan;
    private String rbBSPFServerSharedString;
    private Integer rbBSPFServerStatus;
    private Integer rbBSPFServerOperStatus;
    private Integer rbBSPFServerRowStatus;
    private String rbPFServerIfcIpAddress;
    private String rbPFServerIfcSubnetMask;
    private String rbPFServerGateway;
    private Integer rbPFServerDataPortAdopt;
    public static final int DataPortAdopt_None = 0;
    public static final int DataPortAdopt_Yes = 1;
    public static final int DataPortAdopt_No = 2;
    public static final int RbBSPFServerStatusActive = 1;
    public static final int RbBSPFServerStatusStandby = 2;
    public static final int RbVPLDomainPrimaryPFOperStatusUp = 1;
    public static final int RbVPLDomainPrimaryPFOperStatusDown = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.11", type=2)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.5", "model", "BreezeMAX_BS"})
    public Integer getRbPFServerDataPortAdopt() {
        return this.rbPFServerDataPortAdopt;
    }

    public void setRbPFServerDataPortAdopt(Integer rbPFServerDataPortAdopt) {
        this.rbPFServerDataPortAdopt = rbPFServerDataPortAdopt;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.1", type=64)
    @IPv4Address(acceptAnyIp=true)
    public String getRbBSPFServerAddress() {
        return this.rbBSPFServerAddress;
    }

    public void setRbBSPFServerAddress(String rbBSPFServerAddress) {
        this.rbBSPFServerAddress = rbBSPFServerAddress;
    }

    @WeakRange(min=1L, max=65535L)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.2", type=2)
    public Integer getRbBSPFServerPortNumber() {
        return this.rbBSPFServerPortNumber;
    }

    public void setRbBSPFServerPortNumber(Integer rbBSPFServerPortNumber) {
        this.rbBSPFServerPortNumber = rbBSPFServerPortNumber;
    }

    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.3", type=2)
    public Integer getRbBSPFServerPFVlan() {
        return this.rbBSPFServerPFVlan;
    }

    public void setRbBSPFServerPFVlan(Integer rbVoiceDomainPFVlan) {
        this.rbBSPFServerPFVlan = rbVoiceDomainPFVlan;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.4", type=-128)
    public String getRbBSPFServerSharedString() {
        return this.rbBSPFServerSharedString;
    }

    public void setRbBSPFServerSharedString(String rbVoiceDomainSharedString) {
        this.rbBSPFServerSharedString = rbVoiceDomainSharedString;
    }

    @StateAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.5", type=2)
    public Integer getRbBSPFServerStatus() {
        return this.rbBSPFServerStatus;
    }

    public void setRbBSPFServerStatus(Integer rbBSPFServerStatus) {
        this.rbBSPFServerStatus = rbBSPFServerStatus;
    }

    public static String toStringRbBSPFServerStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "standby(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakRange(min=0L, max=4095L)
    @StateAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.6", type=2)
    public Integer getRbBSPFServerOperStatus() {
        return this.rbBSPFServerOperStatus;
    }

    public void setRbBSPFServerOperStatus(Integer rbBSPFServerPFVlan) {
        this.rbBSPFServerOperStatus = rbBSPFServerPFVlan;
    }

    public static String toStringRbPFServerOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.7", type=2)
    public Integer getRowStatus() {
        return this.rbBSPFServerRowStatus;
    }

    public void setRowStatus(Integer rbBSPFServerRowStatus) {
        this.rbBSPFServerRowStatus = rbBSPFServerRowStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.8", type=64)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.5", "model", "BreezeMAX_BS"})
    @ConfigAttribute
    public String getRbPFServerIfcIpAddress() {
        return this.rbPFServerIfcIpAddress;
    }

    public void setRbPFServerIfcIpAddress(String rbPFServerIfcIpAddress) {
        this.rbPFServerIfcIpAddress = rbPFServerIfcIpAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.9", type=64)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.5", "model", "BreezeMAX_BS"})
    @ConfigAttribute
    public String getRbPFServerIfcSubnetMask() {
        return this.rbPFServerIfcSubnetMask;
    }

    public void setRbPFServerIfcSubnetMask(String rbPFServerIfcSubnetMask) {
        this.rbPFServerIfcSubnetMask = rbPFServerIfcSubnetMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.6.2.1.10", type=64)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.5", "model", "BreezeMAX_BS"})
    @ConfigAttribute
    public String getRbPFServerGateway() {
        return this.rbPFServerGateway;
    }

    public void setRbPFServerGateway(String rbPFServerGateway) {
        this.rbPFServerGateway = rbPFServerGateway;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    public String getRowKey() {
        return String.valueOf(this.rbBSPFServerAddress);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbBSPFServerAddress=").append(this.rbBSPFServerAddress).append(", ");
        result.append("rbBSPFServerPortNumber=").append(this.rbBSPFServerPortNumber).append(", ");
        result.append("rbBSPFServerPFVlan=").append(this.rbBSPFServerPFVlan).append(", ");
        result.append("rbBSPFServerSharedString=").append(this.rbBSPFServerSharedString).append(", ");
        result.append("rbBSPFServerStatus=").append(RbBSPFServersEntry.toStringRbBSPFServerStatus(this.rbBSPFServerOperStatus)).append(", ");
        result.append("rbBSPFServerOperStatus=").append(RbBSPFServersEntry.toStringRbPFServerOperStatus(this.rbBSPFServerOperStatus)).append(", ");
        result.append("rbBSPFServerRowStatus=").append(RbBSPFServersEntry.toStringRowStatus(this.rbBSPFServerRowStatus));
        result.append("rbPFServerIfcIpAddress=").append(this.rbPFServerIfcIpAddress).append(", ");
        result.append("rbPFServerIfcSubnetMask=").append(this.rbPFServerIfcSubnetMask).append(", ");
        result.append("rbPFServerGateway=").append(this.rbPFServerGateway).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSPFServersEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSPFServersEntry>(){

            public ManagedObjectAccessHandler<RbBSPFServersEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSPFServersEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSPFServersEntry>(){

            public ManagedObjectAccessHandler<RbBSPFServersEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbBSPFServersEntry>(RbBSPFServersEntry.class){

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbBSPFServersEntry managedObject) throws MediationException {
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbBSPFServersEntry, PF> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbBSPFServersEntry createEntry() {
            return new RbBSPFServersEntry();
        }

        @Override
        protected Class<PF> getDataObjectClass() {
            return PF.class;
        }

        @Override
        protected void populateEntry(RbBSPFServersEntry entry, PF dataObject) {
            entry.setId(dataObject.getRbBSPFServerVLAN().intValue());
            entry.setRbBSPFServerAddress(dataObject.getRbBSPFServerAddress());
            entry.setRbBSPFServerPortNumber(dataObject.getRbBSPFServerPortNumber());
            entry.setRbBSPFServerPFVlan(dataObject.getRbBSPFServerVLAN());
            entry.setRbBSPFServerSharedString(dataObject.getRbBSPFServerSharedString());
        }
    }
}

