/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.VersionAndModelFilter;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.MigpsCfg_Migps;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.validation.Values;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbBSClockConfigParameters
extends ScalarMO {
    private static final long serialVersionUID = -2964715175104722409L;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbBSConfiguredClockMode;
    private Integer rbBSCurrentClockMode;
    private Integer rbBSConfiguredExternalPPSClock;
    private Integer rbBSCurrentExternalPPSClock;
    private Integer rbBSConfiguredExternal16MhzClock;
    private Integer rbBSCurrentExternal16MhzClock;
    public static final int RbBSClockModeMaster = 1;
    public static final int RbBSClockModeRedundant = 2;
    public static final int RbBSClockModeSlave1 = 3;
    public static final int RbBSClockModeSlave2 = 4;
    public static final int RbBSClockModeSlave3 = 5;
    public static final int RbBSClockModeSlave4 = 6;
    public static final int RbBSConfiguredExternalPPSClockEnable = 1;
    public static final int RbBSConfiguredExternalPPSClockDisable = 2;
    public static final int RbBSCurrentExternalPPSClockEnable = 1;
    public static final int RbBSCurrentExternalPPSClockDisable = 2;
    public static final int RbBSConfiguredExternal16MhzClockEnable = 1;
    public static final int RbBSConfiguredExternal16MhzClockDisable = 2;
    public static final int RbBSCurrentExternal16MhzClockEnable = 1;
    public static final int RbBSCurrentExternal16MhzClockDisable = 2;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Values(values={1, 3, 4, 5, 6}, toStringConvertorMethodName="toStringRbBSCurrentClockMode")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.5", type=2)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.2", "model", "BreezeMAX_MBS"})
    @ConfigAttribute
    @Column(name="rbBSConfClkMode")
    public Integer getRbBSConfiguredClockMode() {
        return this.rbBSConfiguredClockMode;
    }

    public void setRbBSConfiguredClockMode(Integer rbBSConfiguredClockMode) {
        this.rbBSConfiguredClockMode = rbBSConfiguredClockMode;
    }

    public static String toStringRbBSConfiguredClockMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "master(1)";
                break;
            }
            case 2: {
                result = "redundant(2)";
                break;
            }
            case 3: {
                result = "slave1(3)";
                break;
            }
            case 4: {
                result = "slave2(4)";
                break;
            }
            case 5: {
                result = "slave3(5)";
                break;
            }
            case 6: {
                result = "slave4(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.6", type=2)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.2", "model", "BreezeMAX_MBS"})
    @StateAttribute
    @Column(name="rbBSCrtClkMode")
    public Integer getRbBSCurrentClockMode() {
        return this.rbBSCurrentClockMode;
    }

    public void setRbBSCurrentClockMode(Integer rbBSCurrentClockMode) {
        this.rbBSCurrentClockMode = rbBSCurrentClockMode;
    }

    public static String toStringRbBSCurrentClockMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "master(1)";
                break;
            }
            case 2: {
                result = "redundant(2)";
                break;
            }
            case 3: {
                result = "slave1(3)";
                break;
            }
            case 4: {
                result = "slave2(4)";
                break;
            }
            case 5: {
                result = "slave3(5)";
                break;
            }
            case 6: {
                result = "slave4(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbBSConfiguredExternalPPSClock")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.1", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @Column(name="RbBsConfExtPPSClk")
    public Integer getRbBSConfiguredExternalPPSClock() {
        return this.rbBSConfiguredExternalPPSClock;
    }

    public void setRbBSConfiguredExternalPPSClock(Integer rbBSConfiguredExternalPPSClock) {
        this.rbBSConfiguredExternalPPSClock = rbBSConfiguredExternalPPSClock;
    }

    public static String toStringRbBSConfiguredExternalPPSClock(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.2", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    @Column(name="RbBsCrtExtPPSClk")
    public Integer getRbBSCurrentExternalPPSClock() {
        return this.rbBSCurrentExternalPPSClock;
    }

    public void setRbBSCurrentExternalPPSClock(Integer rbBSCurrentExternalPPSClock) {
        this.rbBSCurrentExternalPPSClock = rbBSCurrentExternalPPSClock;
    }

    public static String toStringRbBSCurrentExternalPPSClock(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbBSConfiguredExternal16MhzClock")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.3", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    @Column(name="RbBSConfExt16MhzClk")
    public Integer getRbBSConfiguredExternal16MhzClock() {
        return this.rbBSConfiguredExternal16MhzClock;
    }

    public void setRbBSConfiguredExternal16MhzClock(Integer rbBSConfiguredExternal16MhzClock) {
        this.rbBSConfiguredExternal16MhzClock = rbBSConfiguredExternal16MhzClock;
    }

    public static String toStringRbBSConfiguredExternal16MhzClock(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.11.4.4", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @StateAttribute
    @Column(name="RbBSCrtExt16MhzClk")
    public Integer getRbBSCurrentExternal16MhzClock() {
        return this.rbBSCurrentExternal16MhzClock;
    }

    public void setRbBSCurrentExternal16MhzClock(Integer rbBSCurrentExternal16MhzClock) {
        this.rbBSCurrentExternal16MhzClock = rbBSCurrentExternal16MhzClock;
    }

    public static String toStringRbBSCurrentExternal16MhzClock(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbBSConfiguredExternalPPSClock=").append(RbBSClockConfigParameters.toStringRbBSConfiguredExternalPPSClock(this.rbBSConfiguredExternalPPSClock)).append(", ");
        result.append("rbBSCurrentExternalPPSClock=").append(RbBSClockConfigParameters.toStringRbBSCurrentExternalPPSClock(this.rbBSCurrentExternalPPSClock)).append(", ");
        result.append("rbBSConfiguredExternal16MhzClock=").append(RbBSClockConfigParameters.toStringRbBSConfiguredExternal16MhzClock(this.rbBSConfiguredExternal16MhzClock)).append(", ");
        result.append("rbBSCurrentExternal16MhzClock=").append(RbBSClockConfigParameters.toStringRbBSCurrentExternal16MhzClock(this.rbBSCurrentExternal16MhzClock)).append(", ");
        result.append("rbBSConfiguredClockMode=").append(RbBSClockConfigParameters.toStringRbBSConfiguredClockMode(this.rbBSConfiguredClockMode)).append(", ");
        result.append("rbBSCurrentClockMode=").append(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(this.rbBSCurrentClockMode)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSClockConfigParameters.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSClockConfigParameters>(){

            public ManagedObjectAccessHandler<RbBSClockConfigParameters> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbBSClockConfigParameters.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbBSClockConfigParameters>(){

            public ManagedObjectAccessHandler<RbBSClockConfigParameters> createHandler() {
                return new DefaultManagedObjectAccessHandler<RbBSClockConfigParameters>(RbBSClockConfigParameters.class){

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbBSClockConfigParameters managedObject) throws MediationException {
                        Integer ext16Mhz = managedObject.getRbBSConfiguredExternal16MhzClock();
                        Integer extPPS = managedObject.getRbBSConfiguredExternalPPSClock();
                        managedObject.setRbBSConfiguredExternal16MhzClock(null);
                        managedObject.setRbBSConfiguredExternalPPSClock(null);
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                        if (!RbVersions.V_4_2.isSupersetOf(((RbBaseStationEquipment)eq).getSoftwareVersion()) || Integer.valueOf(1).equals(managedObject.getRbBSConfiguredClockMode())) {
                            managedObject.setRbBSConfiguredExternal16MhzClock(ext16Mhz);
                            managedObject.setRbBSConfiguredExternalPPSClock(extPPS);
                            super.update(eq, access, networkResource, (ManagedObject)managedObject);
                        }
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbBSClockConfigParameters, MigpsCfg_Migps> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbBSClockConfigParameters createEntry() {
            return new RbBSClockConfigParameters();
        }

        @Override
        protected Class<MigpsCfg_Migps> getDataObjectClass() {
            return MigpsCfg_Migps.class;
        }

        @Override
        protected void populateEntry(RbBSClockConfigParameters entry, MigpsCfg_Migps dataObject) {
            entry.setRbBSConfiguredExternal16MhzClock(dataObject.getBsClockExternal16Mhz());
            entry.setRbBSConfiguredExternalPPSClock(dataObject.getBsClockExternalPPS());
            entry.setRbBSConfiguredClockMode(dataObject.getBsClockMode());
        }
    }
}

