/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuthMngDb_AuthMng;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.6.1.1", indexColumns={"AuthMngrIpAddr"})
public class RbAuthorizedManagersEntry
extends DynamicTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private String authMngrIpAddr;
    private String authMngrReadCommunity;
    private String authMngrWriteCommunity;
    private Integer authMngrTrapEnable;
    public static final int AuthMngrTrapEnableEnable = 1;
    public static final int AuthMngrTrapEnableDisable = 2;
    private Integer authMngrRowStatus;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.1.1.1", type=64)
    @ConfigAttribute
    public String getAuthMngrIpAddr() {
        return this.authMngrIpAddr;
    }

    public void setAuthMngrIpAddr(String authMngrIpAddr) {
        this.authMngrIpAddr = authMngrIpAddr;
    }

    @Length(min=0, max=23)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.1.1.2", type=-128)
    @ConfigAttribute
    public String getAuthMngrReadCommunity() {
        return this.authMngrReadCommunity;
    }

    public void setAuthMngrReadCommunity(String authMngrReadCommunity) {
        this.authMngrReadCommunity = authMngrReadCommunity;
    }

    @Length(min=0, max=23)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.1.1.3", type=-128)
    @ConfigAttribute
    public String getAuthMngrWriteCommunity() {
        return this.authMngrWriteCommunity;
    }

    public void setAuthMngrWriteCommunity(String authMngrWriteCommunity) {
        this.authMngrWriteCommunity = authMngrWriteCommunity;
    }

    @WeakRange(min=1L, max=2L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.1.1.4", type=2)
    @ConfigAttribute
    public Integer getAuthMngrTrapEnable() {
        return this.authMngrTrapEnable;
    }

    public void setAuthMngrTrapEnable(Integer authMngrTrapEnable) {
        this.authMngrTrapEnable = authMngrTrapEnable;
    }

    public String toStringAuthMngrTrapEnable(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.1.1.5", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.authMngrRowStatus;
    }

    public void setRowStatus(Integer authMngrRowStatus) {
        this.authMngrRowStatus = authMngrRowStatus;
    }

    public String toStringAuthMngrRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("authMngrIpAddr=").append(this.authMngrIpAddr).append(", ");
        result.append("authMngrReadCommunity=").append(this.authMngrReadCommunity).append(", ");
        result.append("authMngrWriteCommunity=").append(this.authMngrWriteCommunity).append(", ");
        result.append("authMngrTrapEnable=").append(this.toStringAuthMngrTrapEnable(this.authMngrTrapEnable)).append(", ");
        result.append("authMngrRowStatus=").append(this.toStringAuthMngrRowStatus(this.authMngrRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getAuthMngrIpAddr();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuthorizedManagersEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuthorizedManagersEntry>(){

            public ManagedObjectAccessHandler<RbAuthorizedManagersEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuthorizedManagersEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuthorizedManagersEntry>(){

            public ManagedObjectAccessHandler<RbAuthorizedManagersEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler(RbAuthorizedManagersEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbAuthorizedManagersEntry, AuthMngDb_AuthMng> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbAuthorizedManagersEntry createEntry() {
            return new RbAuthorizedManagersEntry();
        }

        @Override
        protected Class<AuthMngDb_AuthMng> getDataObjectClass() {
            return AuthMngDb_AuthMng.class;
        }

        @Override
        protected void populateEntry(RbAuthorizedManagersEntry entry, AuthMngDb_AuthMng dataObject) {
            entry.setAuthMngrIpAddr(dataObject.getIpAddress());
            entry.setAuthMngrReadCommunity(dataObject.getReadCommunity());
            entry.setAuthMngrWriteCommunity(dataObject.getWriteCommunity());
            entry.setAuthMngrTrapEnable(2 == dataObject.getSendTraps() ? 1 : 2);
        }
    }
}

