/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PhyMacAuDb_PhyMacAu;
import com.bwanms.validation.Values;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@EmbeddableSuperclass
public class RbAuPhyParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbAuCurrentPhyBandwidth;
    private String rbAuPhyTxFrequencyChannel;
    private String rbAuPhyTxConfiguredFrequencyChannel;
    private Integer rbAuPhyConfiguredBandwidth;
    public static final int RbAuCurrentPhyBandwidthB175 = 1;
    public static final int RbAuCurrentPhyBandwidthB35 = 2;
    public static final int RbAuCurrentPhyBandwidthB100 = 5;
    public static final int RbAuCurrentPhyBandwidthB50 = 3;
    public static final int RbAuCurrentPhyBandwidthB70 = 4;
    public static int rbAuPhyConfiguredBandwidthB175 = 1;
    public static int rbAuPhyConfiguredBandwidthB35 = 2;
    public static final int RbAuConfiguredPhyBandwidthB100 = 5;
    public static final int RbAuConfiguredPhyBandwidthB50 = 3;
    public static final int RbAuConfiguredPhyBandwidthB70 = 4;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.7.1", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAuCurrentPhyBandwidth() {
        return this.rbAuCurrentPhyBandwidth;
    }

    public void setRbAuCurrentPhyBandwidth(Integer rbAuCurrentPhyBandwidth) {
        this.rbAuCurrentPhyBandwidth = rbAuCurrentPhyBandwidth;
    }

    public static String toStringRbAuCurrentPhyBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            case 0: {
                result = "NA(0)";
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    public static double getFrequencyBoundsAdjust(int bandwidth) {
        double adjust = 0.0;
        switch (bandwidth) {
            case 1: {
                adjust = 0.875;
                break;
            }
            case 2: {
                adjust = 1.75;
                break;
            }
            case 3: {
                adjust = 2.5;
                break;
            }
            case 4: {
                adjust = 3.5;
                break;
            }
            case 5: {
                adjust = 5.0;
            }
        }
        return adjust;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.7.2", type=4, readOnly=true)
    @StateAttribute
    public String getRbAuPhyTxFrequencyChannel() {
        return this.rbAuPhyTxFrequencyChannel;
    }

    public void setRbAuPhyTxFrequencyChannel(String rbAuPhyTxFrequencyChannel) {
        this.rbAuPhyTxFrequencyChannel = rbAuPhyTxFrequencyChannel;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.7.3", type=4, readOnly=false)
    @Column(name="rbAuPhyTxConfigFreqChannel")
    @ConfigAttribute
    public String getRbAuPhyTxConfiguredFrequencyChannel() {
        return this.rbAuPhyTxConfiguredFrequencyChannel;
    }

    public void setRbAuPhyTxConfiguredFrequencyChannel(String rbAuPhyTxConfiguredFrequencyChannel) {
        this.rbAuPhyTxConfiguredFrequencyChannel = rbAuPhyTxConfiguredFrequencyChannel;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.7.4", type=2, readOnly=false)
    @ConfigAttribute
    @Values(values={1, 2, 3, 4, 5}, toStringConvertorMethodName="toStringRbAuPhyConfiguredBandwidth")
    public Integer getRbAuPhyConfiguredBandwidth() {
        return this.rbAuPhyConfiguredBandwidth;
    }

    public void setRbAuPhyConfiguredBandwidth(Integer rbAuPhyConfiguredBandwidth) {
        this.rbAuPhyConfiguredBandwidth = rbAuPhyConfiguredBandwidth;
    }

    public static String toStringRbAuPhyConfiguredBandwidth(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "b175(1)";
                break;
            }
            case 2: {
                result = "b35(2)";
                break;
            }
            case 3: {
                result = "b50(3)";
                break;
            }
            case 4: {
                result = "b70(4)";
                break;
            }
            case 5: {
                result = "b100(5)";
                break;
            }
            default: {
                result = "undefined";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuCurrentPhyBandwidth=").append(this.rbAuCurrentPhyBandwidth).append(", ");
        result.append("rbAuPhyTxFrequencyChannel=").append(this.rbAuPhyTxFrequencyChannel).append(", ");
        result.append("rbAuPhyTxConfiguredFrequencyChannel=").append(this.rbAuPhyTxConfiguredFrequencyChannel).append(", ");
        result.append("rbAuPhyConfiguredBandwidth=").append(this.rbAuPhyConfiguredBandwidth).append(", ");
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbAuPhyParameters>
    extends AbstractConfigFileMOAccessHandler<E, PhyMacAuDb_PhyMacAu> {
        int auid = 0;

        protected ConfigFileMOAccessHandler() {
        }

        @Override
        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.auid = ConfigFileUtil.rbSlotNumberToConfigFileAuID(ConfigFileUtil.getSlotNumberFromNetworkResource(networkResource));
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected Class<PhyMacAuDb_PhyMacAu> getDataObjectClass() {
            return PhyMacAuDb_PhyMacAu.class;
        }

        @Override
        protected void populateEntry(E entry, PhyMacAuDb_PhyMacAu dataObject) {
            if (dataObject.getAUID() == this.auid) {
                ((RbAuPhyParameters)((Object)entry)).setRbAuPhyTxFrequencyChannel(Double.toString((double)dataObject.getTxFrequency().longValue() / 1000.0));
            }
        }
    }
}

