/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PhyMacAuDb_PhyMacAu;
import java.util.List;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@EmbeddableSuperclass
public class RbAuMultirateParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbAuMultirateSupport;
    private Integer rbAuUlBasicRate;
    private Integer rbAuDlBasicRate;
    private Integer rbAuUlMinNoOfSubChannels;
    private Integer rbAuUlCrtMinNoOfSubChannels;
    public static final int RbAuMultirateSupportEnabled = 1;
    public static final int RbAuMultirateSupportDisabled = 2;
    public static final int RbAuBasicRateBPSK12 = 1;
    public static final int RbAuBasicRateBPSK34 = 2;
    public static final int RbAuBasicRateQPSK12 = 3;
    public static final int RbAuBasicRateQPSK34 = 4;
    public static final int RbAuBasicRateQAM16_12 = 5;
    public static final int RbAuBasicRateQAM16_34 = 6;
    public static final int RbAuBasicRateQAM64_23 = 7;
    public static final int RbAuBasicRateQAM64_34 = 8;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.3.1", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuMultirateSupport() {
        return this.rbAuMultirateSupport;
    }

    public void setRbAuMultirateSupport(Integer rbAuMultirateSupport) {
        this.rbAuMultirateSupport = rbAuMultirateSupport;
    }

    public static String toStringRbAuMultirateSupport(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enabled(1)";
                break;
            }
            case 2: {
                result = "disabled(2)";
                break;
            }
            default: {
                result = "notDefined";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.3.2", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuUlBasicRate() {
        return this.rbAuUlBasicRate;
    }

    public void setRbAuUlBasicRate(Integer rbAuUlBasicRate) {
        this.rbAuUlBasicRate = rbAuUlBasicRate;
    }

    public static String toStringRbAuUlBasicRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined(0)";
                break;
            }
            case 1: {
                result = "rBpsk12(1)";
                break;
            }
            case 2: {
                result = "rBpsk34(2)";
                break;
            }
            case 3: {
                result = "rQpsk12(3)";
                break;
            }
            case 4: {
                result = "rQpsk34(4)";
                break;
            }
            case 5: {
                result = "r16Qam12(5)";
                break;
            }
            case 6: {
                result = "r16Qam34(6)";
                break;
            }
            case 7: {
                result = "r64Qam23(7)";
                break;
            }
            case 8: {
                result = "r64Qam34(8)";
                break;
            }
            default: {
                result = "notDefined";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.3.3", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuDlBasicRate() {
        return this.rbAuDlBasicRate;
    }

    public void setRbAuDlBasicRate(Integer rbAuDlBasicRate) {
        this.rbAuDlBasicRate = rbAuDlBasicRate;
    }

    public static String toStringRbAuDlBasicRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined(0)";
                break;
            }
            case 1: {
                result = "rBpsk12(1)";
                break;
            }
            case 2: {
                result = "rBpsk34(2)";
                break;
            }
            case 3: {
                result = "rQpsk12(3)";
                break;
            }
            case 4: {
                result = "rQpsk34(4)";
                break;
            }
            case 5: {
                result = "r16Qam12(5)";
                break;
            }
            case 6: {
                result = "r16Qam34(6)";
                break;
            }
            case 7: {
                result = "r64Qam23(7)";
                break;
            }
            case 8: {
                result = "r64Qam34(8)";
                break;
            }
            default: {
                result = "notDefined";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.3.4", type=2, readOnly=false)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0.2"})
    public Integer getRbAuUlMinNoOfSubChannels() {
        return this.rbAuUlMinNoOfSubChannels;
    }

    public void setRbAuUlMinNoOfSubChannels(Integer rbAuUlMinNoOfSubChannels) {
        this.rbAuUlMinNoOfSubChannels = rbAuUlMinNoOfSubChannels;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.3.5", type=2, readOnly=false)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1.1.8"})
    public Integer getRbAuUlCrtMinNoOfSubChannels() {
        return this.rbAuUlCrtMinNoOfSubChannels;
    }

    public void setRbAuUlCrtMinNoOfSubChannels(Integer rbAuUlCurrentMinNoOfSubChannels) {
        this.rbAuUlCrtMinNoOfSubChannels = rbAuUlCurrentMinNoOfSubChannels;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuMultirateSupport=").append(this.rbAuMultirateSupport).append(", ");
        result.append("rbAuUlBasicRate=").append(RbAuMultirateParameters.toStringRbAuUlBasicRate(this.rbAuUlBasicRate)).append(", ");
        result.append("rbAuDlBasicRate=").append(RbAuMultirateParameters.toStringRbAuDlBasicRate(this.rbAuDlBasicRate)).append(", ");
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbAuMultirateParameters>
    extends AbstractConfigFileMOAccessHandler<E, PhyMacAuDb_PhyMacAu> {
        int auid = 0;

        protected ConfigFileMOAccessHandler() {
        }

        @Override
        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.auid = ConfigFileUtil.rbSlotNumberToConfigFileAuID(ConfigFileUtil.getSlotNumberFromNetworkResource(networkResource));
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected Class<PhyMacAuDb_PhyMacAu> getDataObjectClass() {
            return PhyMacAuDb_PhyMacAu.class;
        }

        @Override
        protected void populateEntry(E entry, PhyMacAuDb_PhyMacAu dataObject) {
            if (dataObject.getAUID() == this.auid) {
                ((RbAuMultirateParameters)((Object)entry)).setRbAuDlBasicRate(dataObject.getDlBaseRate().intValue());
                ((RbAuMultirateParameters)((Object)entry)).setRbAuUlBasicRate(dataObject.getDlBaseRate().intValue());
                ((RbAuMultirateParameters)((Object)entry)).setRbAuMultirateSupport(1);
            }
        }
    }
}

