/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PhyMacAuDb_PhyMacAu;
import com.bwanms.util.OctetString;
import com.bwanms.validation.WeakRange;
import java.util.List;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Pattern;

@EmbeddableSuperclass
public class RbAuMacParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String rbAuBaseStationId;
    private Integer rbAuMaxCellRadius;
    private String rbAuConfiguredBaseStationId;
    private String rbAuConfiguredSectorId;
    private Integer rbAuARQState;
    private Integer rbAuConfiguredARQState;
    private Integer rbAuCurrentMaxCellRadius;
    public static final int RbAuARQStateEnabled = 1;
    public static final int RbAuARQStateDisabled = 2;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.1", type=4, readOnly=true)
    @StateAttribute
    public String getRbAuBaseStationId() {
        return this.rbAuBaseStationId;
    }

    public void setRbAuBaseStationId(String rbAuBaseStationId) {
        this.rbAuBaseStationId = rbAuBaseStationId;
    }

    @WeakRange(min=10L, max=110L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.2", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuMaxCellRadius() {
        return this.rbAuMaxCellRadius;
    }

    public void setRbAuMaxCellRadius(Integer rbAuMaxCellRadius) {
        this.rbAuMaxCellRadius = rbAuMaxCellRadius;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.3", type=4, readOnly=true)
    @StateAttribute
    public String getRbAuConfiguredBaseStationId() {
        return this.rbAuConfiguredBaseStationId;
    }

    public void setRbAuConfiguredBaseStationId(String rbAuConfiguredBaseStationId) {
        this.rbAuConfiguredBaseStationId = rbAuConfiguredBaseStationId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.4", type=2, readOnly=true)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "<=4.0.2"})
    @StateAttribute
    public Integer getRbAuARQState() {
        return this.rbAuARQState;
    }

    public void setRbAuARQState(Integer rbAuARQState) {
        this.rbAuARQState = rbAuARQState;
    }

    public static String toStringRbAuARQState(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "Enable";
                break;
            }
            case 2: {
                result = "Disable";
                break;
            }
            default: {
                result = "undefined";
            }
        }
        return result;
    }

    @WeakRange(min=1L, max=2L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.5", type=2, readOnly=false)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "<=4.0.2"})
    @ConfigAttribute
    public Integer getRbAuConfiguredARQState() {
        return this.rbAuConfiguredARQState;
    }

    public void setRbAuConfiguredARQState(Integer rbAuConfiguredARQState) {
        this.rbAuConfiguredARQState = rbAuConfiguredARQState;
    }

    public static String toStringRbAuConfiguredARQState(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "Enable";
                break;
            }
            case 2: {
                result = "Disable";
                break;
            }
            default: {
                result = "undefined";
            }
        }
        return result;
    }

    @Pattern(regex="\\p{XDigit}+")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.6", type=4, readOnly=false)
    @ConfigAttribute
    public String getRbAuConfiguredSectorId() {
        return this.rbAuConfiguredSectorId;
    }

    public void setRbAuConfiguredSectorId(String rbAuConfiguredSectorId) {
        this.rbAuConfiguredSectorId = rbAuConfiguredSectorId;
    }

    @Transient
    public String getRbAuConfiguredSectorIdValue() {
        return OctetString.toDottedDecimalForm((String)this.getRbAuConfiguredSectorId());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuBaseStationId=").append(this.rbAuBaseStationId).append(", ");
        result.append("rbAuMaxCellRadius=").append(this.rbAuMaxCellRadius).append(", ");
        result.append("rbAuConfiguredBaseStationId=").append(this.rbAuConfiguredBaseStationId).append(", ");
        result.append("rbAuARQState=").append(this.rbAuARQState).append(", ");
        result.append("rbAuConfiguredSectorId=").append(this.rbAuConfiguredSectorId).append(", ");
        result.append("rbAuConfiguredARQState=").append(this.rbAuConfiguredARQState);
        result.append("rbAuCurrentMaxCellRadius=").append(this.rbAuCurrentMaxCellRadius).append(", ");
        result.append("]");
        return result.toString();
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.1.7", type=2)
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbAuCurrentMaxCellRadius() {
        return this.rbAuCurrentMaxCellRadius;
    }

    public void setRbAuCurrentMaxCellRadius(Integer rbAuCurrentMaxCellRadius) {
        this.rbAuCurrentMaxCellRadius = rbAuCurrentMaxCellRadius;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbAuMacParameters>
    extends AbstractConfigFileMOAccessHandler<E, PhyMacAuDb_PhyMacAu> {
        int auid = 0;

        protected ConfigFileMOAccessHandler() {
        }

        @Override
        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.auid = ConfigFileUtil.rbSlotNumberToConfigFileAuID(ConfigFileUtil.getSlotNumberFromNetworkResource(networkResource));
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected Class<PhyMacAuDb_PhyMacAu> getDataObjectClass() {
            return PhyMacAuDb_PhyMacAu.class;
        }

        @Override
        protected void populateEntry(E entry, PhyMacAuDb_PhyMacAu dataObject) {
            if (dataObject.getAUID() == this.auid) {
                ((RbAuMacParameters)((Object)entry)).setRbAuConfiguredARQState(dataObject.getArqStatus());
                ((RbAuMacParameters)((Object)entry)).setRbAuConfiguredBaseStationId(dataObject.getBaseStationId());
                ((RbAuMacParameters)((Object)entry)).setRbAuMaxCellRadius(dataObject.getMaxCellRadius().intValue());
                ((RbAuMacParameters)((Object)entry)).setRbAuConfiguredSectorId(dataObject.getBaseStationId().substring(15));
            }
        }
    }
}

