/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.SwitchingModeOrVersionFilter;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuDb_Au;
import com.bwanms.rb.mo.configfile.AuV2Db_AuV2;
import com.bwanms.rb.mo.configfile.BwDegradationDb_BwDegradation;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.validation.WeakRange;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.3.1", indexColumns={"RbSlotNumber"})
public class RbAuConfigEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = -2247435396186135489L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbSlotNumber;
    private String rbAuSerialNo;
    private Integer rbAuFaultStatus;
    private String rbAuIduHwRevision;
    private String rbAuOperSwFileName;
    private String rbAuOperSwVersion;
    private String rbAuShadowSwFileName;
    private String rbAuShadowSwVersion;
    private Integer rbAuRunningSoftware;
    private String rbAuIduHwConfigDescription;
    private String rbAuOduHwConfigDescription;
    private String rbAuOduHwRevision;
    private Integer rbAuMaxNumberOfCalls;
    private Integer rbAuNumberOfRegisteredSUs;
    private Integer rbAuAirInterfaceType;
    private Long rbAuCumulativePowerOnTime;
    private Integer rbAuActiveVoiceCalls;
    private Integer rbAuIduTemperature;
    private Integer rbAuIduType;
    private Integer rbAuDiversityMode;
    public static final int RbAuFaultStatusNoFaults = 1;
    public static final int RbAuFaultStatusMinor = 2;
    public static final int RbAuFaultStatusMajor = 3;
    public static final int RbAuFaultStatusCritical = 4;
    public static final int RbAuFaultStatusDisconnected = 5;
    public static final int RbAuRunningSoftwareOperational = 1;
    public static final int RbAuRunningSoftwareShadow = 2;
    public static final int RbAuRunningSoftwareUnknown = 3;
    public static final int RbAuAirInterfaceTypeUnknown = 0;
    public static final int RbAuAirInterfaceTypeTypeA = 1;
    public static final int RbAuAirInterfaceTypeTypeSi = 2;
    public static final int RbAuDiversityModeFourthOrder = 3;
    public static final int RbAuDiversityModeNoDiversity = 1;
    public static final int RbAuDiversityModeSecondOrder = 2;
    public static final int RbAuDiversityModeSecondOrderRX = 5;
    public static final int RbAuDiversityModeFourthOrderNLOS = 3;
    public static final int RbAuDiversityModeFourthOrderLOSNLOS = 4;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.1", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuSerialNo() {
        return this.rbAuSerialNo;
    }

    public void setRbAuSerialNo(String rbAuSerialNo) {
        this.rbAuSerialNo = rbAuSerialNo;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.3", type=2)
    @StateAttribute
    public Integer getRbAuFaultStatus() {
        return this.rbAuFaultStatus;
    }

    public void setRbAuFaultStatus(Integer rbAuFaultStatus) {
        this.rbAuFaultStatus = rbAuFaultStatus;
    }

    public static String toStringRbAuFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noFaults(1)";
                break;
            }
            case 2: {
                result = "minor(2)";
                break;
            }
            case 3: {
                result = "major(3)";
                break;
            }
            case 4: {
                result = "critical(4)";
                break;
            }
            case 5: {
                result = "disconnected(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.5", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuIduHwRevision() {
        return this.rbAuIduHwRevision;
    }

    public void setRbAuIduHwRevision(String rbAuIduHwRevision) {
        this.rbAuIduHwRevision = rbAuIduHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.6", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuOperSwFileName() {
        return this.rbAuOperSwFileName;
    }

    public void setRbAuOperSwFileName(String rbAuOperSwFileName) {
        this.rbAuOperSwFileName = rbAuOperSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.7", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuOperSwVersion() {
        return this.rbAuOperSwVersion;
    }

    public void setRbAuOperSwVersion(String rbAuOperSwVersion) {
        this.rbAuOperSwVersion = rbAuOperSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.8", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuShadowSwFileName() {
        return this.rbAuShadowSwFileName;
    }

    public void setRbAuShadowSwFileName(String rbAuShadowSwFileName) {
        this.rbAuShadowSwFileName = rbAuShadowSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.9", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuShadowSwVersion() {
        return this.rbAuShadowSwVersion;
    }

    public void setRbAuShadowSwVersion(String rbAuShadowSwVersion) {
        this.rbAuShadowSwVersion = rbAuShadowSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.10", type=2)
    @InventoryAttribute
    public Integer getRbAuRunningSoftware() {
        return this.rbAuRunningSoftware;
    }

    public void setRbAuRunningSoftware(Integer rbAuRunningSoftware) {
        this.rbAuRunningSoftware = rbAuRunningSoftware;
    }

    public String toStringRbAuRunningSoftware(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "operational(1)";
                break;
            }
            case 2: {
                result = "shadow(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.15", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuIduHwConfigDescription() {
        return this.rbAuIduHwConfigDescription;
    }

    public void setRbAuIduHwConfigDescription(String rbAuIduHwConfigDescription) {
        this.rbAuIduHwConfigDescription = rbAuIduHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.16", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuOduHwConfigDescription() {
        return this.rbAuOduHwConfigDescription;
    }

    public void setRbAuOduHwConfigDescription(String rbAuOduHwConfigDescription) {
        this.rbAuOduHwConfigDescription = rbAuOduHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.18", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @InventoryAttribute
    public String getRbAuOduHwRevision() {
        return this.rbAuOduHwRevision;
    }

    public void setRbAuOduHwRevision(String rbAuOduHwRevision) {
        this.rbAuOduHwRevision = rbAuOduHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.19", type=2)
    @WeakRange(min=0L, max=300L)
    @Filter(filterClass=SwitchingModeOrVersionFilter.class, values={"switchingMode", "1", "softwareVersion", ">=4.5"})
    @ConfigAttribute
    public Integer getRbAuMaxNumberOfCalls() {
        return this.rbAuMaxNumberOfCalls;
    }

    public void setRbAuMaxNumberOfCalls(Integer rbAuMaxNumberOfCalls) {
        this.rbAuMaxNumberOfCalls = rbAuMaxNumberOfCalls;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.20", type=2)
    @StateAttribute
    public Integer getRbAuNumberOfRegisteredSUs() {
        return this.rbAuNumberOfRegisteredSUs;
    }

    public void setRbAuNumberOfRegisteredSUs(Integer rbAuNumberOfRegisteredSUs) {
        this.rbAuNumberOfRegisteredSUs = rbAuNumberOfRegisteredSUs;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.21", type=2)
    @InventoryAttribute
    public Integer getRbAuAirInterfaceType() {
        return this.rbAuAirInterfaceType;
    }

    public void setRbAuAirInterfaceType(Integer rbAuAirInterfaceType) {
        this.rbAuAirInterfaceType = rbAuAirInterfaceType;
    }

    public static String toStringRbAuAirInterfaceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "typeA(1)";
                break;
            }
            case 2: {
                result = "typeSi(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.22", type=66)
    @StateAttribute
    public Long getRbAuCumulativePowerOnTime() {
        return this.rbAuCumulativePowerOnTime;
    }

    public void setRbAuCumulativePowerOnTime(Long rbAuCumulativePowerOnTime) {
        this.rbAuCumulativePowerOnTime = rbAuCumulativePowerOnTime;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.27", type=2)
    @StateAttribute
    public Integer getRbAuActiveVoiceCalls() {
        return this.rbAuActiveVoiceCalls;
    }

    public void setRbAuActiveVoiceCalls(Integer rbAuActiveVoiceCalls) {
        this.rbAuActiveVoiceCalls = rbAuActiveVoiceCalls;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbAuSerialNo=").append(this.rbAuSerialNo).append(", ");
        result.append("rbAuFaultStatus=").append(RbAuConfigEntry.toStringRbAuFaultStatus(this.rbAuFaultStatus)).append(", ");
        result.append("rbAuIduHwRevision=").append(this.rbAuIduHwRevision).append(", ");
        result.append("rbAuOperSwFileName=").append(this.rbAuOperSwFileName).append(", ");
        result.append("rbAuOperSwVersion=").append(this.rbAuOperSwVersion).append(", ");
        result.append("rbAuShadowSwFileName=").append(this.rbAuShadowSwFileName).append(", ");
        result.append("rbAuShadowSwVersion=").append(this.rbAuShadowSwVersion).append(", ");
        result.append("rbAuRunningSoftware=").append(this.toStringRbAuRunningSoftware(this.rbAuRunningSoftware)).append(", ");
        result.append("rbAuIduHwConfigDescription=").append(this.rbAuIduHwConfigDescription).append(", ");
        result.append("rbAuOduHwConfigDescription=").append(this.rbAuOduHwConfigDescription).append(", ");
        result.append("rbAuOduHwRevision=").append(this.rbAuOduHwRevision).append(", ");
        result.append("rbAuMaxNumberOfCalls=").append(this.rbAuMaxNumberOfCalls).append(", ");
        result.append("rbAuActiveVoiceCalls=").append(this.rbAuActiveVoiceCalls).append(", ");
        result.append("rbAuNumberOfRegisteredSUs=").append(this.rbAuNumberOfRegisteredSUs).append(", ");
        result.append("rbAuAirInterfaceType=").append(RbAuConfigEntry.toStringRbAuAirInterfaceType(this.rbAuAirInterfaceType)).append(", ");
        result.append("rbAuCumulativePowerOnTime=").append(this.rbAuCumulativePowerOnTime).append(", ");
        result.append("rbAuIduTemperature=").append(this.rbAuIduTemperature).append(", ");
        result.append("rbAuDiversityMode=").append(RbAuConfigEntry.toStringRbAuDiversityMode(this.rbAuDiversityMode)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSlotNumber().toString();
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.4", type=2)
    @StateAttribute
    public Integer getRbAuIduTemperature() {
        return this.rbAuIduTemperature;
    }

    public void setRbAuIduTemperature(Integer rbAuIduTemperature) {
        this.rbAuIduTemperature = rbAuIduTemperature;
    }

    @Transient
    public boolean isConnected() {
        return this.rbAuFaultStatus != null && this.rbAuFaultStatus != 5;
    }

    @Transient
    public String getRuningSwVersion() {
        if (null == this.rbAuRunningSoftware) {
            this.rbAuRunningSoftware = 3;
        }
        switch (this.rbAuRunningSoftware) {
            case 1: {
                return this.rbAuOperSwVersion;
            }
            case 2: {
                return this.rbAuShadowSwVersion;
            }
        }
        return "";
    }

    @Transient
    public Version getSoftwareVersion() {
        String ver = this.getRuningSwVersion();
        if (ver.startsWith("Rel_")) {
            return VersionFactory.getInstance().createVersion(ver.substring(4), "_");
        }
        return VersionFactory.getInstance().createVersion(ver);
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.9.1.7", type=2)
    @InventoryAttribute
    public Integer getRbAuIduType() {
        return this.rbAuIduType;
    }

    public void setRbAuIduType(Integer rbAuIduType) {
        this.rbAuIduType = rbAuIduType;
    }

    public static String toStringRbAuDiversityMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noDiversity(1)";
                break;
            }
            case 2: {
                result = "secondOrder(2)";
                break;
            }
            case 3: {
                result = "fourthOrder(3)";
                break;
            }
            case 5: {
                result = "secondOrder-RX(5)";
                break;
            }
            default: {
                result = "undefinedValue";
            }
        }
        return result;
    }

    public static String toStringRbAuDiversityModeSw41(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noDiversity(1)";
                break;
            }
            case 2: {
                result = "secondOrder(2)";
                break;
            }
            case 3: {
                result = "fourthOrder-NLOS(3)";
                break;
            }
            case 4: {
                result = "fourthOrder-LOS-NLOS(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.31", type=2)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=3.0"})
    @ConfigAttribute
    public Integer getRbAuDiversityMode() {
        return this.rbAuDiversityMode;
    }

    public void setRbAuDiversityMode(Integer rbAuDiversityMode) {
        this.rbAuDiversityMode = rbAuDiversityMode;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuConfigEntry>(){

            public ManagedObjectAccessHandler<RbAuConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuConfigEntry>(){

            public ManagedObjectAccessHandler<RbAuConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbAuConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbAuConfigEntry, AuDb_Au> {
        private TreeMap<Integer, BwDegradationDb_BwDegradation> bwDegradation;
        static Version sw_V_4_0 = VersionFactory.getInstance().createVersion("4.0");

        private ConfigFileMOAccessHandler() {
        }

        @Override
        public List<RbAuConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(access);
            List<RbAuConfigEntry> auCfgEntries = super.fetch(eq, access, networkResource, instanceQuery);
            Version swVersion = ((RbBaseStationEquipment)eq).getSoftwareVersion();
            if (swVersion.compareTo((Object)sw_V_4_0) >= 0) {
                AuV2Db_AuV2 auV2 = (AuV2Db_AuV2)access.fetchObject(null, AuV2Db_AuV2.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, AuV2Db_AuV2.class)).get(0);
                auCfgEntries.get(0).setRbAuDiversityMode(auV2.getAUDiversity());
            }
            return auCfgEntries;
        }

        @Override
        protected RbAuConfigEntry createEntry() {
            return new RbAuConfigEntry();
        }

        @Override
        protected Class<AuDb_Au> getDataObjectClass() {
            return AuDb_Au.class;
        }

        @Override
        protected void populateEntry(RbAuConfigEntry entry, AuDb_Au dataObject) {
            entry.setRbSlotNumber(ConfigFileUtil.configFileAUIDToRbSlotNumber(dataObject.getAUID()));
            entry.setRbAuMaxNumberOfCalls(dataObject.getMaxCalls());
        }

        private void prefetch(MOAccessSession access) throws MediationException {
            this.bwDegradation = new TreeMap();
            for (BwDegradationDb_BwDegradation bwDeg : access.fetchObject(null, BwDegradationDb_BwDegradation.class)) {
                this.bwDegradation.put(bwDeg.getAUID(), bwDeg);
            }
        }
    }
}

